/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.RewriteAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.sort.SpaceCurveSortingHelper;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RDDSpatialCurveSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final HoodieSparkEngineContext sparkEngineContext;
    private final String[] orderByColumns;
    private final Schema schema;
    private final HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy;
    private final HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType;

    public RDDSpatialCurveSortPartitioner(HoodieSparkEngineContext sparkEngineContext, String[] orderByColumns, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, HoodieClusteringConfig.SpatialCurveCompositionStrategyType curveCompositionStrategyType, Schema schema2) {
        this.sparkEngineContext = sparkEngineContext;
        this.orderByColumns = orderByColumns;
        this.layoutOptStrategy = layoutOptStrategy;
        this.curveCompositionStrategyType = curveCompositionStrategyType;
        this.schema = schema2;
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        SerializableSchema serializableSchema = new SerializableSchema(this.schema);
        JavaRDD genericRecordsRDD = records.map((Function & Serializable)f -> (GenericRecord)((HoodieRecordPayload)f.getData()).getInsertValue(serializableSchema.get()).get());
        Dataset<Row> sourceDataset = AvroConversionUtils.createDataFrame((RDD<GenericRecord>)genericRecordsRDD.rdd(), this.schema.toString(), this.sparkEngineContext.getSqlContext().sparkSession());
        Dataset<Row> sortedDataset = this.reorder(sourceDataset, outputSparkPartitions);
        return HoodieSparkUtils.createRdd(sortedDataset, this.schema.getName(), this.schema.getNamespace(), false, Option.empty()).toJavaRDD().map((Function & Serializable)record -> {
            String key = record.get("_hoodie_record_key").toString();
            String partition = record.get("_hoodie_partition_path").toString();
            HoodieKey hoodieKey = new HoodieKey(key, partition);
            HoodieAvroRecord<RewriteAvroPayload> hoodieRecord = new HoodieAvroRecord<RewriteAvroPayload>(hoodieKey, new RewriteAvroPayload((GenericRecord)record));
            return hoodieRecord;
        });
    }

    private Dataset<Row> reorder(Dataset<Row> dataset, int numOutputGroups) {
        if (this.orderByColumns.length == 0) {
            return dataset;
        }
        List<String> orderedCols = Arrays.asList(this.orderByColumns);
        switch (this.curveCompositionStrategyType) {
            case DIRECT: {
                return SpaceCurveSortingHelper.orderDataFrameByMappingValues(dataset, this.layoutOptStrategy, orderedCols, numOutputGroups);
            }
            case SAMPLE: {
                return SpaceCurveSortingHelper.orderDataFrameBySamplingValues(dataset, this.layoutOptStrategy, orderedCols, numOutputGroups);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported space-curve curve building strategy (%s)", new Object[]{this.curveCompositionStrategyType}));
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

