/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.com.beust.jcommander.JCommander;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommit;
import org.apache.hudi.hive.replication.HiveSyncGlobalCommitConfig;
import org.apache.hudi.hive.replication.ReplicationStateSync;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HiveSyncGlobalCommitTool
implements HiveSyncGlobalCommit,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(HiveSyncGlobalCommitTool.class);
    private final HiveSyncGlobalCommitConfig config;
    private List<ReplicationStateSync> replicationStateSyncList;

    private ReplicationStateSync getReplicatedState(boolean forRemote) {
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(new Path(this.config.properties.getProperty(forRemote ? HiveSyncGlobalCommitConfig.REMOTE_HIVE_SITE_URI : HiveSyncGlobalCommitConfig.LOCAL_HIVE_SITE_URI)));
        ReplicationStateSync state = new ReplicationStateSync(this.config.mkGlobalHiveSyncConfig(forRemote), hiveConf, forRemote ? "REMOTESYNC" : "LOCALSYNC");
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() {
        String name = Thread.currentThread().getName();
        try {
            for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
                Thread.currentThread().setName(stateSync.getClusterId());
                LOG.info((Object)("starting sync for state " + stateSync));
                stateSync.sync();
                LOG.info((Object)("synced state " + stateSync));
            }
        }
        catch (Exception e) {
            Thread.currentThread().setName(name);
            LOG.error((Object)String.format("Error while trying to commit replication state %s", e.getMessage()), (Throwable)e);
            boolean stateSync = false;
            return stateSync;
        }
        finally {
            Thread.currentThread().setName(name);
        }
        LOG.info((Object)"done syncing to all tables, verifying the timestamps...");
        ReplicationStateSync base = this.replicationStateSyncList.get(0);
        boolean success = true;
        LOG.info((Object)("expecting all timestamps to be similar to: " + base));
        for (int idx = 1; idx < this.replicationStateSyncList.size(); ++idx) {
            ReplicationStateSync other = this.replicationStateSyncList.get(idx);
            if (base.replicationStateIsInSync(other)) continue;
            LOG.error((Object)("the timestamp of other : " + other + " is not matching with base: " + base));
            success = false;
        }
        return success;
    }

    @Override
    public boolean rollback() {
        for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
            stateSync.rollback();
        }
        return true;
    }

    public HiveSyncGlobalCommitTool(HiveSyncGlobalCommitConfig config) {
        this.config = config;
        this.replicationStateSyncList = new ArrayList<ReplicationStateSync>(2);
        this.replicationStateSyncList.add(this.getReplicatedState(false));
        this.replicationStateSyncList.add(this.getReplicatedState(true));
    }

    private static HiveSyncGlobalCommitConfig getHiveSyncGlobalCommitConfig(String[] args) throws IOException {
        HiveSyncGlobalCommitConfig cfg = new HiveSyncGlobalCommitConfig();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        cfg.load();
        return cfg;
    }

    @Override
    public void close() {
        for (ReplicationStateSync stateSync : this.replicationStateSyncList) {
            stateSync.close();
        }
    }

    public static void main(String[] args) throws IOException, HoodieHiveSyncException {
        HiveSyncGlobalCommitConfig cfg = HiveSyncGlobalCommitTool.getHiveSyncGlobalCommitConfig(args);
        try (HiveSyncGlobalCommitTool globalCommitTool = new HiveSyncGlobalCommitTool(cfg);){
            boolean success = globalCommitTool.commit();
            if (!success && !globalCommitTool.rollback()) {
                throw new RuntimeException("not able to rollback failed commit");
            }
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("not able to commit replicated timestamp", e);
        }
    }
}

