/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieBucketIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LogManager.getLogger(HoodieBucketIndex.class);
    private final int numBuckets;

    public HoodieBucketIndex(HoodieWriteConfig config) {
        super(config);
        this.numBuckets = config.getBucketIndexNumBuckets();
        LOG.info((Object)("use bucket index, numBuckets=" + this.numBuckets));
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        return writeStatuses;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        HoodieData<HoodieRecord<R>> taggedRecords = records.mapPartitions(recordIter -> {
            HashMap partitionPathFileIDList = new HashMap();
            return new LazyIterableIterator<HoodieRecord<R>, HoodieRecord<R>>((Iterator)recordIter, (Iterator)recordIter, partitionPathFileIDList, hoodieTable){
                final /* synthetic */ Iterator val$recordIter;
                final /* synthetic */ Map val$partitionPathFileIDList;
                final /* synthetic */ HoodieTable val$hoodieTable;
                {
                    this.val$recordIter = iterator2;
                    this.val$partitionPathFileIDList = map;
                    this.val$hoodieTable = hoodieTable;
                    super(in);
                }

                @Override
                protected void start() {
                }

                @Override
                protected HoodieRecord<R> computeNext() {
                    HoodieRecord record = (HoodieRecord)this.val$recordIter.next();
                    int bucketId = BucketIdentifier.getBucketId(record, HoodieBucketIndex.this.config.getBucketIndexHashField(), HoodieBucketIndex.this.numBuckets);
                    String partitionPath = record.getPartitionPath();
                    if (!this.val$partitionPathFileIDList.containsKey(partitionPath)) {
                        this.val$partitionPathFileIDList.put(partitionPath, HoodieBucketIndex.this.loadPartitionBucketIdFileIdMapping(this.val$hoodieTable, partitionPath));
                    }
                    if (((Map)this.val$partitionPathFileIDList.get(partitionPath)).containsKey(bucketId)) {
                        Pair fileInfo = (Pair)((Map)this.val$partitionPathFileIDList.get(partitionPath)).get(bucketId);
                        return HoodieIndexUtils.getTaggedRecord(record, Option.of(new HoodieRecordLocation((String)fileInfo.getRight(), (String)fileInfo.getLeft())));
                    }
                    return record;
                }

                @Override
                protected void end() {
                }
            };
        }, true);
        return taggedRecords;
    }

    private Map<Integer, Pair<String, String>> loadPartitionBucketIdFileIdMapping(HoodieTable hoodieTable, String partition) {
        HashMap<Integer, Pair<String, String>> fileIDList = new HashMap<Integer, Pair<String, String>>();
        HoodieIndexUtils.getLatestBaseFilesForPartition(partition, hoodieTable).forEach(file -> {
            String fileId = file.getFileId();
            String commitTime = file.getCommitTime();
            int bucketId = BucketIdentifier.bucketIdFromFileId(fileId);
            if (fileIDList.containsKey(bucketId)) {
                throw new HoodieIOException("Find multiple files at partition path=" + partition + " belongs to the same bucket id = " + bucketId);
            }
            fileIDList.put(bucketId, Pair.of(fileId, commitTime));
        });
        return fileIDList;
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    @Override
    public boolean requiresTagging(WriteOperationType operationType) {
        switch (operationType) {
            case INSERT: 
            case INSERT_OVERWRITE: 
            case UPSERT: {
                return true;
            }
        }
        return false;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }
}

