/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class NonpartitionedAvroKeyGenerator
extends BaseKeyGenerator {
    private static final String EMPTY_PARTITION = "";
    private static final List<String> EMPTY_PARTITION_FIELD_LIST = new ArrayList<String>();

    public NonpartitionedAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = EMPTY_PARTITION_FIELD_LIST;
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return EMPTY_PARTITION;
    }

    @Override
    public List<String> getPartitionPathFields() {
        return EMPTY_PARTITION_FIELD_LIST;
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        if (this.getRecordKeyFieldNames().size() == 1) {
            return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields().get(0), this.isConsistentLogicalTimestampEnabled());
        }
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields(), this.isConsistentLogicalTimestampEnabled());
    }

    public String getEmptyPartition() {
        return EMPTY_PARTITION;
    }
}

