/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class TimestampBasedKeyGenerator
extends SimpleKeyGenerator {
    private final TimestampBasedAvroKeyGenerator timestampBasedAvroKeyGenerator;

    public TimestampBasedKeyGenerator(TypedProperties config) throws IOException {
        this(config, config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()), config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()));
    }

    TimestampBasedKeyGenerator(TypedProperties config, String partitionPathField) throws IOException {
        this(config, null, partitionPathField);
    }

    TimestampBasedKeyGenerator(TypedProperties config, String recordKeyField, String partitionPathField) throws IOException {
        super(config, recordKeyField, partitionPathField);
        this.timestampBasedAvroKeyGenerator = new TimestampBasedAvroKeyGenerator(config, recordKeyField, partitionPathField);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.timestampBasedAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeySchemaInfo, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        this.buildFieldSchemaInfoIfNeeded(row.schema());
        Object partitionPathFieldVal = RowKeyGeneratorHelper.getNestedFieldVal(row, (List)((Pair)this.partitionPathSchemaInfo.get(this.getPartitionPathFields().get(0))).getKey());
        return this.getTimestampBasedPartitionPath(partitionPathFieldVal);
    }

    @Override
    public String getPartitionPath(InternalRow internalRow, StructType structType) {
        this.buildFieldSchemaInfoIfNeeded(structType);
        this.validatePartitionFieldsForInternalRow();
        Object partitionPathFieldVal = RowKeyGeneratorHelper.getFieldValFromInternalRow(internalRow, (Integer)((List)((Pair)this.partitionPathSchemaInfo.get(this.getPartitionPathFields().get(0))).getKey()).get(0), (DataType)((Pair)this.partitionPathSchemaInfo.get(this.getPartitionPathFields().get(0))).getValue());
        return this.getTimestampBasedPartitionPath(partitionPathFieldVal);
    }

    private String getTimestampBasedPartitionPath(Object partitionPathFieldVal) {
        Object fieldVal = null;
        try {
            fieldVal = partitionPathFieldVal == null || partitionPathFieldVal.toString().contains("default") || partitionPathFieldVal.toString().contains("__null__") || partitionPathFieldVal.toString().contains("__empty__") ? this.timestampBasedAvroKeyGenerator.getDefaultPartitionVal() : partitionPathFieldVal;
            return this.timestampBasedAvroKeyGenerator.getPartitionPath(fieldVal);
        }
        catch (Exception e) {
            throw new HoodieKeyGeneratorException("Unable to parse input partition field :" + fieldVal, e);
        }
    }
}

