/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.websocket.common.extensions;

import org.apache.hudi.org.apache.jetty.util.StringUtil;
import org.apache.hudi.org.apache.jetty.websocket.api.WebSocketException;
import org.apache.hudi.org.apache.jetty.websocket.api.extensions.Extension;
import org.apache.hudi.org.apache.jetty.websocket.api.extensions.ExtensionConfig;
import org.apache.hudi.org.apache.jetty.websocket.api.extensions.ExtensionFactory;
import org.apache.hudi.org.apache.jetty.websocket.common.extensions.AbstractExtension;
import org.apache.hudi.org.apache.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketExtensionFactory
extends ExtensionFactory {
    private WebSocketContainerScope container;

    public WebSocketExtensionFactory(WebSocketContainerScope container) {
        this.container = container;
    }

    @Override
    public Extension newInstance(ExtensionConfig config) {
        if (config == null) {
            return null;
        }
        String name = config.getName();
        if (StringUtil.isBlank(name)) {
            return null;
        }
        Class<? extends Extension> extClass = this.getExtension(name);
        if (extClass == null) {
            return null;
        }
        try {
            Extension ext = this.container.getObjectFactory().createInstance(extClass);
            if (ext instanceof AbstractExtension) {
                AbstractExtension aext = (AbstractExtension)ext;
                aext.init(this.container);
                aext.setConfig(config);
            }
            return ext;
        }
        catch (Exception e) {
            throw new WebSocketException("Cannot instantiate extension: " + extClass, e);
        }
    }
}

