/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.Option;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class WriteMarkers
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(WriteMarkers.class);
    protected final String basePath;
    protected final transient Path markerDirPath;
    protected final String instantTime;

    public WriteMarkers(String basePath, String markerFolderPath, String instantTime) {
        this.basePath = basePath;
        this.markerDirPath = new Path(markerFolderPath);
        this.instantTime = instantTime;
    }

    public Option<Path> create(String partitionPath, String dataFileName, IOType type) {
        return this.create(partitionPath, dataFileName, type, false);
    }

    public Option<Path> createIfNotExists(String partitionPath, String dataFileName, IOType type) {
        return this.create(partitionPath, dataFileName, type, true);
    }

    public void quietDeleteMarkerDir(HoodieEngineContext context, int parallelism) {
        try {
            context.setJobStatus(this.getClass().getSimpleName(), "Deleting marker directory: " + this.basePath);
            this.deleteMarkerDir(context, parallelism);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error deleting marker directory for instant " + this.instantTime), (Throwable)e);
        }
    }

    public static String stripMarkerSuffix(String path) {
        return path.substring(0, path.indexOf(".marker"));
    }

    protected String getMarkerFileName(String dataFileName, IOType type) {
        return String.format("%s%s.%s", dataFileName, ".marker", type.name());
    }

    protected Path getMarkerPath(String partitionPath, String dataFileName, IOType type) {
        Path path = FSUtils.getPartitionPath(this.markerDirPath, partitionPath);
        String markerFileName = this.getMarkerFileName(dataFileName, type);
        return new Path(path, markerFileName);
    }

    public abstract boolean deleteMarkerDir(HoodieEngineContext var1, int var2);

    public abstract boolean doesMarkerDirExist() throws IOException;

    public abstract Set<String> createdAndMergedDataPaths(HoodieEngineContext var1, int var2) throws IOException;

    public abstract Set<String> allMarkerFilePaths() throws IOException;

    abstract Option<Path> create(String var1, String var2, IOType var3, boolean var4);
}

