/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.util.Locale;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.hudi.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001=\u0011!\u0003S8pI&,7)\u0019;bY><G+\u00192mK*\u00111\u0001B\u0001\bG\u0006$\u0018\r\\8h\u0015\t)a!\u0001\u0005dCR\fG._:u\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005mA\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0013\u0001\u0011)\u0019!C\u0001;U\ta\u0004\u0005\u0002 A5\ta!\u0003\u0002\"\r\ta1\u000b]1sWN+7o]5p]\"A1\u0005\u0001B\u0001B\u0003%a$\u0001\u0004ta\u0006\u00148\u000e\t\u0005\tK\u0001\u0011\t\u0019!C\u0001M\u0005)A/\u00192mKV\tq\u0005\u0005\u0002)S5\t!!\u0003\u0002+\u0005\ta1)\u0019;bY><G+\u00192mK\"AA\u0006\u0001BA\u0002\u0013\u0005Q&A\u0005uC\ndWm\u0018\u0013fcR\u0011a&\r\t\u0003#=J!\u0001\r\n\u0003\tUs\u0017\u000e\u001e\u0005\be-\n\t\u00111\u0001(\u0003\rAH%\r\u0005\ti\u0001\u0011\t\u0011)Q\u0005O\u00051A/\u00192mK\u0002BQA\u000e\u0001\u0005\u0002]\na\u0001P5oSRtDc\u0001\u001d:uA\u0011\u0001\u0006\u0001\u0005\u0006\u0013U\u0002\rA\b\u0005\u0006KU\u0002\ra\n\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0003)A\u0017\rZ8pa\u000e{gNZ\u000b\u0002}A\u0011q\bR\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005G>tgM\u0003\u0002D\u0015\u00051\u0001.\u00193p_BL!!\u0012!\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u00199\u0005\u0001)A\u0005}\u0005Y\u0001.\u00193p_B\u001cuN\u001c4!\u0011\u001dI\u0005A1A\u0005\u0002)\u000b\u0001cY1uC2|w\rV1cY\u0016t\u0015-\\3\u0016\u0003-\u0003\"\u0001T(\u000f\u0005Ei\u0015B\u0001(\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059\u0013\u0002BB*\u0001A\u0003%1*A\tdCR\fGn\\4UC\ndWMT1nK\u0002Bq!\u0016\u0001C\u0002\u0013\u0005a+A\tdCR\fGn\\4Qe>\u0004XM\u001d;jKN,\u0012a\u0016\t\u0005\u0019b[5*\u0003\u0002Z#\n\u0019Q*\u00199\t\rm\u0003\u0001\u0015!\u0003X\u0003I\u0019\u0017\r^1m_\u001e\u0004&o\u001c9feRLWm\u001d\u0011\t\u000fu\u0003!\u0019!C\u0001\u0015\u0006iA/\u00192mK2{7-\u0019;j_:Daa\u0018\u0001!\u0002\u0013Y\u0015A\u0004;bE2,Gj\\2bi&|g\u000e\t\u0005\bC\u0002\u0011\r\u0011\"\u0001c\u0003EAwn\u001c3jKR\u000b'\r\\3Fq&\u001cHo]\u000b\u0002GB\u0011\u0011\u0003Z\u0005\u0003KJ\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004h\u0001\u0001\u0006IaY\u0001\u0013Q>|G-[3UC\ndW-\u0012=jgR\u001c\b\u0005\u0003\u0005j\u0001!\u0015\r\u0011\"\u0001k\u0003)iW\r^1DY&,g\u000e^\u000b\u0002WB\u0011AN]\u0007\u0002[*\u0011QE\u001c\u0006\u0003_B\faaY8n[>t'BA9\u000b\u0003\u0011AW\u000fZ5\n\u0005Ml'!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\tk\u0002A\t\u0011)Q\u0005W\u0006YQ.\u001a;b\u00072LWM\u001c;!\u0011!9\b\u0001#b\u0001\n\u0003A\u0018a\u0003;bE2,7i\u001c8gS\u001e,\u0012!\u001f\t\u0003YjL!a_7\u0003#!{w\u000eZ5f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005~\u0001!\u0005\t\u0015)\u0003z\u00031!\u0018M\u00197f\u0007>tg-[4!\u0011!y\b\u0001#b\u0001\n\u0003Q\u0015!\u0003;bE2,g*Y7f\u0011%\t\u0019\u0001\u0001E\u0001B\u0003&1*\u0001\u0006uC\ndWMT1nK\u0002B!\"a\u0002\u0001\u0011\u000b\u0007I\u0011AA\u0005\u0003%!\u0018M\u00197f)f\u0004X-\u0006\u0002\u0002\fA!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u00129\fQ!\\8eK2LA!!\u0006\u0002\u0010\ty\u0001j\\8eS\u0016$\u0016M\u00197f)f\u0004X\r\u0003\u0006\u0002\u001a\u0001A\t\u0011)Q\u0005\u0003\u0017\t!\u0002^1cY\u0016$\u0016\u0010]3!\u0011%\ti\u0002\u0001EC\u0002\u0013\u0005!*A\u0007uC\ndW\rV=qK:\u000bW.\u001a\u0005\n\u0003C\u0001\u0001\u0012!Q!\n-\u000ba\u0002^1cY\u0016$\u0016\u0010]3OC6,\u0007\u0005\u0003\u0006\u0002&\u0001A)\u0019!C\u0001\u0003O\t1\u0002\u001d:j[\u0006\u0014\u0018pS3zgV\u0011\u0011\u0011\u0006\t\u0005#\u0005-2*C\u0002\u0002.I\u0011Q!\u0011:sCfD!\"!\r\u0001\u0011\u0003\u0005\u000b\u0015BA\u0015\u00031\u0001(/[7bef\\U-_:!\u0011)\t)\u0004\u0001EC\u0002\u0013\u0005\u0011qG\u0001\u000eaJ,7i\\7cS:,7*Z=\u0016\u0005\u0005e\u0002\u0003B\t\u0002<-K1!!\u0010\u0013\u0005\u0019y\u0005\u000f^5p]\"Q\u0011\u0011\t\u0001\t\u0002\u0003\u0006K!!\u000f\u0002\u001dA\u0014XmQ8nE&tWmS3zA!Q\u0011Q\t\u0001\t\u0006\u0004%\t!a\n\u0002\u001fA\f'\u000f^5uS>tg)[3mIND!\"!\u0013\u0001\u0011\u0003\u0005\u000b\u0015BA\u0015\u0003A\u0001\u0018M\u001d;ji&|gNR5fY\u0012\u001c\b\u0005C\u0005\u0002N\u0001A)\u0019!C\u0001\u0015\u0006q!-Y:f\r&dWMR8s[\u0006$\b\"CA)\u0001!\u0005\t\u0015)\u0003L\u0003=\u0011\u0017m]3GS2,gi\u001c:nCR\u0004\u0003BCA+\u0001!\u0015\r\u0011\"\u0001\u0002X\u0005YA/\u00192mKN\u001b\u0007.Z7b+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyFB\u0001\u0006if\u0004Xm]\u0005\u0005\u0003G\niF\u0001\u0006TiJ,8\r\u001e+za\u0016D!\"a\u001a\u0001\u0011\u0003\u0005\u000b\u0015BA-\u00031!\u0018M\u00197f'\u000eDW-\\1!\u0011)\tY\u0007\u0001EC\u0002\u0013\u0005\u0011qK\u0001\u001di\u0006\u0014G.Z*dQ\u0016l\u0017mV5uQ>,H/T3uC\u001aKW\r\u001c3t\u0011)\ty\u0007\u0001E\u0001B\u0003&\u0011\u0011L\u0001\u001ei\u0006\u0014G.Z*dQ\u0016l\u0017mV5uQ>,H/T3uC\u001aKW\r\u001c3tA!Q\u00111\u000f\u0001\t\u0006\u0004%\t!a\u0016\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0003\u0006\u0002x\u0001A\t\u0011)Q\u0005\u00033\n1\u0002Z1uCN\u001b\u0007.Z7bA!Q\u00111\u0010\u0001\t\u0006\u0004%\t!a\u0016\u00027\u0011\fG/Y*dQ\u0016l\u0017mV5uQ>,H/T3uC\u001aKW\r\u001c3t\u0011)\ty\b\u0001E\u0001B\u0003&\u0011\u0011L\u0001\u001dI\u0006$\u0018mU2iK6\fw+\u001b;i_V$X*\u001a;b\r&,G\u000eZ:!\u0011)\t\u0019\t\u0001EC\u0002\u0013\u0005\u0011qK\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"Q\u0011q\u0011\u0001\t\u0002\u0003\u0006K!!\u0017\u0002!A\f'\u000f^5uS>t7k\u00195f[\u0006\u0004\u0003bBAF\u0001\u0011\u0005\u0011QR\u0001\u0012O\u0016$\b+\u0019:uSRLwN\u001c)bi\"\u001cXCAAH!\u0015\t\t*!)L\u001d\u0011\t\u0019*!(\u000f\t\u0005U\u00151T\u0007\u0003\u0003/S1!!'\u000f\u0003\u0019a$o\\8u}%\t1#C\u0002\u0002 J\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0006\u0015&aA*fc*\u0019\u0011q\u0014\n\t\r\u0005%\u0006\u0001\"\u0001c\u0003II7\u000fU1si&$\u0018n\u001c8fIR\u000b'\r\\3\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006y\u0011N\\5u\u0011>|G-[3UC\ndW\rF\u0001/\u0011\u001d\t\u0019\f\u0001C\u0005\u0003k\u000bQ\u0003]1sg\u0016\u001c6\r[3nC\u0006sGmQ8oM&<7\u000f\u0006\u0002\u00028B1\u0011#!/\u0002Z]K1!a/\u0013\u0005\u0019!V\u000f\u001d7fe!9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0017\u0001E3yiJ\fG+\u00192mK\u000e{gNZ5h)\u00159\u00161YAd\u0011\u001d\t)-!0A\u0002\r\f1\u0002^1cY\u0016,\u00050[:ug\"I\u0011\u0011ZA_!\u0003\u0005\raV\u0001\u0012_JLw-\u001b8UC\ndWmQ8oM&<\u0007bBAg\u0001\u0011%\u0011qZ\u0001\u001cY>\fG\rV1cY\u0016\u001c6\r[3nC\nKX*\u001a;b\u00072LWM\u001c;\u0015\u0005\u0005E\u0007#B\t\u0002<\u0005e\u0003bBAk\u0001\u0011%\u0011q[\u0001\u0011m\u0016\u0014\u0018NZ=ECR\f7k\u00195f[\u0006$rALAm\u0003K\fi\u000f\u0003\u0005\u0002\\\u0006M\u0007\u0019AAo\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0003BAp\u0003Cl\u0011\u0001B\u0005\u0004\u0003G$!a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011\u0005\u001d\u00111\u001ba\u0001\u0003O\u00042\u0001KAu\u0013\r\tYO\u0001\u0002\u0011\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a+za\u0016D\u0001\"a\u001d\u0002T\u0002\u0007\u0011q\u001e\t\u0007\u0003#\u000b\t+!=\u0011\t\u0005m\u00131_\u0005\u0005\u0003k\fiFA\u0006TiJ,8\r\u001e$jK2$\u0007\"CA}\u0001E\u0005I\u0011BA~\u0003i)\u0007\u0010\u001e:b)\u0006\u0014G.Z\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00133+\t\tiPK\u0002X\u0003\u007f\\#A!\u0001\u0011\t\t\r!QB\u0007\u0003\u0005\u000bQAAa\u0002\u0003\n\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0017\u0011\u0012AC1o]>$\u0018\r^5p]&!!q\u0002B\u0003\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\b\u0005'\u0011\u0001\u0012\u0001B\u000b\u0003IAun\u001c3jK\u000e\u000bG/\u00197pOR\u000b'\r\\3\u0011\u0007!\u00129B\u0002\u0004\u0002\u0005!\u0005!\u0011D\n\u0004\u0005/\u0001\u0002b\u0002\u001c\u0003\u0018\u0011\u0005!Q\u0004\u000b\u0003\u0005+A!B!\t\u0003\u0018\t\u0007I\u0011\u0001B\u0012\u0003=qW-\u001a3GS2$XM\u001d)s_B\u001cXC\u0001B\u0013!\u0015\t\tJa\nL\u0013\u0011\u0011I#!*\u0003\t1K7\u000f\u001e\u0005\n\u0005[\u00119\u0002)A\u0005\u0005K\t\u0001C\\3fI\u001aKG\u000e^3s!J|\u0007o\u001d\u0011\t\u0011\tE\"q\u0003C\u0001\u0005g\tQ!\u00199qYf$R\u0001\u000fB\u001b\u0005sAqAa\u000e\u00030\u0001\u0007a$\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0003\u0005\u0002\\\n=\u0002\u0019AAo\u0011!\u0011\tDa\u0006\u0005\u0002\tuB#\u0002\u001d\u0003@\t\u0005\u0003b\u0002B\u001c\u0005w\u0001\rA\b\u0005\b\u0005\u0007\u0012Y\u00041\u0001(\u00031\u0019\u0017\r^1m_\u001e$\u0016M\u00197f\u0001")
public class HoodieCatalogTable
implements Logging {
    private final SparkSession spark;
    private CatalogTable table;
    private final Configuration hadoopConf;
    private final String catalogTableName;
    private final scala.collection.immutable.Map<String, String> catalogProperties;
    private final String tableLocation;
    private final boolean hoodieTableExists;
    private HoodieTableMetaClient metaClient;
    private HoodieTableConfig tableConfig;
    private String tableName;
    private HoodieTableType tableType;
    private String tableTypeName;
    private String[] primaryKeys;
    private Option<String> preCombineKey;
    private String[] partitionFields;
    private String baseFileFormat;
    private StructType tableSchema;
    private StructType tableSchemaWithoutMetaFields;
    private StructType dataSchema;
    private StructType dataSchemaWithoutMetaFields;
    private StructType partitionSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile int bitmap$0;

    public static HoodieCatalogTable apply(SparkSession sparkSession, CatalogTable catalogTable) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, catalogTable);
    }

    public static HoodieCatalogTable apply(SparkSession sparkSession, TableIdentifier tableIdentifier) {
        return HoodieCatalogTable$.MODULE$.apply(sparkSession, tableIdentifier);
    }

    public static List<String> needFilterProps() {
        return HoodieCatalogTable$.MODULE$.needFilterProps();
    }

    private HoodieTableMetaClient metaClient$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.metaClient = HoodieTableMetaClient.builder().setBasePath(this.tableLocation()).setConf(this.hadoopConf()).build();
                this.bitmap$0 |= 1;
            }
            return this.metaClient;
        }
    }

    private HoodieTableConfig tableConfig$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 2) == 0) {
                this.tableConfig = this.metaClient().getTableConfig();
                this.bitmap$0 |= 2;
            }
            return this.tableConfig;
        }
    }

    private String tableName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 4) == 0) {
                this.tableName = this.tableConfig().getTableName();
                this.bitmap$0 |= 4;
            }
            return this.tableName;
        }
    }

    private HoodieTableType tableType$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 8) == 0) {
                this.tableType = this.tableConfig().getTableType();
                this.bitmap$0 |= 8;
            }
            return this.tableType;
        }
    }

    private String tableTypeName$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.tableTypeName = this.tableType().name();
                this.bitmap$0 |= 0x10;
            }
            return this.tableTypeName;
        }
    }

    private String[] primaryKeys$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.primaryKeys = this.tableConfig().getRecordKeyFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x20;
            }
            return this.primaryKeys;
        }
    }

    private Option preCombineKey$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.preCombineKey = Option$.MODULE$.apply((Object)this.tableConfig().getPreCombineField());
                this.bitmap$0 |= 0x40;
            }
            return this.preCombineKey;
        }
    }

    private String[] partitionFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.partitionFields = this.tableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                this.bitmap$0 |= 0x80;
            }
            return this.partitionFields;
        }
    }

    private String baseFileFormat$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.baseFileFormat = this.metaClient().getTableConfig().getBaseFileFormat().name();
                this.bitmap$0 |= 0x100;
            }
            return this.baseFileFormat;
        }
    }

    private StructType tableSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.tableSchema = this.table().schema();
                this.bitmap$0 |= 0x200;
            }
            return this.tableSchema;
        }
    }

    private StructType tableSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.tableSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.tableSchema());
                this.bitmap$0 |= 0x400;
            }
            return this.tableSchemaWithoutMetaFields;
        }
    }

    private StructType dataSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.dataSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x800;
            }
            return this.dataSchema;
        }
    }

    private StructType dataSchemaWithoutMetaFields$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.dataSchemaWithoutMetaFields = HoodieSqlCommonUtils$.MODULE$.removeMetaFields(this.dataSchema());
                this.bitmap$0 |= 0x1000;
            }
            return this.dataSchemaWithoutMetaFields;
        }
    }

    private StructType partitionSchema$lzycompute() {
        HoodieCatalogTable hoodieCatalogTable = this;
        synchronized (hoodieCatalogTable) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.partitionSchema = StructType$.MODULE$.apply((Seq)this.tableSchema().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;

                    public final boolean apply(StructField f) {
                        return Predef$.MODULE$.refArrayOps((Object[])this.$outer.partitionFields()).contains((Object)f.name());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.bitmap$0 |= 0x2000;
            }
            return this.partitionSchema;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public CatalogTable table() {
        return this.table;
    }

    public void table_$eq(CatalogTable x$1) {
        this.table = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String catalogTableName() {
        return this.catalogTableName;
    }

    public scala.collection.immutable.Map<String, String> catalogProperties() {
        return this.catalogProperties;
    }

    public String tableLocation() {
        return this.tableLocation;
    }

    public boolean hoodieTableExists() {
        return this.hoodieTableExists;
    }

    public HoodieTableMetaClient metaClient() {
        return (this.bitmap$0 & 1) == 0 ? this.metaClient$lzycompute() : this.metaClient;
    }

    public HoodieTableConfig tableConfig() {
        return (this.bitmap$0 & 2) == 0 ? this.tableConfig$lzycompute() : this.tableConfig;
    }

    public String tableName() {
        return (this.bitmap$0 & 4) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    public HoodieTableType tableType() {
        return (this.bitmap$0 & 8) == 0 ? this.tableType$lzycompute() : this.tableType;
    }

    public String tableTypeName() {
        return (this.bitmap$0 & 0x10) == 0 ? this.tableTypeName$lzycompute() : this.tableTypeName;
    }

    public String[] primaryKeys() {
        return (this.bitmap$0 & 0x20) == 0 ? this.primaryKeys$lzycompute() : this.primaryKeys;
    }

    public Option<String> preCombineKey() {
        return (this.bitmap$0 & 0x40) == 0 ? this.preCombineKey$lzycompute() : this.preCombineKey;
    }

    public String[] partitionFields() {
        return (this.bitmap$0 & 0x80) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    public String baseFileFormat() {
        return (this.bitmap$0 & 0x100) == 0 ? this.baseFileFormat$lzycompute() : this.baseFileFormat;
    }

    public StructType tableSchema() {
        return (this.bitmap$0 & 0x200) == 0 ? this.tableSchema$lzycompute() : this.tableSchema;
    }

    public StructType tableSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x400) == 0 ? this.tableSchemaWithoutMetaFields$lzycompute() : this.tableSchemaWithoutMetaFields;
    }

    public StructType dataSchema() {
        return (this.bitmap$0 & 0x800) == 0 ? this.dataSchema$lzycompute() : this.dataSchema;
    }

    public StructType dataSchemaWithoutMetaFields() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.dataSchemaWithoutMetaFields$lzycompute() : this.dataSchemaWithoutMetaFields;
    }

    public StructType partitionSchema() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    public Seq<String> getPartitionPaths() {
        return HoodieSqlCommonUtils$.MODULE$.getAllPartitionPaths(this.spark(), this.table());
    }

    public boolean isPartitionedTable() {
        return this.table().partitionColumnNames().nonEmpty();
    }

    public void initHoodieTable() {
        Tuple2<StructType, scala.collection.immutable.Map<String, String>> tuple2;
        block2: {
            Tuple2<String, String> tuple22;
            block5: {
                block4: {
                    Tuple2 tuple23;
                    Properties properties;
                    StructType finalSchema;
                    block3: {
                        Tuple2 tuple24;
                        this.logInfo((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ HoodieCatalogTable $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Init hoodie.properties for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.table().identifier().unquotedString()}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        tuple2 = this.parseSchemaAndConfigs();
                        if (tuple2 == null) break block2;
                        StructType finalSchema2 = (StructType)tuple2._1();
                        scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple2._2();
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)finalSchema2, (Object)tableConfigs);
                        finalSchema = (StructType)tuple25._1();
                        scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple25._2();
                        CatalogTable qual$1 = this.table();
                        StructType x$6 = finalSchema;
                        TableIdentifier x$7 = qual$1.copy$default$1();
                        CatalogTableType x$8 = qual$1.copy$default$2();
                        CatalogStorageFormat x$9 = qual$1.copy$default$3();
                        Option x$10 = qual$1.copy$default$5();
                        Seq x$11 = qual$1.copy$default$6();
                        Option x$12 = qual$1.copy$default$7();
                        String x$13 = qual$1.copy$default$8();
                        long x$14 = qual$1.copy$default$9();
                        long x$15 = qual$1.copy$default$10();
                        String x$16 = qual$1.copy$default$11();
                        scala.collection.immutable.Map x$17 = qual$1.copy$default$12();
                        Option x$18 = qual$1.copy$default$13();
                        Option x$19 = qual$1.copy$default$14();
                        Option x$20 = qual$1.copy$default$15();
                        Seq x$21 = qual$1.copy$default$16();
                        boolean x$22 = qual$1.copy$default$17();
                        boolean x$23 = qual$1.copy$default$18();
                        scala.collection.immutable.Map x$24 = qual$1.copy$default$19();
                        this.table_$eq(qual$1.copy(x$7, x$8, x$9, x$6, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24));
                        properties = new Properties();
                        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableConfigs2).asJava()));
                        if (!this.hoodieTableExists()) break block3;
                        HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setTableCreateSchema(SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema, SchemaConverters$.MODULE$.toAvroType$default$2(), SchemaConverters$.MODULE$.toAvroType$default$3(), SchemaConverters$.MODULE$.toAvroType$default$4()).toString()).initTable(this.hadoopConf(), this.tableLocation());
                        break block4;
                    }
                    tuple22 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.table().identifier().table());
                    if (tuple22 == null) break block5;
                    String recordName = (String)tuple22._1();
                    String namespace = (String)tuple22._2();
                    Tuple2 tuple26 = tuple23 = new Tuple2((Object)recordName, (Object)namespace);
                    String recordName2 = (String)tuple26._1();
                    String namespace2 = (String)tuple26._2();
                    Schema schema2 = SchemaConverters$.MODULE$.toAvroType((DataType)finalSchema, false, recordName2, namespace2);
                    String hoodieDatabaseName = HoodieSqlCommonUtils$.MODULE$.formatName(this.spark(), (String)this.table().identifier().database().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HoodieCatalogTable $outer;

                        public final String apply() {
                            return this.$outer.spark().sessionState().catalog().getCurrentDatabase();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    HoodieTableMetaClient.withPropertyBuilder().fromProperties(properties).setDatabaseName(hoodieDatabaseName).setTableName(this.table().identifier().table()).setTableCreateSchema(schema2.toString()).setPartitionFields(this.table().partitionColumnNames().mkString(",")).initTable(this.hadoopConf(), this.tableLocation());
                }
                return;
            }
            throw new MatchError(tuple22);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<StructType, scala.collection.immutable.Map<String, String>> parseSchemaAndConfigs() {
        Tuple2 tuple2;
        block11: {
            Tuple2 tuple22;
            block10: {
                boolean bl;
                scala.collection.immutable.Map<String, String> sqlOptions;
                scala.collection.immutable.Map<String, String> globalTableConfigs;
                block6: {
                    block9: {
                        StructType structType;
                        scala.collection.immutable.Map options;
                        block8: {
                            block7: {
                                scala.collection.immutable.Map globalProps = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                globalTableConfigs = HoodieWriterUtils$.MODULE$.mappingSparkDatasourceConfigsToTableConfigs((scala.collection.immutable.Map<String, String>)globalProps);
                                scala.collection.immutable.Map<String, String> globalSqlOptions = HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption(globalTableConfigs);
                                sqlOptions = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions((scala.collection.immutable.Map<String, String>)globalSqlOptions.$plus$plus(this.catalogProperties()));
                                tuple2 = new Tuple2((Object)this.table().tableType(), (Object)BoxesRunTime.boxToBoolean((boolean)this.hoodieTableExists()));
                                if (tuple2 == null) break block6;
                                CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
                                boolean bl2 = tuple2._2$mcZ$sp();
                                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
                                CatalogTableType catalogTableType3 = catalogTableType;
                                if ((catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) || !bl2) break block6;
                                scala.collection.immutable.Map existingTableConfig = ((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)this.tableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms());
                                scala.collection.immutable.Map currentTableConfig = globalTableConfigs.$plus$plus((GenTraversableOnce)existingTableConfig);
                                scala.collection.immutable.Map<String, String> catalogTableProps = HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(this.catalogProperties());
                                HoodieWriterUtils$.MODULE$.validateTableConfig(this.spark(), catalogTableProps, HoodieWriterUtils$.MODULE$.convertMapToHoodieConfig((scala.collection.immutable.Map<String, String>)existingTableConfig));
                                options = this.extraTableConfig(this.hoodieTableExists(), (scala.collection.immutable.Map<String, String>)currentTableConfig).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions)).$plus$plus((GenTraversableOnce)currentTableConfig);
                                Option<StructType> schemaFromMetaOpt = this.loadTableSchemaByMetaClient();
                                if (!schemaFromMetaOpt.nonEmpty()) break block7;
                                structType = (StructType)schemaFromMetaOpt.get();
                                break block8;
                            }
                            if (!this.table().schema().nonEmpty()) break block9;
                            structType = HoodieSqlCommonUtils$.MODULE$.addMetaFields(this.table().schema());
                        }
                        StructType schema2 = structType;
                        tuple22 = new Tuple2((Object)schema2, (Object)options);
                        break block10;
                    }
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema fields when applying CREATE TABLE clause for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (tuple2 == null || (bl = tuple2._2$mcZ$sp())) break block11;
                ValidationUtils.checkArgument(this.table().schema().nonEmpty(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing schema for Create Table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()})));
                StructType schema3 = this.table().schema();
                scala.collection.immutable.Map options = this.extraTableConfig(false, globalTableConfigs).$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToTableConfig(sqlOptions));
                tuple22 = new Tuple2((Object)HoodieSqlCommonUtils$.MODULE$.addMetaFields(schema3), (Object)options);
            }
            Tuple2 tuple23 = tuple22;
            if (tuple23 != null) {
                Tuple2 tuple24;
                StructType finalSchema = (StructType)tuple23._1();
                scala.collection.immutable.Map tableConfigs = (scala.collection.immutable.Map)tuple23._2();
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)finalSchema, (Object)tableConfigs);
                StructType finalSchema2 = (StructType)tuple25._1();
                scala.collection.immutable.Map tableConfigs2 = (scala.collection.immutable.Map)tuple25._2();
                HoodieOptionConfig$.MODULE$.validateTable(this.spark(), finalSchema2, HoodieOptionConfig$.MODULE$.mappingTableConfigToSqlOption((scala.collection.immutable.Map<String, String>)tableConfigs2));
                Function2 resolver = this.spark().sessionState().conf().resolver();
                Seq dataSchema2 = (Seq)finalSchema2.filterNot((Function1)new Serializable(this, resolver){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HoodieCatalogTable $outer;
                    public final Function2 resolver$1;

                    public final boolean apply(StructField f) {
                        return this.$outer.table().partitionColumnNames().exists((Function1)new Serializable(this, f){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4 $outer;
                            private final StructField f$1;

                            public final boolean apply(String x$5) {
                                return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)x$5, (Object)this.f$1.name()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.f$1 = f$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.resolver$1 = resolver$1;
                    }
                });
                this.verifyDataSchema(this.table().identifier(), this.table().tableType(), (Seq<StructField>)dataSchema2);
                return new Tuple2((Object)finalSchema2, (Object)tableConfigs2);
            }
            throw new MatchError((Object)tuple23);
        }
        if (tuple2 != null) {
            CatalogTableType catalogTableType = (CatalogTableType)tuple2._1();
            boolean bl = tuple2._2$mcZ$sp();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.MANAGED();
            CatalogTableType catalogTableType5 = catalogTableType;
            if (!(catalogTableType4 != null ? !catalogTableType4.equals(catalogTableType5) : catalogTableType5 != null) && bl) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not create the managed table('", "')"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.catalogTableName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{". The associated location('", "') already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableLocation()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig(boolean tableExists, scala.collection.immutable.Map<String, String> originTableConfig) {
        scala.collection.mutable.Map extraConfig = Map$.MODULE$.empty();
        if (tableExists) {
            Seq<String> allPartitionPaths = this.getPartitionPaths();
            if (originTableConfig.contains((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key())) {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), originTableConfig.apply((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isHiveStyledPartitioning(allPartitionPaths, this.table())));
            }
            if (originTableConfig.contains((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key())) {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), originTableConfig.apply((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key()));
            } else {
                extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)String.valueOf(HoodieSqlCommonUtils$.MODULE$.isUrlEncodeEnabled(allPartitionPaths, this.table())));
            }
        } else {
            extraConfig.update((Object)HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE.key(), (Object)"true");
            extraConfig.update((Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.key(), (Object)HoodieTableConfig.URL_ENCODE_PARTITIONING.defaultValue());
        }
        if (originTableConfig.contains((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())) {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)HoodieSparkKeyGeneratorFactory.convertToSparkKeyGenerator((String)originTableConfig.apply((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key())));
        } else {
            extraConfig.update((Object)HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), (Object)ComplexKeyGenerator.class.getCanonicalName());
        }
        return extraConfig.toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> extraTableConfig$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    private Option<StructType> loadTableSchemaByMetaClient() {
        Function2 resolver = this.spark().sessionState().conf().resolver();
        return HoodieSqlCommonUtils$.MODULE$.getTableSqlSchema(this.metaClient(), true).map((Function1)new Serializable(this, resolver){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;
            public final Function2 resolver$2;

            public final StructType apply(StructType originSchema) {
                StructField[] fields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])originSchema.fields()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$loadTableSchemaByMetaClient$1 $outer;

                    public final StructField apply(StructField f) {
                        boolean x$25 = true;
                        String x$26 = f.copy$default$1();
                        DataType x$27 = f.copy$default$2();
                        Metadata x$28 = f.copy$default$4();
                        StructField nullableField = f.copy(x$26, x$27, x$25, x$28);
                        Option<StructField> catalogField = HoodieSqlCommonUtils$.MODULE$.findColumnByName(this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$anonfun$$$outer().table().schema(), nullableField.name(), (Function2<String, String, Object>)this.$outer.resolver$2);
                        return catalogField.isDefined() ? (StructField)((StructField)catalogField.get()).getComment().map((Function1)new Serializable(this, nullableField){
                            public static final long serialVersionUID = 0L;
                            private final StructField nullableField$1;

                            public final StructField apply(String comment) {
                                return this.nullableField$1.withComment(comment);
                            }
                            {
                                this.nullableField$1 = nullableField$1;
                            }
                        }).getOrElse((Function0)new Serializable(this, nullableField){
                            public static final long serialVersionUID = 0L;
                            private final StructField nullableField$1;

                            public final StructField apply() {
                                return this.nullableField$1;
                            }
                            {
                                this.nullableField$1 = nullableField$1;
                            }
                        }) : nullableField;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                return new StructType(fields);
            }

            public /* synthetic */ HoodieCatalogTable org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$2 = resolver$2;
            }
        });
    }

    private void verifyDataSchema(TableIdentifier tableIdentifier, CatalogTableType tableType, Seq<StructField> dataSchema2) {
        CatalogTableType catalogTableType = tableType;
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (catalogTableType == null ? catalogTableType2 != null : !catalogTableType.equals(catalogTableType2)) {
            Seq invalidChars = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{",", ":", ";"}));
            dataSchema2.foreach((Function1)new Serializable(this, tableIdentifier, invalidChars){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HoodieCatalogTable $outer;
                private final TableIdentifier tableIdentifier$1;
                private final Seq invalidChars$1;

                public final void apply(StructField f) {
                    DataType dataType = f.dataType();
                    if (f.name().contains(",")) {
                        throw new AnalysisException(new StringBuilder().append((Object)"Cannot create a table having a column whose name ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"contains commas in Hive metastore. Table: ", "; Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableIdentifier$1, f.name()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (dataType instanceof StructType) {
                        StructType structType = (StructType)dataType;
                        this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tableIdentifier$1 = tableIdentifier$1;
                    this.invalidChars$1 = invalidChars$1;
                }
            });
        }
    }

    public final void org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(StructType schema2, TableIdentifier tableIdentifier$1, Seq invalidChars$1) {
        schema2.foreach((Function1)new Serializable(this, tableIdentifier$1, invalidChars$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieCatalogTable $outer;
            private final TableIdentifier tableIdentifier$1;
            private final Seq invalidChars$1;

            public final void apply(StructField f) {
                DataType dataType = f.dataType();
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    this.$outer.org$apache$spark$sql$catalyst$catalog$HoodieCatalogTable$$verifyNestedColumnNames$1(structType, this.tableIdentifier$1, this.invalidChars$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    if (this.invalidChars$1.exists((Function1)new Serializable(this, f){
                        public static final long serialVersionUID = 0L;
                        private final StructField f$2;

                        public final boolean apply(CharSequence x$1) {
                            return this.f$2.name().contains(x$1);
                        }
                        {
                            this.f$2 = f$2;
                        }
                    })) {
                        String invalidCharsString = ((TraversableOnce)this.invalidChars$1.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String c) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c}));
                            }
                        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
                        String errMsg = new StringBuilder().append((Object)"Cannot create a table having a nested column whose name contains ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid characters (", ") in Hive metastore. Table: ", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{invalidCharsString, this.tableIdentifier$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f.name()}))).toString();
                        throw new AnalysisException(errMsg, AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableIdentifier$1 = tableIdentifier$1;
                this.invalidChars$1 = invalidChars$1;
            }
        });
    }

    public HoodieCatalogTable(SparkSession spark, CatalogTable table) {
        this.spark = spark;
        this.table = table;
        Logging.class.$init$((Logging)this);
        Object object = this.table().provider().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return x$1.toLowerCase(Locale.ROOT);
            }
        }).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        Predef$.MODULE$.assert(!(object != null ? !object.equals(string) : string != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "It's not a Hudi table";
            }
        });
        this.hadoopConf = spark.sessionState().newHadoopConf();
        this.catalogTableName = this.table().qualifiedName();
        this.catalogProperties = this.table().storage().properties().$plus$plus((GenTraversableOnce)this.table().properties());
        this.tableLocation = HoodieSqlCommonUtils$.MODULE$.getTableLocation(this.table(), spark);
        this.hoodieTableExists = HoodieSqlCommonUtils$.MODULE$.tableExistsInPath(this.tableLocation(), this.hadoopConf());
    }
}

