/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HoodieSqlCommonUtils$
implements SparkAdapterSupport {
    public static final HoodieSqlCommonUtils$ MODULE$;
    private final ThreadLocal<SimpleDateFormat> defaultDateFormat;
    private Set<String> metaFields;
    private final SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    static {
        new HoodieSqlCommonUtils$();
    }

    private Set metaFields$lzycompute() {
        HoodieSqlCommonUtils$ hoodieSqlCommonUtils$ = this;
        synchronized (hoodieSqlCommonUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metaFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.metaFields;
        }
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSqlCommonUtils$ hoodieSqlCommonUtils$ = this;
        synchronized (hoodieSqlCommonUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private ThreadLocal<SimpleDateFormat> defaultDateFormat() {
        return this.defaultDateFormat;
    }

    public TableIdentifier getTableIdentifier(LogicalPlan table) {
        LogicalPlan logicalPlan = table;
        if (logicalPlan instanceof SubqueryAlias) {
            SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
            AliasIdentifier name = subqueryAlias.name();
            TableIdentifier tableIdentifier = this.sparkAdapter().toTableIdentifier(name);
            return tableIdentifier;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
    }

    public Option<StructType> getTableSqlSchema(HoodieTableMetaClient metaClient, boolean includeMetadataFields) {
        Some some;
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            some = new Some((Object)schemaResolver.getTableAvroSchema(includeMetadataFields));
        }
        catch (Throwable throwable) {
            some = None$.MODULE$;
        }
        Some avroSchema = some;
        return avroSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(Schema avroSchema) {
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(avroSchema);
            }
        });
    }

    public boolean getTableSqlSchema$default$2() {
        return false;
    }

    public Seq<String> getAllPartitionPaths(SparkSession spark, CatalogTable table) {
        HoodieSparkEngineContext sparkEngine = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)spark.sessionState().conf().getAllConfs().$plus$plus((GenTraversableOnce)table.storage().properties()).$plus$plus((GenTraversableOnce)table.properties())).asJava()));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(FSUtils.getAllPartitionPaths(sparkEngine, metadataConfig, this.getTableLocation(table, spark))).asScala();
    }

    public boolean isHiveStyledPartitioning(Seq<String> partitionPaths, CatalogTable table) {
        boolean bl;
        if (table.partitionColumnNames().nonEmpty()) {
            Serializable isHiveStylePartitionPath = new Serializable(table){
                public static final long serialVersionUID = 0L;
                private final CatalogTable table$2;

                public final boolean apply(String path) {
                    String[] fragments = path.split("/");
                    return Predef$.MODULE$.refArrayOps((Object[])fragments).size() != this.table$2.partitionColumnNames().size() ? false : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])fragments).zip((GenIterable)this.table$2.partitionColumnNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, String> x0$1) {
                            Tuple2<String, String> tuple2 = x0$1;
                            if (tuple2 != null) {
                                String pathFragment = (String)tuple2._1();
                                String partitionColumn = (String)tuple2._2();
                                boolean bl = pathFragment.startsWith(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionColumn})));
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                    });
                }
                {
                    this.table$2 = table$2;
                }
            };
            bl = partitionPaths.forall((Function1)isHiveStylePartitionPath);
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean isUrlEncodeEnabled(Seq<String> partitionPaths, CatalogTable table) {
        return table.partitionColumnNames().nonEmpty() ? partitionPaths.forall((Function1)new Serializable(table){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$3;

            public final boolean apply(String partitionPath) {
                return partitionPath.split("/").length == this.table$3.partitionColumnNames().size();
            }
            {
                this.table$3 = table$3;
            }
        }) : false;
    }

    private LogicalPlan tripAlias(LogicalPlan plan) {
        SubqueryAlias subqueryAlias;
        LogicalPlan relation;
        LogicalPlan logicalPlan;
        while ((logicalPlan = plan) instanceof SubqueryAlias && (relation = (subqueryAlias = (SubqueryAlias)logicalPlan).child()) != null) {
            LogicalPlan logicalPlan2;
            plan = logicalPlan2 = relation;
        }
        LogicalPlan logicalPlan3 = logicalPlan;
        return logicalPlan3;
    }

    public StructType addMetaFields(StructType schema2) {
        Buffer metaFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala();
        StructField[] dataFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).filterNot((Function1)new Serializable(metaFields){
            public static final long serialVersionUID = 0L;
            private final Buffer metaFields$1;

            public final boolean apply(StructField f) {
                return this.metaFields$1.contains((Object)f.name());
            }
            {
                this.metaFields$1 = metaFields$1;
            }
        });
        Buffer fields = ((BufferLike)metaFields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String x$1) {
                return new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])dataFields));
        return StructType$.MODULE$.apply((Seq)fields);
    }

    private Set<String> metaFields() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.metaFields$lzycompute() : this.metaFields;
    }

    public StructType removeMetaFields(StructType schema2) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField f) {
                return HoodieSqlCommonUtils$.MODULE$.isMetaField(f.name());
            }
        }));
    }

    public boolean isMetaField(String name) {
        return this.metaFields().contains((Object)name);
    }

    public Dataset<Row> removeMetaFields(Dataset<Row> df) {
        Seq withoutMetaColumns = (Seq)((TraversableLike)df.logicalPlan().output().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute attr) {
                return HoodieSqlCommonUtils$.MODULE$.isMetaField(attr.name());
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Column apply(Attribute x$2) {
                return new Column((Expression)x$2);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return withoutMetaColumns.length() != df.logicalPlan().output().size() ? df.select(withoutMetaColumns) : df;
    }

    public Seq<Attribute> removeMetaFields(Seq<Attribute> attrs) {
        return (Seq)attrs.filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Attribute attr) {
                return HoodieSqlCommonUtils$.MODULE$.isMetaField(attr.name());
            }
        });
    }

    public String getTableLocation(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.getTableLocation(table, spark);
    }

    public String getTableLocation(scala.collection.immutable.Map<String, String> properties, TableIdentifier identifier, SparkSession sparkSession) {
        Some location = new Some(properties.getOrElse((Object)"location", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }));
        boolean isManaged = location.isEmpty() || ((String)location.get()).isEmpty();
        Some uri = isManaged ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(identifier)) : new Some((Object)new Path((String)location.get()).toUri());
        return this.getTableLocation((Option<URI>)uri, identifier, sparkSession);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        Option uri = table.storage().locationUri().orElse((Function0)new Serializable(table, sparkSession){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$1;
            private final SparkSession sparkSession$1;

            public final Some<URI> apply() {
                return new Some((Object)this.sparkSession$1.sessionState().catalog().defaultTablePath(this.table$1.identifier()));
            }
            {
                this.table$1 = table$1;
                this.sparkSession$1 = sparkSession$1;
            }
        });
        return this.getTableLocation((Option<URI>)uri, table.identifier(), sparkSession);
    }

    public String getTableLocation(Option<URI> uri, TableIdentifier identifier, SparkSession sparkSession) {
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri.map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final String apply(URI x$3) {
                return HoodieSqlCommonUtils$.MODULE$.makePathQualified(x$3, this.conf$1);
            }
            {
                this.conf$1 = conf$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String path) {
                return HoodieSqlCommonUtils$.MODULE$.org$apache$spark$sql$hudi$HoodieSqlCommonUtils$$removePlaceHolder(path);
            }
        }).getOrElse((Function0)new Serializable(identifier){
            public static final long serialVersionUID = 0L;
            private final TableIdentifier identifier$1;

            public final Nothing$ apply() {
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing location for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.identifier$1})));
            }
            {
                this.identifier$1 = identifier$1;
            }
        });
    }

    public String org$apache$spark$sql$hudi$HoodieSqlCommonUtils$$removePlaceHolder(String path) {
        return path == null || path.length() == 0 ? path : (path.endsWith("-__PLACEHOLDER__") ? path.substring(0, path.length() - 16) : path);
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public boolean tableExistsInPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        Path metaPath = new Path(basePath, ".hoodie");
        return fs.exists(metaPath);
    }

    public Seq<Expression> splitByAnd(Expression expression) {
        Seq seq;
        Expression expression2 = expression;
        if (expression2 instanceof And) {
            And and = (And)expression2;
            Expression left = and.left();
            Expression right = and.right();
            seq = (Seq)this.splitByAnd(left).$plus$plus(this.splitByAnd(right), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression2}));
        }
        return seq;
    }

    public scala.collection.immutable.Map<String, String> withSparkConf(SparkSession spark, scala.collection.immutable.Map<String, String> options, scala.collection.immutable.Map<String, String> baseConfig) {
        return baseConfig.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).$plus$plus((GenTraversableOnce)spark.sessionState().conf().getAllConfs().$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToHoodieParam(options)).filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return x$4.startsWith("hoodie.");
            }
        }));
    }

    public scala.collection.immutable.Map<String, String> withSparkConf$default$3(SparkSession spark, scala.collection.immutable.Map<String, String> options) {
        return Map$.MODULE$.empty();
    }

    public boolean isUsingHiveCatalog(SparkSession sparkSession) {
        Object object = sparkSession.sessionState().conf().getConf(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION());
        String string = "hive";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public String formatQueryInstant(String queryInstant) {
        block5: {
            String string;
            block3: {
                int instantLength;
                block4: {
                    block2: {
                        instantLength = queryInstant.length();
                        if (instantLength != 19 && instantLength != 23) break block2;
                        string = HoodieInstantTimeGenerator.getInstantForDateString(queryInstant);
                        break block3;
                    }
                    if (instantLength != HoodieInstantTimeGenerator.SECS_INSTANT_ID_LENGTH && instantLength != HoodieInstantTimeGenerator.MILLIS_INSTANT_ID_LENGTH) break block4;
                    HoodieActiveTimeline.parseDateFromInstantTime(queryInstant);
                    string = queryInstant;
                    break block3;
                }
                if (instantLength != 10) break block5;
                string = HoodieActiveTimeline.formatDate(((DateFormat)this.defaultDateFormat().get()).parse(queryInstant));
            }
            return string;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported query instant time format: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{queryInstant}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported time format are: 'yyyy-MM-dd: HH:mm:ss.SSS' or 'yyyy-MM-dd' or 'yyyyMMddHHmmssSSS'"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public String formatName(SparkSession sparkSession, String name) {
        return sparkSession.sessionState().conf().caseSensitiveAnalysis() ? name : name.toLowerCase(Locale.ROOT);
    }

    public boolean isEmptyPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        return fs.exists(basePath) ? Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(basePath)).isEmpty() : true;
    }

    public Option<StructField> findColumnByName(StructType schema2, String name, Function2<String, String, Object> resolver) {
        return Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).collectFirst((PartialFunction)new Serializable(name, resolver){
            public static final long serialVersionUID = 0L;
            private final String name$1;
            private final Function2 resolver$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1)) ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                boolean bl = BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
                return bl;
            }
            {
                this.name$1 = name$1;
                this.resolver$1 = resolver$1;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression castIfNeeded(Expression child, DataType dataType, SQLConf conf) {
        Expression expression = child;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object nul = literal.value();
            DataType dataType2 = literal.dataType();
            if (NullType$.MODULE$.equals(dataType2)) {
                return new Literal(nul, dataType);
            }
        }
        DataType dataType3 = child.dataType();
        DataType dataType4 = dataType;
        return !(dataType3 != null ? !dataType3.equals(dataType4) : dataType4 != null) ? child : new Cast(child, dataType, Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone()));
    }

    public <T> scala.collection.immutable.Map<String, T> normalizePartitionSpec(scala.collection.immutable.Map<String, T> partitionSpec, Seq<String> partColNames, String tblName, Function2<String, String, Object> resolver) {
        Seq normalizedPartSpec = (Seq)partitionSpec.toSeq().map((Function1)new Serializable(partColNames, tblName, resolver){
            public static final long serialVersionUID = 0L;
            private final Seq partColNames$1;
            public final String tblName$1;
            public final Function2 resolver$2;

            public final Tuple2<String, T> apply(Tuple2<String, T> x0$2) {
                Tuple2<String, T> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    String normalizedKey = (String)this.partColNames$1.find((Function1)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;
                        private final String key$1;

                        public final boolean apply(String x$5) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$2.apply((Object)x$5, (Object)this.key$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    }).getOrElse((Function0)new Serializable(this, key){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.9 $outer;
                        private final String key$1;

                        public final Nothing$ apply() {
                            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a valid partition column in table ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.$outer.tblName$1})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.key$1 = key$1;
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)normalizedKey), value);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partColNames$1 = partColNames$1;
                this.tblName$1 = tblName$1;
                this.resolver$2 = resolver$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (normalizedPartSpec.size() < partColNames.size()) {
            throw new AnalysisException("All partition columns need to be specified for Hoodie's partition", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq lowerPartColNames = (Seq)partColNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$6) {
                return x$6.toLowerCase();
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (((SeqLike)lowerPartColNames.distinct()).length() != lowerPartColNames.length()) {
            Iterable duplicateColumns = (Iterable)lowerPartColNames.groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String x) {
                    return (String)Predef$.MODULE$.identity((Object)x);
                }
            }).collect((PartialFunction)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, Seq<String>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 != null) {
                        String x = (String)A1._1();
                        Seq ys = (Seq)A1._2();
                        if (ys.length() > 1) {
                            object = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x}));
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<String, Seq<String>> x2) {
                    Seq ys;
                    Tuple2<String, Seq<String>> tuple2 = x2;
                    boolean bl = tuple2 != null && (ys = (Seq)tuple2._2()).length() > 1;
                    return bl;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate column(s) in the partition schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateColumns.mkString(", ")})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return normalizedPartSpec.toMap(Predef$.MODULE$.$conforms());
    }

    public String getPartitionPathToDrop(HoodieCatalogTable hoodieCatalogTable, Seq<scala.collection.immutable.Map<String, String>> normalizedSpecs) {
        CatalogTable table = hoodieCatalogTable.table();
        Seq<String> allPartitionPaths = hoodieCatalogTable.getPartitionPaths();
        boolean enableHiveStylePartitioning = this.isHiveStyledPartitioning(allPartitionPaths, table);
        boolean enableEncodeUrl = this.isUrlEncodeEnabled(allPartitionPaths, table);
        String partitionsToDrop = ((TraversableOnce)normalizedSpecs.map((Function1)new Serializable(hoodieCatalogTable, enableHiveStylePartitioning, enableEncodeUrl){
            public static final long serialVersionUID = 0L;
            private final HoodieCatalogTable hoodieCatalogTable$1;
            public final boolean enableHiveStylePartitioning$1;
            public final boolean enableEncodeUrl$1;

            public final String apply(scala.collection.immutable.Map<String, String> spec) {
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.hoodieCatalogTable$1.partitionFields()).map((Function1)new Serializable(this, spec){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.14 $outer;
                    private final scala.collection.immutable.Map spec$1;

                    public final String apply(String partitionColumn) {
                        String encodedPartitionValue = this.$outer.enableEncodeUrl$1 ? PartitionPathEncodeUtils.escapePathName((String)this.spec$1.apply((Object)partitionColumn)) : (String)this.spec$1.apply((Object)partitionColumn);
                        return this.$outer.enableHiveStylePartitioning$1 ? new StringBuilder().append((Object)partitionColumn).append((Object)"=").append((Object)encodedPartitionValue).toString() : encodedPartitionValue;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.spec$1 = spec$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("/");
            }
            {
                this.hoodieCatalogTable$1 = hoodieCatalogTable$1;
                this.enableHiveStylePartitioning$1 = enableHiveStylePartitioning$1;
                this.enableEncodeUrl$1 = enableEncodeUrl$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
        return partitionsToDrop;
    }

    private HoodieSqlCommonUtils$() {
        MODULE$ = this;
        SparkAdapterSupport$class.$init$(this);
        this.defaultDateFormat = ThreadLocal.withInitial(new Supplier<SimpleDateFormat>(){

            public SimpleDateFormat get() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        });
    }
}

