/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.HoodieLeafLike$class;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.hudi.command.HoodieLeafRunnableCommand;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\u0001\u0003\u0001>\u0011\u0011%\u00117uKJDun\u001c3jKR\u000b'\r\\3BI\u0012\u001cu\u000e\\;n]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000f\r|W.\\1oI*\u0011QAB\u0001\u0005QV$\u0017N\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!iqB\u0005\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u00059An\\4jG\u0006d'BA\u000b\u0017\u0003\u0015\u0001H.\u00198t\u0015\t9b!\u0001\u0005dCR\fG._:u\u0013\tI\"CA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u0005eAun\u001c3jK2+\u0017M\u001a*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\bi\u0006\u0014G.Z%e+\u0005Q\u0003CA\u0016-\u001b\u00051\u0012BA\u0017\u0017\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\b\u0002C\u0018\u0001\u0005#\u0005\u000b\u0011\u0002\u0016\u0002\u0011Q\f'\r\\3JI\u0002B\u0001\"\r\u0001\u0003\u0016\u0004%\tAM\u0001\nG>d7\u000fV8BI\u0012,\u0012a\r\t\u0004iqzdBA\u001b;\u001d\t1\u0014(D\u00018\u0015\tAd\"\u0001\u0004=e>|GOP\u0005\u0002C%\u00111\bI\u0001\ba\u0006\u001c7.Y4f\u0013\tidHA\u0002TKFT!a\u000f\u0011\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t3\u0011!\u0002;za\u0016\u001c\u0018B\u0001#B\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u0011\u0019\u0003!\u0011#Q\u0001\nM\n!bY8mgR{\u0017\t\u001a3!\u0011\u0015A\u0005\u0001\"\u0001J\u0003\u0019a\u0014N\\5u}Q\u0019!j\u0013'\u0011\u0005m\u0001\u0001\"\u0002\u0015H\u0001\u0004Q\u0003\"B\u0019H\u0001\u0004\u0019\u0004\"\u0002(\u0001\t\u0003z\u0015a\u0001:v]R\u0011\u0001+\u0016\t\u0004iq\n\u0006C\u0001*T\u001b\u00051\u0011B\u0001+\u0007\u0005\r\u0011vn\u001e\u0005\u0006-6\u0003\raV\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003%bK!!\u0017\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bm\u0003A\u0011\u0002/\u0002'I,gM]3tQN\u001b\u0007.Z7b\u0013:lU\r^1\u0015\tu\u0003\u0017-\u001b\t\u0003?yK!a\u0018\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006-j\u0003\ra\u0016\u0005\u0006Ej\u0003\raY\u0001\u0006i\u0006\u0014G.\u001a\t\u0003I\u001el\u0011!\u001a\u0006\u0003MZ\tqaY1uC2|w-\u0003\u0002iK\na1)\u0019;bY><G+\u00192mK\")!N\u0017a\u0001W\u0006\u0001b.Z<Tc2$\u0015\r^1TG\",W.\u0019\t\u0003\u00012L!!\\!\u0003\u0015M#(/^2u)f\u0004X\rC\u0004p\u0001\u0005\u0005I\u0011\u00019\u0002\t\r|\u0007/\u001f\u000b\u0004\u0015F\u0014\bb\u0002\u0015o!\u0003\u0005\rA\u000b\u0005\bc9\u0004\n\u00111\u00014\u0011\u001d!\b!%A\u0005\u0002U\fabY8qs\u0012\"WMZ1vYR$\u0013'F\u0001wU\tQsoK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011Q\u0010I\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\b)\u00121g\u001e\u0005\n\u0003\u0017\u0001\u0011\u0011!C!\u0003\u001b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA\u0001\\1oO*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!AB*ue&tw\rC\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0005\t\u0004?\u0005\u001d\u0012bAA\u0015A\t\u0019\u0011J\u001c;\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003c\t9\u0004E\u0002 \u0003gI1!!\u000e!\u0005\r\te.\u001f\u0005\u000b\u0003s\tY#!AA\u0002\u0005\u0015\u0012a\u0001=%c!I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0013qH\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\t\t\u0007\u0003\u0007\nI%!\r\u000e\u0005\u0005\u0015#bAA$A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0013Q\t\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\n\u0001\u0002\u0002\u0013\u0005\u0011\u0011K\u0001\tG\u0006tW)];bYR!\u00111KA-!\ry\u0012QK\u0005\u0004\u0003/\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003s\ti%!AA\u0002\u0005E\u0002\"CA/\u0001\u0005\u0005I\u0011IA0\u0003\u0019)\u0017/^1mgR!\u00111KA1\u0011)\tI$a\u0017\u0002\u0002\u0003\u0007\u0011\u0011G\u0004\b\u0003K\u0012\u0001\u0012AA4\u0003\u0005\nE\u000e^3s\u0011>|G-[3UC\ndW-\u00113e\u0007>dW/\u001c8t\u0007>lW.\u00198e!\rY\u0012\u0011\u000e\u0004\u0007\u0003\tA\t!a\u001b\u0014\u000b\u0005%\u0014Q\u000e\u0013\u0011\u0007}\ty'C\u0002\u0002r\u0001\u0012a!\u00118z%\u00164\u0007b\u0002%\u0002j\u0011\u0005\u0011Q\u000f\u000b\u0003\u0003OB\u0001\"!\u001f\u0002j\u0011\u0005\u00111P\u0001\u0011G>lW.\u001b;XSRD7k\u00195f[\u0006$r!XA?\u0003\u001b\u000b9\n\u0003\u0005\u0002\u0000\u0005]\u0004\u0019AAA\u0003\u0019\u00198\r[3nCB!\u00111QAE\u001b\t\t)IC\u0002\u0002\b*\tA!\u0019<s_&!\u00111RAC\u0005\u0019\u00196\r[3nC\"A\u0011qRA<\u0001\u0004\t\t*\u0001\ni_>$\u0017.Z\"bi\u0006dwn\u001a+bE2,\u0007c\u00013\u0002\u0014&\u0019\u0011QS3\u0003%!{w\u000eZ5f\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\u0007-\u0006]\u0004\u0019A,\t\u0015\u0005m\u0015\u0011NA\u0001\n\u0003\u000bi*A\u0003baBd\u0017\u0010F\u0003K\u0003?\u000b\t\u000b\u0003\u0004)\u00033\u0003\rA\u000b\u0005\u0007c\u0005e\u0005\u0019A\u001a\t\u0015\u0005\u0015\u0016\u0011NA\u0001\n\u0003\u000b9+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005%\u0016Q\u0017\t\u0006?\u0005-\u0016qV\u0005\u0004\u0003[\u0003#AB(qi&|g\u000eE\u0003 \u0003cS3'C\u0002\u00024\u0002\u0012a\u0001V;qY\u0016\u0014\u0004\"CA\\\u0003G\u000b\t\u00111\u0001K\u0003\rAH\u0005\r\u0005\u000b\u0003w\u000bI'!A\u0005\n\u0005u\u0016a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a0\u0011\t\u0005E\u0011\u0011Y\u0005\u0005\u0003\u0007\f\u0019B\u0001\u0004PE*,7\r\u001e")
public class AlterHoodieTableAddColumnsCommand
extends LogicalPlan
implements HoodieLeafRunnableCommand,
Serializable {
    private final TableIdentifier tableId;
    private final Seq<StructField> colsToAdd;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand) {
        return AlterHoodieTableAddColumnsCommand$.MODULE$.unapply(alterHoodieTableAddColumnsCommand);
    }

    public static void commitWithSchema(Schema schema2, HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(schema2, hoodieCatalogTable, sparkSession);
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return HoodieLeafLike$class.children((TreeNode)this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return HoodieLeafLike$class.mapChildren((TreeNode)this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return HoodieLeafLike$class.withNewChildrenInternal((TreeNode)this, newChildren);
    }

    private Map metrics$lzycompute() {
        AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = this;
        synchronized (alterHoodieTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableId() {
        return this.tableId;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        if (this.colsToAdd().nonEmpty()) {
            Function2 resolver = sparkSession.sessionState().conf().resolver();
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableId());
            StructType tableSchema = hoodieCatalogTable.tableSchema();
            Seq existsColumns = (Seq)((TraversableLike)this.colsToAdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$1) {
                    return x$1.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, resolver, tableSchema){
                public static final long serialVersionUID = 0L;
                public final Function2 resolver$1;
                private final StructType tableSchema$1;

                public final boolean apply(String col) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.tableSchema$1.fieldNames()).exists((Function1)new Serializable(this, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;
                        private final String col$1;

                        public final boolean apply(String f) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)f, (Object)this.col$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    });
                }
                {
                    this.resolver$1 = resolver$1;
                    this.tableSchema$1 = tableSchema$1;
                }
            });
            if (existsColumns.nonEmpty()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Columns: [", "] already exists in the table,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existsColumns.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" table columns is: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchemaWithoutMetaFields().fieldNames()).mkString(",")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            Seq rearrangedSchema = (Seq)((TraversableLike)hoodieCatalogTable.dataSchema().$plus$plus(this.colsToAdd(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)hoodieCatalogTable.partitionSchema(), Seq$.MODULE$.canBuildFrom());
            StructType newSqlSchema = StructType$.MODULE$.apply(rearrangedSchema);
            Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableId().table());
            if (tuple2 != null) {
                Tuple2 tuple22;
                String structName = (String)tuple2._1();
                String nameSpace = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
                String structName2 = (String)tuple23._1();
                String nameSpace2 = (String)tuple23._2();
                Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)newSqlSchema, structName2, nameSpace2);
                AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
                StructType newDataSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields()).$plus$plus(this.colsToAdd(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                this.refreshSchemaInMeta(sparkSession, hoodieCatalogTable.table(), newDataSchema);
            } else {
                throw new MatchError(tuple2);
            }
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void refreshSchemaInMeta(SparkSession sparkSession, CatalogTable table, StructType newSqlDataSchema) {
        try {
            sparkSession.catalog().uncacheTable(this.tableId().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableId().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        sparkSession.catalog().refreshTable(table.identifier().unquotedString());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)newSqlDataSchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom()), new StringBuilder().append((Object)"in the table definition of ").append((Object)table.identifier()).toString(), this.conf().caseSensitiveAnalysis());
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableId(), newSqlDataSchema);
    }

    public AlterHoodieTableAddColumnsCommand copy(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        return new AlterHoodieTableAddColumnsCommand(tableId, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableId();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterHoodieTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.colsToAdd();
                break;
            }
            case 0: {
                tableIdentifier = this.tableId();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = (AlterHoodieTableAddColumnsCommand)x$1;
        TableIdentifier tableIdentifier = this.tableId();
        TableIdentifier tableIdentifier2 = alterHoodieTableAddColumnsCommand.tableId();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterHoodieTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterHoodieTableAddColumnsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterHoodieTableAddColumnsCommand(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        this.tableId = tableId;
        this.colsToAdd = colsToAdd;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
        HoodieLeafLike$class.$init$((TreeNode)this);
    }
}

