/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.sql.Timestamp;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.SparkKeyGeneratorInterface;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001=\u0011qbU9m\u0017\u0016Lx)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\tqaY8n[\u0006tGM\u0003\u0002\u0006\r\u0005!\u0001.\u001e3j\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012+5\t!C\u0003\u0002\u0014)\u000511.Z=hK:T!!\u0002\u0006\n\u0005Y\u0011\"aE\"p[BdW\r_&fs\u001e+g.\u001a:bi>\u0014\b\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u000bA\u0014x\u000e]:\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012AB2p]\u001aLwM\u0003\u0002\u001f)\u000511m\\7n_:L!\u0001I\u000e\u0003\u001fQK\b/\u001a3Qe>\u0004XM\u001d;jKNDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0003\u0011\u0015A\u0012\u00051\u0001\u001a\u0011!A\u0003\u0001#b\u0001\n\u0013I\u0013a\u00049beRLG/[8o'\u000eDW-\\1\u0016\u0003)\u00022a\u000b\u00181\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB(qi&|g\u000e\u0005\u00022i5\t!G\u0003\u00024\r\u0005)A/\u001f9fg&\u0011QG\r\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001c\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0016\u0002!A\f'\u000f^5uS>t7k\u00195f[\u0006\u0004\u0003\u0002C\u001d\u0001\u0011\u000b\u0007I\u0011\u0002\u001e\u0002\u0019=\u0014\u0018nZ5o\u0017\u0016Lx)\u001a8\u0016\u0003m\u00022a\u000b\u0018=!\t\tR(\u0003\u0002?%\ta1*Z=HK:,'/\u0019;pe\"A\u0001\t\u0001E\u0001B\u0003&1(A\u0007pe&<\u0017N\\&fs\u001e+g\u000e\t\u0005\u0006\u0005\u0002!\teQ\u0001\rO\u0016$(+Z2pe\u0012\\U-\u001f\u000b\u0003\t.\u0003\"!\u0012%\u000f\u0005-2\u0015BA$-\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001dc\u0003\"\u0002'B\u0001\u0004i\u0015A\u0002:fG>\u0014H\r\u0005\u0002O'6\tqJ\u0003\u0002Q#\u00069q-\u001a8fe&\u001c'B\u0001*\u000b\u0003\u0011\tgO]8\n\u0005Q{%!D$f]\u0016\u0014\u0018n\u0019*fG>\u0014H\rC\u0003C\u0001\u0011\u0005c\u000b\u0006\u0002E/\")\u0001,\u0016a\u00013\u0006\u0019!o\\<\u0011\u0005i[V\"\u0001\u0004\n\u0005q3!a\u0001*po\")a\f\u0001C\u0005?\u0006i2m\u001c8wKJ$\b+\u0019:uSRLwN\u001c)bi\"$vnU9m)f\u0004X\rF\u0002EA\nDQ!Y/A\u0002\u0011\u000bQ\u0002]1si&$\u0018n\u001c8QCRD\u0007\"B2^\u0001\u0004!\u0017a\u0002:poRK\b/\u001a\t\u0003W\u0015L!A\u001a\u0017\u0003\u000f\t{w\u000e\\3b]\")\u0001\u000e\u0001C!S\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f\u001b\u000b\u0003\t*DQ\u0001T4A\u00025CQ\u0001\u001b\u0001\u0005B1$\"\u0001R7\t\u000ba[\u0007\u0019A-\b\u000b=\u0014\u0001\u0012\u00019\u0002\u001fM\u000bHnS3z\u000f\u0016tWM]1u_J\u0004\"!J9\u0007\u000b\u0005\u0011\u0001\u0012\u0001:\u0014\u0007E\u001ch\u000f\u0005\u0002,i&\u0011Q\u000f\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005-:\u0018B\u0001=-\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015\u0011\u0013\u000f\"\u0001{)\u0005\u0001\bb\u0002?r\u0005\u0004%\t!`\u0001\u0011!\u0006\u0013F+\u0013+J\u001f:{6k\u0011%F\u001b\u0006+\u0012A \t\u0004\u007f\u0006%QBAA\u0001\u0015\u0011\t\u0019!!\u0002\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\tAA[1wC&\u0019\u0011*!\u0001\t\u000f\u00055\u0011\u000f)A\u0005}\u0006\t\u0002+\u0011*U\u0013RKuJT0T\u0007\"+U*\u0011\u0011\t\u0011\u0005E\u0011O1A\u0005\u0002u\f\u0001d\u0014*J\u000f&sulS#Z\u000f\u0016sul\u0011'B'N{f*Q'F\u0011\u001d\t)\"\u001dQ\u0001\ny\f\u0011d\u0014*J\u000f&sulS#Z\u000f\u0016sul\u0011'B'N{f*Q'FA!I\u0011\u0011D9C\u0002\u0013%\u00111D\u0001\u0014i&lWm\u001d;b[B$\u0016.\\3G_Jl\u0017\r^\u000b\u0003\u0003;\u0001B!a\b\u0002.5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0005\u0003O\tI#\u0001\u0003uS6,'bAA\u0016\u0019\u0005!!n\u001c3b\u0013\u0011\ty#!\t\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\u0003\u0005\u00024E\u0004\u000b\u0011BA\u000f\u0003Q!\u0018.\\3ti\u0006l\u0007\u000fV5nK\u001a{'/\\1uA!I\u0011qG9C\u0002\u0013%\u00111D\u0001\u0013gFdG+[7fgR\fW\u000e\u001d$pe6\fG\u000f\u0003\u0005\u0002<E\u0004\u000b\u0011BA\u000f\u0003M\u0019\u0018\u000f\u001c+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;!\u0011\u001d\ty$\u001dC\u0001\u0003\u0003\nacZ3u%\u0016\fGnS3z\u000f\u0016t7\t\\1tg:\u000bW.\u001a\u000b\u0004\t\u0006\r\u0003B\u0002\r\u0002>\u0001\u0007\u0011\u0004C\u0005\u0002HE\f\t\u0011\"\u0003\u0002J\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0005E\u0002\u0000\u0003\u001bJA!a\u0014\u0002\u0002\t1qJ\u00196fGR\u0004")
public class SqlKeyGenerator
extends ComplexKeyGenerator {
    private final TypedProperties props;
    private Option<StructType> partitionSchema;
    private Option<KeyGenerator> originKeyGen;
    private volatile byte bitmap$0;

    public static String getRealKeyGenClassName(TypedProperties typedProperties) {
        return SqlKeyGenerator$.MODULE$.getRealKeyGenClassName(typedProperties);
    }

    public static String ORIGIN_KEYGEN_CLASS_NAME() {
        return SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME();
    }

    public static String PARTITION_SCHEMA() {
        return SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA();
    }

    private Option partitionSchema$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                String partitionSchema2 = this.props.getString(SqlKeyGenerator$.MODULE$.PARTITION_SCHEMA(), "");
                this.partitionSchema = partitionSchema2 != null && new StringOps(Predef$.MODULE$.augmentString(partitionSchema2)).nonEmpty() ? new Some((Object)StructType$.MODULE$.fromDDL(partitionSchema2)) : None$.MODULE$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.partitionSchema;
        }
    }

    private Option originKeyGen$lzycompute() {
        SqlKeyGenerator sqlKeyGenerator = this;
        synchronized (sqlKeyGenerator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                None$ none$;
                String beforeKeyGenClassName = this.props.getString(SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME(), null);
                if (beforeKeyGenClassName != null && new StringOps(Predef$.MODULE$.augmentString(beforeKeyGenClassName)).nonEmpty()) {
                    TypedProperties keyGenProps = new TypedProperties();
                    keyGenProps.putAll((Map<?, ?>)this.props);
                    keyGenProps.remove(SqlKeyGenerator$.MODULE$.ORIGIN_KEYGEN_CLASS_NAME());
                    String convertedKeyGenClassName = SqlKeyGenerator$.MODULE$.getRealKeyGenClassName(this.props);
                    keyGenProps.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), convertedKeyGenClassName);
                    none$ = new Some((Object)KeyGenUtils.createKeyGeneratorByClassName(keyGenProps));
                } else {
                    none$ = None$.MODULE$;
                }
                this.originKeyGen = none$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.originKeyGen;
        }
    }

    private Option<StructType> partitionSchema() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionSchema$lzycompute() : this.partitionSchema;
    }

    private Option<KeyGenerator> originKeyGen() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.originKeyGen$lzycompute() : this.originKeyGen;
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.originKeyGen().isDefined() ? ((KeyGenerator)this.originKeyGen().get()).getKey(record).getRecordKey() : super.getRecordKey(record);
    }

    @Override
    public String getRecordKey(Row row) {
        return this.originKeyGen().isDefined() ? ((SparkKeyGeneratorInterface)this.originKeyGen().get()).getRecordKey(row) : super.getRecordKey(row);
    }

    private String convertPartitionPathToSqlType(String partitionPath, boolean rowType) {
        String[] partitionFragments;
        return this.partitionSchema().isDefined() ? (Predef$.MODULE$.refArrayOps((Object[])(partitionFragments = partitionPath.split("/"))).size() != ((SeqLike)this.partitionSchema().get()).size() ? partitionPath : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])partitionFragments).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])((StructType)this.partitionSchema().get()).fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, rowType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlKeyGenerator $outer;
            private final boolean rowType$1;

            public final String apply(Tuple2<String, StructField> x0$1) {
                Tuple2<String, StructField> tuple2 = x0$1;
                if (tuple2 != null) {
                    String string;
                    String partitionValue = (String)tuple2._1();
                    StructField partitionField = (StructField)tuple2._2();
                    String hiveStylePrefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionField.name()}));
                    boolean isHiveStyle = partitionValue.startsWith(hiveStylePrefix);
                    String _partitionValue = isHiveStyle ? partitionValue.substring(hiveStylePrefix.length()) : partitionValue;
                    DataType dataType = partitionField.dataType();
                    if (TimestampType$.MODULE$.equals(dataType)) {
                        long timeMs = this.rowType$1 ? SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$sqlTimestampFormat().parseMillis(_partitionValue) : (this.$outer.isConsistentLogicalTimestampEnabled() ? Timestamp.valueOf(_partitionValue).getTime() : TimeUnit.MILLISECONDS.convert(new StringOps(Predef$.MODULE$.augmentString(_partitionValue)).toLong(), TimeUnit.MICROSECONDS));
                        String timestampFormat = PartitionPathEncodeUtils.escapePathName(SqlKeyGenerator$.MODULE$.org$apache$spark$sql$hudi$command$SqlKeyGenerator$$timestampTimeFormat().print(timeMs));
                        string = isHiveStyle ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hiveStylePrefix, timestampFormat})) : timestampFormat;
                    } else {
                        string = partitionValue;
                    }
                    String string2 = string;
                    return string2;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rowType$1 = rowType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("/")) : partitionPath;
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        String partitionPath = super.getPartitionPath(record);
        return this.convertPartitionPathToSqlType(partitionPath, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        String partitionPath = super.getPartitionPath(row);
        return this.convertPartitionPathToSqlType(partitionPath, true);
    }

    public SqlKeyGenerator(TypedProperties props) {
        this.props = props;
        super(props);
    }
}

