/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RollbackSavepointsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001E\u00111DU8mY\n\f7m[*bm\u0016\u0004x.\u001b8ugB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\u0011\u0001!CF\r\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002\u0014/%\u0011\u0001D\u0001\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0006\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003'\u0001Aq\u0001\n\u0001C\u0002\u0013%Q%\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012A\n\t\u0004O)bS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Mi\u0013B\u0001\u0018\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\rA\u0002\u0001\u0015!\u0003'\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000fI\u0002!\u0019!C\u0005g\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\t\u0003\u0015!\u0018\u0010]3t\u0013\tIdG\u0001\u0006TiJ,8\r\u001e+za\u0016Daa\u000f\u0001!\u0002\u0013!\u0014\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001f\u0001\t\u0003)\u0013A\u00039be\u0006lW\r^3sg\")q\b\u0001C\u0001g\u0005Qq.\u001e;qkR$\u0016\u0010]3\t\u000b\u0005\u0003A\u0011\t\"\u0002\t\r\fG\u000e\u001c\u000b\u0003\u0007N\u00032\u0001\u0012'P\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002I!\u00051AH]8pizJ\u0011!K\u0005\u0003\u0017\"\nq\u0001]1dW\u0006<W-\u0003\u0002N\u001d\n\u00191+Z9\u000b\u0005-C\u0003C\u0001)R\u001b\u0005A\u0011B\u0001*\t\u0005\r\u0011vn\u001e\u0005\u0006)\u0002\u0003\r!V\u0001\u0005CJ<7\u000f\u0005\u0002\u0014-&\u0011qK\u0001\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\t\u000be\u0003A\u0011\t.\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003m\u0003\"a\u0005/\n\u0005u\u0013!!\u0003)s_\u000e,G-\u001e:f\u000f\u0015y&\u0001#\u0001a\u0003m\u0011v\u000e\u001c7cC\u000e\\7+\u0019<fa>Lg\u000e^:Qe>\u001cW\rZ;sKB\u00111#\u0019\u0004\u0006\u0003\tA\tAY\n\u0003C\u000e\u0004\"a\n3\n\u0005\u0015D#AB!osJ+g\rC\u0003!C\u0012\u0005q\rF\u0001a\u0011\u001dI\u0017M1A\u0005\u0002)\fAAT!N\u000bV\t1\u000e\u0005\u0002m_:\u0011q%\\\u0005\u0003]\"\na\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\u0019\u0019FO]5oO*\u0011a\u000e\u000b\u0005\u0007g\u0006\u0004\u000b\u0011B6\u0002\u000b9\u000bU*\u0012\u0011\t\u000bU\fG\u0011\u0001<\u0002\u000f\t,\u0018\u000e\u001c3feV\tq\u000fE\u0002y\u007fZi\u0011!\u001f\u0006\u0003un\f\u0001BZ;oGRLwN\u001c\u0006\u0003yv\fA!\u001e;jY*\ta0\u0001\u0003kCZ\f\u0017bAA\u0001s\nA1+\u001e9qY&,'\u000f")
public class RollbackSavepointsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RollbackSavepointsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RollbackSavepointsProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieTimeline completedInstants = metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants();
        if (completedInstants.empty()) {
            throw new HoodieException("There are no completed savepoint to run delete");
        }
        HoodieInstant savePoint = new HoodieInstant(false, "savepoint", instantTime);
        if (!completedInstants.containsInstant(savePoint)) throw new HoodieException(new StringBuilder().append((Object)"Commit ").append((Object)instantTime).append((Object)" not found in Commits ").append((Object)completedInstants).toString());
        SparkRDDWriteClient<HoodieRecordPayload<?>> client = this.createHoodieClient(this.jsc(), basePath);
        boolean result = false;
        try {
            client.restoreToSavepoint(instantTime);
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The commit $instantTime rolled back.";
                }
            });
            result = true;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
        }
        catch (HoodieSavepointException hoodieSavepointException) {
            this.logWarning((Function0<String>)new Serializable(this, instantTime){
                public static final long serialVersionUID = 0L;
                private final String instantTime$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The commit ", " failed to roll back."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.instantTime$1}));
                }
                {
                    this.instantTime$1 = instantTime$1;
                }
            });
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)result)}))}));
    }

    @Override
    public Procedure build() {
        return new RollbackSavepointsProcedure();
    }

    public RollbackSavepointsProcedure() {
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(1, "instant_time", DataTypes.StringType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("rollback_savepoint_result", DataTypes.BooleanType, true, Metadata$.MODULE$.empty())}));
    }
}

