/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.BaseHoodieTableFileIndex;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.HoodieCatalystExpressionUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunClusteringProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001E\u0011aCU;o\u00072,8\u000f^3sS:<\u0007K]8dK\u0012,(/\u001a\u0006\u0003\u0007\u0011\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t)a!A\u0004d_6l\u0017M\u001c3\u000b\u0005\u001dA\u0011\u0001\u00025vI&T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\n\u00173\u0005:\u0003CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0011\u0005iyR\"A\u000e\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!A\b\u0005\u0002\u0011\r\fG/\u00197zgRL!\u0001I\u000e\u0003\u001fA\u0013X\rZ5dCR,\u0007*\u001a7qKJ\u0004\"AI\u0013\u000e\u0003\rR!\u0001\n\u0006\u0002\u0011%tG/\u001a:oC2L!AJ\u0012\u0003\u000f1{wmZ5oOB\u0011\u0001FK\u0007\u0002S)\u0011q\u0001D\u0005\u0003W%\u00121c\u00159be.\fE-\u00199uKJ\u001cV\u000f\u001d9peRDQ!\f\u0001\u0005\u00029\na\u0001P5oSRtD#A\u0018\u0011\u0005M\u0001\u0001bB\u0019\u0001\u0005\u0004%IAM\u0001\nKb\u0004(/\u0016;jYN,\u0012a\r\t\u0003iUj\u0011\u0001C\u0005\u0003m!\u0011Q\u0004S8pI&,7)\u0019;bYf\u001cH/\u0012=qe\u0016\u001c8/[8o+RLGn\u001d\u0005\u0007q\u0001\u0001\u000b\u0011B\u001a\u0002\u0015\u0015D\bO]+uS2\u001c\b\u0005C\u0004;\u0001\t\u0007I\u0011B\u001e\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001=!\ri\u0004IQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t)\u0011I\u001d:bsB\u00111cQ\u0005\u0003\t\n\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\"1a\t\u0001Q\u0001\nq\n1\u0002U!S\u00036+E+\u0012*TA!9\u0001\n\u0001b\u0001\n\u0013I\u0015aC(V)B+Fk\u0018+Z!\u0016+\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\"\tQ\u0001^=qKNL!a\u0014'\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004R\u0001\u0001\u0006IAS\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\t\t\u0005\u0006'\u0002!\taO\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\"B+\u0001\t\u0003I\u0015AC8viB,H\u000fV=qK\")q\u000b\u0001C!1\u0006!1-\u00197m)\tI\u0006\u000eE\u0002[E\u0016t!a\u00171\u000f\u0005q{V\"A/\u000b\u0005y\u0003\u0012A\u0002\u001fs_>$h(C\u0001@\u0013\t\tg(A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'aA*fc*\u0011\u0011M\u0010\t\u0003i\u0019L!a\u001a\u0005\u0003\u0007I{w\u000fC\u0003j-\u0002\u0007!.\u0001\u0003be\u001e\u001c\bCA\nl\u0013\ta'AA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm\u001d\u0005\u0006]\u0002!\te\\\u0001\u0006EVLG\u000eZ\u000b\u0002aB\u00111#]\u0005\u0003e\n\u0011\u0011\u0002\u0015:pG\u0016$WO]3\t\u000bQ\u0004A\u0011A;\u0002\u001dA\u0014XO\\3QCJ$\u0018\u000e^5p]R!a/`A\b!\t9(P\u0004\u0002>q&\u0011\u0011PP\u0001\u0007!J,G-\u001a4\n\u0005md(AB*ue&twM\u0003\u0002z}!)ap\u001da\u0001\u007f\u0006QQ.\u001a;b\u00072LWM\u001c;\u0011\t\u0005\u0005\u00111B\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005)A/\u00192mK*\u0019\u0011\u0011B\u0015\u0002\r\r|W.\\8o\u0013\u0011\ti!a\u0001\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\"1\u0011\u0011C:A\u0002Y\f\u0011\u0002\u001d:fI&\u001c\u0017\r^3\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018\u0005!b/\u00197jI\u0006$Xm\u0014:eKJ\u001cu\u000e\\;n]N$b!!\u0007\u0002 \u0005\r\u0002cA\u001f\u0002\u001c%\u0019\u0011Q\u0004 \u0003\tUs\u0017\u000e\u001e\u0005\b\u0003C\t\u0019\u00021\u0001w\u00031y'\u000fZ3s\u0007>dW/\u001c8t\u0011\u0019q\u00181\u0003a\u0001\u007f\u001e9\u0011q\u0005\u0002\t\u0002\u0005%\u0012A\u0006*v]\u000ecWo\u001d;fe&tw\r\u0015:pG\u0016$WO]3\u0011\u0007M\tYC\u0002\u0004\u0002\u0005!\u0005\u0011QF\n\u0005\u0003W\ty\u0003E\u0002>\u0003cI1!a\r?\u0005\u0019\te.\u001f*fM\"9Q&a\u000b\u0005\u0002\u0005]BCAA\u0015\u0011)\tY$a\u000bC\u0002\u0013\u0005\u0011QH\u0001\u0005\u001d\u0006kU)\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001\u00027b]\u001eT!!!\u0013\u0002\t)\fg/Y\u0005\u0004w\u0006\r\u0003\"CA(\u0003W\u0001\u000b\u0011BA \u0003\u0015q\u0015)T#!\u0011!\t\u0019&a\u000b\u0005\u0002\u0005U\u0013a\u00022vS2$WM]\u000b\u0003\u0003/\u0002R!!\u0017\u0002dYi!!a\u0017\u000b\t\u0005u\u0013qL\u0001\tMVt7\r^5p]*!\u0011\u0011MA$\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u00141\f\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class RunClusteringProcedure
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper,
Logging,
SparkAdapterSupport {
    private final HoodieCatalystExpressionUtils exprUtils;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return RunClusteringProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunClusteringProcedure$.MODULE$.NAME();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        RunClusteringProcedure runClusteringProcedure = this;
        synchronized (runClusteringProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitConjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.class.splitDisjunctivePredicates((PredicateHelper)this, (Expression)condition);
    }

    public Expression replaceAlias(Expression condition, AttributeMap<Expression> aliases) {
        return PredicateHelper.class.replaceAlias((PredicateHelper)this, (Expression)condition, aliases);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.class.canEvaluate((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.class.canEvaluateWithinJoin((PredicateHelper)this, (Expression)expr);
    }

    private HoodieCatalystExpressionUtils exprUtils() {
        return this.exprUtils;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        Option<Object> predicate = this.getArgValueOrDefault(args, this.PARAMETERS()[2]);
        Option<Object> orderColumns = this.getArgValueOrDefault(args, this.PARAMETERS()[3]);
        boolean showInvolvedPartitions = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get());
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        Map conf = Predef$.MODULE$.Map().empty();
        Option<Object> option = predicate;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object p = some.x();
            String prunedPartitions = this.prunePartition(metaClient, (String)p);
            conf = conf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_PARTITION_FILTER_MODE_NAME.key()), (Object)"SELECTED_PARTITIONS"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PARTITION_SELECTED.key()), (Object)prunedPartitions)})));
            this.logInfo((Function0<String>)new Serializable(this, p, prunedPartitions){
                public static final long serialVersionUID = 0L;
                private final Object p$1;
                private final String prunedPartitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition predicates: ", ", partition selected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.p$1, this.prunedPartitions$1}));
                }
                {
                    this.p$1 = p$1;
                    this.prunedPartitions$1 = prunedPartitions$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No partition predicates";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Option<Object> option2 = orderColumns;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Object o = some.x();
            this.validateOrderColumns((String)o, metaClient);
            conf = conf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()), (Object)((String)o))})));
            this.logInfo((Function0<String>)new Serializable(this, o){
                public static final long serialVersionUID = 0L;
                private final Object o$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Order columns: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.o$1}));
                }
                {
                    this.o$1 = o$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "No order columns";
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ObjectRef pendingClustering = ObjectRef.create((Object)((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ClusteringUtils.getAllPendingClusteringPlans(metaClient).iterator()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Pair<HoodieInstant, HoodieClusteringPlan> x$1) {
                return x$1.getLeft().getTimestamp();
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String f) {
                return f;
            }
        }, (Ordering)Ordering.String$.MODULE$)));
        this.logInfo((Function0<String>)new Serializable(this, pendingClustering){
            public static final long serialVersionUID = 0L;
            private final ObjectRef pendingClustering$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Pending clustering instants: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}));
            }
            {
                this.pendingClustering$1 = pendingClustering$1;
            }
        });
        SparkRDDWriteClient<?> client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath(this.sparkSession(), basePath, (Map<String, String>)conf);
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        if (client.scheduleClusteringAtInstant(instantTime, org.apache.hudi.common.util.Option.empty())) {
            pendingClustering.elem = (Seq)((Seq)pendingClustering.elem).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTime})), Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)new Serializable(this, pendingClustering){
            public static final long serialVersionUID = 0L;
            private final ObjectRef pendingClustering$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Clustering instants to run: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}));
            }
            {
                this.pendingClustering$1 = pendingClustering$1;
            }
        });
        long startTs = System.currentTimeMillis();
        ((Seq)pendingClustering.elem).foreach((Function1)new Serializable(this, client){
            public static final long serialVersionUID = 0L;
            private final SparkRDDWriteClient client$1;

            public final HoodieWriteMetadata<JavaRDD<WriteStatus>> apply(String x$2) {
                return this.client$1.cluster(x$2, true);
            }
            {
                this.client$1 = client$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(this, pendingClustering, startTs){
            public static final long serialVersionUID = 0L;
            private final ObjectRef pendingClustering$1;
            private final long startTs$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finish clustering all the instants: ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Seq)this.pendingClustering$1.elem).mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" time cost: ", "ms."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.startTs$1))}))).toString();
            }
            {
                this.pendingClustering$1 = pendingClustering$1;
                this.startTs$1 = startTs$1;
            }
        });
        Seq clusteringInstants = (Seq)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.reloadActiveTimeline().getInstants().iterator()).asScala()).filter((Function1)new Serializable(this, pendingClustering){
            public static final long serialVersionUID = 0L;
            private final ObjectRef pendingClustering$1;

            public final boolean apply(HoodieInstant p) {
                String string = p.getAction();
                String string2 = "replacecommit";
                return !(string != null ? !string.equals(string2) : string2 != null) && ((Seq)this.pendingClustering$1.elem).contains((Object)p.getTimestamp());
            }
            {
                this.pendingClustering$1 = pendingClustering$1;
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(HoodieInstant f) {
                return f.getTimestamp();
            }
        }, (Ordering)Ordering.String$.MODULE$)).reverse();
        Seq clusteringPlans = (Seq)clusteringInstants.map((Function1)new Serializable(this, metaClient){
            public static final long serialVersionUID = 0L;
            private final HoodieTableMetaClient metaClient$1;

            public final org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> apply(HoodieInstant instant) {
                return ClusteringUtils.getClusteringPlan(this.metaClient$1, instant);
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return showInvolvedPartitions ? (Seq)clusteringPlans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> p) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.get().getLeft().getTimestamp(), BoxesRunTime.boxToInteger((int)p.get().getRight().getInputGroups().size()), p.get().getLeft().getState().name(), HoodieCLIUtils$.MODULE$.extractPartitions((Seq<HoodieClusteringGroup>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(p.get().getRight().getInputGroups()).asScala()))}));
            }
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)clusteringPlans.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(org.apache.hudi.common.util.Option<Pair<HoodieInstant, HoodieClusteringPlan>> p) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p.get().getLeft().getTimestamp(), BoxesRunTime.boxToInteger((int)p.get().getRight().getInputGroups().size()), p.get().getLeft().getState().name(), "*"}));
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Procedure build() {
        return new RunClusteringProcedure();
    }

    public String prunePartition(HoodieTableMetaClient metaClient, String predicate) {
        Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE().key()), (Object)DataSourceReadOptions$.MODULE$.QUERY_TYPE_SNAPSHOT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath())}));
        HoodieFileIndex hoodieFileIndex = new HoodieFileIndex(this.sparkSession(), metaClient, (Option<StructType>)None$.MODULE$, (Map<String, String>)options, FileStatusCache$.MODULE$.getOrCreate(this.sparkSession()));
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        StructType tableSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaResolver.getTableAvroSchema());
        Expression condition = this.exprUtils().resolveExpr(this.sparkSession(), predicate, tableSchema);
        String[] partitionColumns = metaClient.getTableConfig().getPartitionFields().orElse((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
        Tuple2<Expression[], Expression[]> tuple2 = this.exprUtils().splitPartitionAndDataPredicates(this.sparkSession(), (Expression[])this.splitConjunctivePredicates(condition).toArray(ClassTag$.MODULE$.apply(Expression.class)), partitionColumns);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Expression[] partitionPredicates = (Expression[])tuple2._1();
            Expression[] dataPredicates = (Expression[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)partitionPredicates, (Object)dataPredicates);
            Expression[] partitionPredicates2 = (Expression[])tuple23._1();
            Expression[] dataPredicates2 = (Expression[])tuple23._2();
            ValidationUtils.checkArgument(Predef$.MODULE$.refArrayOps((Object[])dataPredicates2).isEmpty(), "Only partition predicates are allowed");
            Seq<BaseHoodieTableFileIndex.PartitionPath> prunedPartitions = hoodieFileIndex.getPartitionPaths((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])partitionPredicates2));
            return ((TraversableOnce)prunedPartitions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(BaseHoodieTableFileIndex.PartitionPath partitionPath) {
                    return partitionPath.getPath();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet().mkString(",");
        }
        throw new MatchError(tuple2);
    }

    private void validateOrderColumns(String orderColumns, HoodieTableMetaClient metaClient) {
        if (orderColumns == null) {
            throw new HoodieClusteringException("Order columns is null");
        }
        TableSchemaResolver tableSchemaResolver = new TableSchemaResolver(metaClient);
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableSchemaResolver.getTableAvroSchema(false).getFields()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Schema.Field x$4) {
                return x$4.name().toLowerCase();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.refArrayOps((Object[])orderColumns.split(",")).foreach((Function1)new Serializable(this, fields){
            public static final long serialVersionUID = 0L;
            private final Buffer fields$1;

            public final void apply(String col) {
                if (this.fields$1.contains((Object)col.toLowerCase())) {
                    return;
                }
                throw new HoodieClusteringException(new StringBuilder().append((Object)"Order column not exist:").append((Object)col).toString());
            }
            {
                this.fields$1 = fields$1;
            }
        });
    }

    public RunClusteringProcedure() {
        PredicateHelper.class.$init$((PredicateHelper)this);
        Logging.class.$init$((Logging)this);
        SparkAdapterSupport$class.$init$(this);
        this.exprUtils = this.sparkAdapter().createCatalystExpressionUtils();
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "predicate", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(3, "order", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(4, "show_involved_partition", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("input_group_size", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("state", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("involved_partitions", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

