/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieDefaultTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitsProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitsProcedure$$anonfun$getCommitsWithMetadata$1$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001E\u0011Ac\u00155po\u000e{W.\\5ugB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0006\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011QBQ1tKB\u0013xnY3ekJ,\u0007CA\n\u0018\u0013\tA\"A\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\u000bj]\u000edW\u000fZ3FqR\u0014\u0018-T3uC\u0012\fG/\u0019\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0003\u0001\"\u0001$\u0003\u0019a\u0014N\\5u}Q\u0011A%\n\t\u0003'\u0001AQAG\u0011A\u0002mA\u0011b\n\u0001A\u0002\u0003\u0007I\u0011\u0001\u0015\u0002)M|'\u000f\u001e\"z\r&,G\u000e\u001a)be\u0006lW\r^3s+\u0005I\u0003CA\n+\u0013\tY#A\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\b\"C\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001/\u0003a\u0019xN\u001d;Cs\u001aKW\r\u001c3QCJ\fW.\u001a;fe~#S-\u001d\u000b\u0003_I\u0002\"\u0001\b\u0019\n\u0005Ej\"\u0001B+oSRDqa\r\u0017\u0002\u0002\u0003\u0007\u0011&A\u0002yIEBa!\u000e\u0001!B\u0013I\u0013!F:peR\u0014\u0015PR5fY\u0012\u0004\u0016M]1nKR,'\u000f\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002sA\u0019ADO\u0015\n\u0005mj\"!B!se\u0006L\bBB\u001f\u0001A\u0003%\u0011(A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0003bB \u0001\u0005\u0004%I\u0001Q\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001B!\t\u0011U)D\u0001D\u0015\t!\u0005\"A\u0003usB,7/\u0003\u0002G\u0007\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r!\u0003\u0001\u0015!\u0003B\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0011\u001dQ\u0005A1A\u0005\n\u0001\u000bA#T#U\u0003\u0012\u000bE+Q0P+R\u0003V\u000bV0U3B+\u0005B\u0002'\u0001A\u0003%\u0011)A\u000bN\u000bR\u000bE)\u0011+B?>+F\u000bU+U?RK\u0006+\u0012\u0011\t\u000b9\u0003A\u0011\u0001\u001d\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fC\u0003Q\u0001\u0011\u0005\u0001)\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016DQA\u0015\u0001\u0005BM\u000bAaY1mYR\u0011A\u000b\u001a\t\u0004+v\u0003gB\u0001,\\\u001d\t9&,D\u0001Y\u0015\tI\u0006#\u0001\u0004=e>|GOP\u0005\u0002=%\u0011A,H\u0001\ba\u0006\u001c7.Y4f\u0013\tqvLA\u0002TKFT!\u0001X\u000f\u0011\u0005\u0005\u0014W\"\u0001\u0005\n\u0005\rD!a\u0001*po\")Q-\u0015a\u0001M\u0006!\u0011M]4t!\t\u0019r-\u0003\u0002i\u0005\ti\u0001K]8dK\u0012,(/Z!sONDQA\u001b\u0001\u0005B-\fQAY;jY\u0012,\u0012\u0001\u001c\t\u0003'5L!A\u001c\u0002\u0003\u0013A\u0013xnY3ekJ,\u0007\"\u00029\u0001\t\u0013\t\u0018AF4fi\u000e{W.\\5ug^KG\u000f['fi\u0006$\u0017\r^1\u0015\u0007Q\u0013h\u0010C\u0003t_\u0002\u0007A/\u0001\u0005uS6,G.\u001b8f!\t)H0D\u0001w\u0015\t\u0019xO\u0003\u0002ys\u0006)A/\u00192mK*\u0011!p_\u0001\u0007G>lWn\u001c8\u000b\u0005\u001da\u0011BA?w\u0005UAun\u001c3jK\u0012+g-Y;miRKW.\u001a7j]\u0016Daa`8A\u0002\u0005\u0005\u0011!\u00027j[&$\bc\u0001\u000f\u0002\u0004%\u0019\u0011QA\u000f\u0003\u0007%sG\u000fC\u0004\u0002\n\u0001!I!a\u0003\u0002\u001d\u001d,GoU8si\u000e{W.\\5ugR!\u0011QBA\u0016!\u001da\u0012qBA\n\u0003GI1!!\u0005\u001e\u0005\u0019!V\u000f\u001d7feA)\u0011QCA\u0010A6\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003vi&d'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\n\u0003J\u0014\u0018-\u001f'jgR\u0004b!!\u0006\u0002 \u0005\u0015\u0002cA;\u0002(%\u0019\u0011\u0011\u0006<\u0003\u001b!{w\u000eZ5f\u0013:\u001cH/\u00198u\u0011\u0019\u0019\u0018q\u0001a\u0001i\"9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012AC4fi\u000e{W.\\5ugR)A+a\r\u00026!11/!\fA\u0002QDqa`A\u0017\u0001\u0004\t\taB\u0004\u0002:\tA\t!a\u000f\u0002)MCwn^\"p[6LGo\u001d)s_\u000e,G-\u001e:f!\r\u0019\u0012Q\b\u0004\u0007\u0003\tA\t!a\u0010\u0014\t\u0005u\u0012\u0011\t\t\u00049\u0005\r\u0013bAA#;\t1\u0011I\\=SK\u001aDqAIA\u001f\t\u0003\tI\u0005\u0006\u0002\u0002<!Q\u0011QJA\u001f\u0005\u0004%\t!a\u0014\u0002\t9\u000bU*R\u000b\u0003\u0003#\u0002B!a\u0015\u0002Z5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nY\"\u0001\u0003mC:<\u0017\u0002BA.\u0003+\u0012aa\u0015;sS:<\u0007\"CA0\u0003{\u0001\u000b\u0011BA)\u0003\u0015q\u0015)T#!\u0011!\t\u0019'!\u0010\u0005\u0002\u0005\u0015\u0014a\u00022vS2$WM]\u000b\u0003\u0003O\u0002R!!\u001b\u0002pYi!!a\u001b\u000b\t\u00055\u0014qC\u0001\tMVt7\r^5p]&!\u0011\u0011OA6\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class ShowCommitsProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final boolean includeExtraMetadata;
    private ProcedureParameter sortByFieldParameter;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final StructType METADATA_OUTPUT_TYPE;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitsProcedure$.MODULE$.NAME();
    }

    public ProcedureParameter sortByFieldParameter() {
        return this.sortByFieldParameter;
    }

    public void sortByFieldParameter_$eq(ProcedureParameter x$1) {
        this.sortByFieldParameter = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private StructType METADATA_OUTPUT_TYPE() {
        return this.METADATA_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.includeExtraMetadata ? this.METADATA_OUTPUT_TYPE() : this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(this.sparkSession(), new TableIdentifier(table));
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        return this.includeExtraMetadata ? this.getCommitsWithMetadata(activeTimeline, limit) : this.getCommits(activeTimeline, limit);
    }

    @Override
    public Procedure build() {
        return new ShowCommitsProcedure(this.includeExtraMetadata);
    }

    private Seq<Row> getCommitsWithMetadata(HoodieDefaultTimeline timeline, int limit) {
        Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2 = this.getSortCommits(timeline);
        if (tuple2 != null) {
            ArrayList rows = (ArrayList)tuple2._1();
            ArrayList newCommits = (ArrayList)tuple2._2();
            if (rows != null) {
                ArrayList arrayList = rows;
                if (newCommits != null) {
                    Tuple2 tuple22;
                    ArrayList arrayList2 = newCommits;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)arrayList, (Object)arrayList2);
                    ArrayList rows2 = (ArrayList)tuple23._1();
                    ArrayList newCommits2 = (ArrayList)tuple23._2();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach$mVc$sp((Function1)new Serializable(this, timeline, rows2, newCommits2){
                        public static final long serialVersionUID = 0L;
                        private final HoodieDefaultTimeline timeline$1;
                        public final ArrayList rows$1;
                        private final ArrayList newCommits$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            HoodieInstant commit = (HoodieInstant)this.newCommits$1.get(i);
                            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.timeline$1.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
                            JavaConversions$.MODULE$.asScalaSet(commitMetadata.getPartitionToWriteStats().entrySet()).foreach((Function1)new Serializable(this, commit){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$getCommitsWithMetadata$1 $outer;
                                public final HoodieInstant commit$1;

                                public final void apply(Map.Entry<String, List<HoodieWriteStat>> partitionWriteStat) {
                                    JavaConversions$.MODULE$.asScalaBuffer(partitionWriteStat.getValue()).foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$getCommitsWithMetadata$1$$anonfun$apply$mcVI$sp$1 $outer;

                                        public final boolean apply(HoodieWriteStat hoodieWriteStat) {
                                            return this.$outer.org$apache$spark$sql$hudi$command$procedures$ShowCommitsProcedure$$anonfun$$anonfun$$$outer().rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.commit$1.getTimestamp(), this.$outer.commit$1.getAction(), hoodieWriteStat.getPartitionPath(), hoodieWriteStat.getFileId(), hoodieWriteStat.getPrevCommit(), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumInserts()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumDeletes()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalCorruptLogBlock()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalRollbackBlocks()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalLogRecords()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalUpdatedRecordsCompacted()), BoxesRunTime.boxToLong((long)hoodieWriteStat.getTotalWriteBytes())})));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$getCommitsWithMetadata$1 org$apache$spark$sql$hudi$command$procedures$ShowCommitsProcedure$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.commit$1 = commit$1;
                                }
                            });
                        }
                        {
                            this.timeline$1 = timeline$1;
                            this.rows$1 = rows$1;
                            this.newCommits$1 = newCommits$1;
                        }
                    });
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows2.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Row apply(Object r) {
                            return (Row)r;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> getSortCommits(HoodieDefaultTimeline timeline) {
        ArrayList rows = new ArrayList();
        List commits = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(timeline.getCommitsTimeline().filterCompletedInstants().getInstants().toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HoodieInstant apply(Object instant) {
                return (HoodieInstant)instant;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieInstant.class)))).toList()).asJava();
        ArrayList newCommits = new ArrayList(commits);
        Collections.sort(newCommits, HoodieInstant.COMPARATOR.reversed());
        return new Tuple2(rows, newCommits);
    }

    public Seq<Row> getCommits(HoodieDefaultTimeline timeline, int limit) {
        Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2 = this.getSortCommits(timeline);
        if (tuple2 != null) {
            ArrayList rows = (ArrayList)tuple2._1();
            ArrayList newCommits = (ArrayList)tuple2._2();
            if (rows != null) {
                ArrayList arrayList = rows;
                if (newCommits != null) {
                    Tuple2 tuple22;
                    ArrayList arrayList2 = newCommits;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)arrayList, (Object)arrayList2);
                    ArrayList rows2 = (ArrayList)tuple23._1();
                    ArrayList newCommits2 = (ArrayList)tuple23._2();
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newCommits2.size()).foreach((Function1)new Serializable(this, timeline, rows2, newCommits2){
                        public static final long serialVersionUID = 0L;
                        private final HoodieDefaultTimeline timeline$2;
                        private final ArrayList rows$2;
                        private final ArrayList newCommits$2;

                        public final boolean apply(int i) {
                            return this.apply$mcZI$sp(i);
                        }

                        public boolean apply$mcZI$sp(int i) {
                            HoodieInstant commit = (HoodieInstant)this.newCommits$2.get(i);
                            HoodieCommitMetadata commitMetadata = HoodieCommitMetadata.fromBytes(this.timeline$2.getInstantDetails(commit).get(), HoodieCommitMetadata.class);
                            return this.rows$2.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commit.getTimestamp(), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalBytesWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesInsert()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalFilesUpdated()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalPartitionsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalUpdateRecordsWritten()), BoxesRunTime.boxToLong((long)commitMetadata.fetchTotalWriteErrors())})));
                        }
                        {
                            this.timeline$2 = timeline$2;
                            this.rows$2 = rows$2;
                            this.newCommits$2 = newCommits$2;
                        }
                    });
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows2.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Row apply(Object r) {
                            return (Row)r;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public ShowCommitsProcedure(boolean includeExtraMetadata) {
        this.includeExtraMetadata = includeExtraMetadata;
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_added", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_partitions_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_update_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
        this.METADATA_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("num_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_inserts", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_deletes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_update_writes", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_corrupt_logblocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_rollback_blocks", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_log_records", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_updated_records_compacted", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

