/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCompactionProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001E\u0011qc\u00155po\u000e{W\u000e]1di&|g\u000e\u0015:pG\u0016$WO]3\u000b\u0005\r!\u0011A\u00039s_\u000e,G-\u001e:fg*\u0011QAB\u0001\bG>lW.\u00198e\u0015\t9\u0001\"\u0001\u0003ik\u0012L'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011#\u0002\u0001\u0013-eq\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0011\u0005iaR\"A\u000e\u000b\u0005\u001da\u0011BA\u000f\u001c\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u!\ty\"%D\u0001!\u0015\t\t#\"\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0003EA\u0004M_\u001e<\u0017N\\4\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003CA\n\u0001\u0011\u001dI\u0003A1A\u0005\n)\n!\u0002U!S\u00036+E+\u0012*T+\u0005Y\u0003c\u0001\u00170c5\tQFC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001TFA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014e%\u00111G\u0001\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'\u000f\u0003\u00046\u0001\u0001\u0006IaK\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006\u0005C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011A\bC\u0001\u0006if\u0004Xm]\u0005\u0003}m\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019\u0001\u0005\u0001)A\u0005s\u0005aq*\u0016+Q+R{F+\u0017)FA!)!\t\u0001C\u0001U\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000b\u0011\u0003A\u0011\u0001\u001d\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0003G\u0001\u0011\u0005s)\u0001\u0003dC2dGC\u0001%Y!\rI\u0015\u000b\u0016\b\u0003\u0015>s!a\u0013(\u000e\u00031S!!\u0014\t\u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0013B\u0001).\u0003\u001d\u0001\u0018mY6bO\u0016L!AU*\u0003\u0007M+\u0017O\u0003\u0002Q[A\u0011QKV\u0007\u0002\u0011%\u0011q\u000b\u0003\u0002\u0004%><\b\"B-F\u0001\u0004Q\u0016\u0001B1sON\u0004\"aE.\n\u0005q\u0013!!\u0004)s_\u000e,G-\u001e:f\u0003J<7\u000fC\u0003_\u0001\u0011\u0005s,A\u0003ck&dG-F\u0001a!\t\u0019\u0012-\u0003\u0002c\u0005\tI\u0001K]8dK\u0012,(/Z\u0004\u0006I\nA\t!Z\u0001\u0018'\"|woQ8na\u0006\u001cG/[8o!J|7-\u001a3ve\u0016\u0004\"a\u00054\u0007\u000b\u0005\u0011\u0001\u0012A4\u0014\u0005\u0019D\u0007C\u0001\u0017j\u0013\tQWF\u0001\u0004B]f\u0014VM\u001a\u0005\u0006K\u0019$\t\u0001\u001c\u000b\u0002K\"9aN\u001ab\u0001\n\u0003y\u0017\u0001\u0002(B\u001b\u0016+\u0012\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\fA\u0001\\1oO*\tQ/\u0001\u0003kCZ\f\u0017BA<s\u0005\u0019\u0019FO]5oO\"1\u0011P\u001aQ\u0001\nA\fQAT!N\u000b\u0002BQa\u001f4\u0005\u0002q\fqAY;jY\u0012,'/F\u0001~!\u0011q\u0018q\u0001\f\u000e\u0003}TA!!\u0001\u0002\u0004\u0005Aa-\u001e8di&|gNC\u0002\u0002\u0006Q\fA!\u001e;jY&\u0019\u0011\u0011B@\u0003\u0011M+\b\u000f\u001d7jKJ\u0004")
public class ShowCompactionProcedure
extends BaseProcedure
implements ProcedureBuilder,
SparkAdapterSupport,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCompactionProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCompactionProcedure$.MODULE$.NAME();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        ShowCompactionProcedure showCompactionProcedure = this;
        synchronized (showCompactionProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieTableType hoodieTableType = metaClient.getTableType();
        HoodieTableType hoodieTableType2 = HoodieTableType.MERGE_ON_READ;
        Predef$.MODULE$.assert(!(hoodieTableType != null ? !((Object)((Object)hoodieTableType)).equals((Object)hoodieTableType2) : hoodieTableType2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot show compaction on a Non Merge On Read table."})).s((Seq)Nil$.MODULE$);
            }
        });
        Seq compactionInstants = (Seq)((IterableLike)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.getActiveTimeline().getInstants().iterator()).asScala()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(HoodieInstant p) {
                String string = p.getAction();
                String string2 = "compaction";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        }).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(HoodieInstant f) {
                return f.getTimestamp();
            }
        }, (Ordering)Ordering.String$.MODULE$)).reverse()).take(limit);
        return (Seq)((TraversableLike)compactionInstants.map((Function1)new Serializable(this, metaClient){
            public static final long serialVersionUID = 0L;
            private final HoodieTableMetaClient metaClient$1;

            public final Tuple2<HoodieInstant, HoodieCompactionPlan> apply(HoodieInstant instant) {
                return new Tuple2((Object)instant, (Object)((Object)CompactionUtils.getCompactionPlan(this.metaClient$1, instant.getTimestamp())));
            }
            {
                this.metaClient$1 = metaClient$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Tuple2<HoodieInstant, HoodieCompactionPlan> x0$1) {
                Tuple2<HoodieInstant, HoodieCompactionPlan> tuple2 = x0$1;
                if (tuple2 != null) {
                    HoodieInstant instant = (HoodieInstant)tuple2._1();
                    HoodieCompactionPlan plan = (HoodieCompactionPlan)((Object)tuple2._2());
                    Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instant.getTimestamp(), BoxesRunTime.boxToInteger((int)plan.getOperations().size()), instant.getState().name()}));
                    return row;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Procedure build() {
        return new ShowCompactionProcedure();
    }

    public ShowCompactionProcedure() {
        SparkAdapterSupport$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)20))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("operation_size", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("state", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

