/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.optimize.HilbertCurveUtils;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.hudi.execution.ByteArraySorting;
import org.apache.spark.sql.hudi.execution.RangeSample;
import org.apache.spark.sql.hudi.execution.RangeSample$;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$$anonfun$32$;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$$anonfun$33$;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$$anonfun$48$;
import org.apache.spark.sql.hudi.execution.RawDecisionBound;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.MutablePair;
import org.davidmoten.hilbert.HilbertCurve;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class RangeSampleSort$ {
    public static final RangeSampleSort$ MODULE$;

    static {
        new RangeSampleSort$();
    }

    public Dataset<Row> sortDataFrameBySample(Dataset<Row> df, HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy, Seq<String> orderByCols, int targetPartitionsCount) {
        Dataset dataset;
        SparkSession spark = df.sparkSession();
        Map columnsMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField item) {
                return new Tuple2((Object)item.name(), (Object)item);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        int fieldNum = df.schema().fields().length;
        Seq checkCols = (Seq)orderByCols.filter((Function1)new Serializable(columnsMap){
            public static final long serialVersionUID = 0L;
            private final Map columnsMap$1;

            public final boolean apply(String col) {
                return this.columnsMap$1.apply((Object)col) != null;
            }
            {
                this.columnsMap$1 = columnsMap$1;
            }
        });
        if (orderByCols.isEmpty() || checkCols.isEmpty()) {
            dataset = df;
        } else {
            Seq zFields = (Seq)((TraversableLike)orderByCols.map((Function1)new Serializable(df, columnsMap){
                public static final long serialVersionUID = 0L;
                private final Dataset df$1;
                private final Map columnsMap$1;

                public final Tuple2<Object, StructField> apply(String col) {
                    Tuple2 tuple2;
                    StructField newCol = (StructField)this.columnsMap$1.apply((Object)col);
                    if (newCol == null) {
                        tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), null);
                    } else {
                        DataType dataType = newCol.dataType();
                        boolean bl = LongType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (StringType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType))))))));
                        Tuple2 tuple22 = bl ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.df$1.schema().fields()).indexOf((Object)newCol)), (Object)newCol) : (dataType instanceof DecimalType ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.df$1.schema().fields()).indexOf((Object)newCol)), (Object)newCol) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), null));
                        tuple2 = tuple22;
                    }
                    return tuple2;
                }
                {
                    this.df$1 = df$1;
                    this.columnsMap$1 = columnsMap$1;
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, StructField> x$12) {
                    return x$12._1$mcI$sp() != -1;
                }
            });
            if (zFields.length() != orderByCols.length()) {
                return this.sortDataFrameBySampleSupportAllTypes(df, orderByCols, targetPartitionsCount);
            }
            RDD rawRdd = df.rdd();
            RDD sampleRdd = rawRdd.map((Function1)new Serializable(zFields){
                public static final long serialVersionUID = 0L;
                private final Seq zFields$1;

                public final Tuple2<Object[], Null$> apply(Row row) {
                    Object[] values2 = (Object[])((TraversableOnce)((TraversableLike)this.zFields$1.map((Function1)new Serializable(this, row){
                        public static final long serialVersionUID = 0L;
                        private final Row row$1;

                        public final Object apply(Tuple2<Object, StructField> x0$3) {
                            Tuple2<Object, StructField> tuple2 = x0$3;
                            if (tuple2 != null) {
                                int index = tuple2._1$mcI$sp();
                                StructField field = (StructField)tuple2._2();
                                DataType dataType = field.dataType();
                                Object object = LongType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getLong(index))) : (DoubleType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)Double.doubleToLongBits(this.row$1.getDouble(index)))) : (IntegerType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getInt(index))) : (FloatType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)Double.doubleToLongBits(this.row$1.getFloat(index)))) : (StringType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? "" : this.row$1.getString(index)) : (DateType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getDate(index).getTime())) : (TimestampType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getTimestamp(index).getTime())) : (ByteType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getByte(index))) : (ShortType$.MODULE$.equals(dataType) ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getShort(index))) : (dataType instanceof DecimalType ? (this.row$1.isNullAt(index) ? BoxesRunTime.boxToLong((long)Long.MAX_VALUE) : BoxesRunTime.boxToLong((long)this.row$1.getDecimal(index).longValue())) : null)))))))));
                                Long l = object;
                                return l;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.row$1 = row$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Object v) {
                            return v != null;
                        }
                    })).toArray(ClassTag$.MODULE$.Any());
                    return new Tuple2((Object)values2, null);
                }
                {
                    this.zFields$1 = zFields$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            int zOrderBounds = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.key(), HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.defaultValue().toString()))).toInt();
            RangeSample sample = new RangeSample(zOrderBounds, sampleRdd, RangeSample$.MODULE$.$lessinit$greater$default$3(), RangeSample$.MODULE$.$lessinit$greater$default$4(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Object.class)));
            ArrayBuffer rangeBounds = sample.getRangeBounds();
            int candidateColNumber = ((Object[])((Tuple2)rangeBounds.head())._1()).length;
            IndexedSeq sampleBounds = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), candidateColNumber - 1).map((Function1)new Serializable(zOrderBounds, sample, rangeBounds){
                public static final long serialVersionUID = 0L;
                private final int zOrderBounds$1;
                private final RangeSample sample$1;
                private final ArrayBuffer rangeBounds$1;

                public final Object apply(int i) {
                    ArrayBuffer colRangeBound = (ArrayBuffer)this.rangeBounds$1.map((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final int i$1;

                        public final Tuple2<Object, Object> apply(Tuple2<Object[], Object> x) {
                            return new Tuple2(((Object[])x._1())[this.i$1], x._2());
                        }
                        {
                            this.i$1 = i$1;
                        }
                    }, ArrayBuffer$.MODULE$.canBuildFrom());
                    return ((Tuple2)colRangeBound.head())._1() instanceof String ? this.sample$1.determineBound(colRangeBound, scala.math.package$.MODULE$.min(this.zOrderBounds$1, this.rangeBounds$1.length()), package$.MODULE$.Ordering().apply((Ordering)Ordering.String$.MODULE$), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : this.sample$1.determineBound(colRangeBound, scala.math.package$.MODULE$.min(this.zOrderBounds$1, this.rangeBounds$1.length()), package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$), Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long());
                }
                {
                    this.zOrderBounds$1 = zOrderBounds$1;
                    this.sample$1 = sample$1;
                    this.rangeBounds$1 = rangeBounds$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            int maxLength = BoxesRunTime.unboxToInt((Object)((TraversableOnce)sampleBounds.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Object x$13) {
                    return ScalaRunTime$.MODULE$.array_length(x$13);
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
            IndexedSeq expandSampleBoundsWithFactor = (IndexedSeq)sampleBounds.map((Function1)new Serializable(maxLength){
                public static final long serialVersionUID = 0L;
                private final int maxLength$1;

                public final Tuple2<Object, Object> apply(Object bound) {
                    Tuple2 tuple2;
                    int fillFactor = this.maxLength$1 / Predef$.MODULE$.genericArrayOps(bound).size();
                    double[] newBound = new double[ScalaRunTime$.MODULE$.array_length(bound) * fillFactor];
                    if (bound instanceof long[] && fillFactor > 1) {
                        long[] longBound = (long[])bound;
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), ScalaRunTime$.MODULE$.array_length(bound) - 1).foreach$mVc$sp((Function1)new Serializable(this, fillFactor, newBound, longBound){
                            public static final long serialVersionUID = 0L;
                            public final int fillFactor$1;
                            public final double[] newBound$1;
                            public final long[] longBound$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.fillFactor$1 - 1).foreach$mVc$sp((Function1)new Serializable(this, i){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$32$$anonfun$apply$1 $outer;
                                    private final int i$2;

                                    public final void apply(int j) {
                                        this.apply$mcVI$sp(j);
                                    }

                                    public void apply$mcVI$sp(int j) {
                                        this.$outer.newBound$1[j + this.i$2 * this.$outer.fillFactor$1] = (double)this.$outer.longBound$1[this.i$2] + (double)(j + 1) * (1.0 / (double)this.$outer.fillFactor$1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.i$2 = i$2;
                                    }
                                });
                            }
                            {
                                this.fillFactor$1 = fillFactor$1;
                                this.newBound$1 = newBound$1;
                                this.longBound$1 = longBound$1;
                            }
                        });
                        tuple2 = new Tuple2((Object)newBound, (Object)BoxesRunTime.boxToInteger((int)fillFactor));
                    } else {
                        tuple2 = new Tuple2(bound, (Object)BoxesRunTime.boxToInteger((int)0));
                    }
                    return tuple2;
                }
                {
                    this.maxLength$1 = maxLength$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Broadcast boundBroadCast = spark.sparkContext().broadcast((Object)expandSampleBoundsWithFactor, ClassTag$.MODULE$.apply(IndexedSeq.class));
            RDD qual$1 = rawRdd.mapPartitions((Function1)new Serializable(layoutOptStrategy, zFields, boundBroadCast){
                public static final long serialVersionUID = 0L;
                public final HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy$1;
                public final Seq zFields$1;
                private final Broadcast boundBroadCast$1;

                public final Iterator<Row> apply(Iterator<Row> iter) {
                    IndexedSeq expandBoundsWithFactor = (IndexedSeq)this.boundBroadCast$1.value();
                    int maxBoundNum = BoxesRunTime.unboxToInt((Object)((TraversableOnce)expandBoundsWithFactor.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<Object, Object> x$14) {
                            return ScalaRunTime$.MODULE$.array_length(x$14._1());
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
                    RawDecisionBound<K> longDecisionBound = new RawDecisionBound<K>(package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$), Ordering.Long$.MODULE$, ClassTag$.MODULE$.Long());
                    RawDecisionBound<K> doubleDecisionBound = new RawDecisionBound<K>(package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$), Ordering.Double$.MODULE$, ClassTag$.MODULE$.Double());
                    RawDecisionBound<K> stringDecisionBound = new RawDecisionBound<K>(package$.MODULE$.Ordering().apply((Ordering)Ordering.String$.MODULE$), Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class));
                    ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                    HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy = this.layoutOptStrategy$1;
                    HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy2 = HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT;
                    None$ hilbertCurve = !(layoutOptimizationStrategy != null ? !((Object)((Object)layoutOptimizationStrategy)).equals((Object)((Object)layoutOptimizationStrategy2)) : layoutOptimizationStrategy2 != null) ? new Some((Object)HilbertCurve.bits(32).dimensions(this.zFields$1.length())) : None$.MODULE$;
                    return iter.map((Function1)new Serializable(this, expandBoundsWithFactor, maxBoundNum, longDecisionBound, doubleDecisionBound, stringDecisionBound, threadLocalRandom, (Option)hilbertCurve){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.33 $outer;
                        public final IndexedSeq expandBoundsWithFactor$1;
                        public final int maxBoundNum$1;
                        public final RawDecisionBound longDecisionBound$1;
                        public final RawDecisionBound doubleDecisionBound$1;
                        public final RawDecisionBound stringDecisionBound$1;
                        public final ThreadLocalRandom threadLocalRandom$1;
                        private final Option hilbertCurve$1;

                        public final Row apply(Row row) {
                            HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptimizationStrategy;
                            block4: {
                                byte[] byArray;
                                block3: {
                                    Seq values2;
                                    block2: {
                                        values2 = (Seq)((TraversableLike)((TraversableLike)this.$outer.zFields$1.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, row){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$33$$anonfun$apply$4 $outer;
                                            private final Row row$2;

                                            public final int apply(Tuple2<Tuple2<Object, StructField>, Object> x0$4) {
                                                Tuple2<Tuple2<Object, StructField>, Object> tuple2 = x0$4;
                                                if (tuple2 != null) {
                                                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                                                    int rawIndex = tuple2._2$mcI$sp();
                                                    if (tuple22 != null) {
                                                        int n;
                                                        int index = tuple22._1$mcI$sp();
                                                        StructField field = (StructField)tuple22._2();
                                                        DataType dataType = field.dataType();
                                                        if (LongType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : this.row$2.getLong(index), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (DoubleType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : Double.doubleToLongBits(this.row$2.getDouble(index)), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (IntegerType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : (long)this.row$2.getInt(index), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (FloatType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : Double.doubleToLongBits(this.row$2.getFloat(index)), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (StringType$.MODULE$.equals(dataType)) {
                                                            int n2;
                                                            double factor = (double)this.$outer.maxBoundNum$1 / (double)ScalaRunTime$.MODULE$.array_length(((Tuple2)this.$outer.expandBoundsWithFactor$1.apply(rawIndex))._1());
                                                            if (this.row$2.isNullAt(index)) {
                                                                n2 = this.$outer.maxBoundNum$1 + 1;
                                                            } else {
                                                                int currentRank = this.$outer.stringDecisionBound$1.getBound(this.row$2.getString(index), (String[])((Tuple2)this.$outer.expandBoundsWithFactor$1.apply(rawIndex))._1());
                                                                n2 = factor > 1.0 ? (int)((double)currentRank * factor) + this.$outer.threadLocalRandom$1.nextInt((int)factor) : currentRank;
                                                            }
                                                            n = n2;
                                                        } else if (DateType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : this.row$2.getDate(index).getTime(), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (TimestampType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : this.row$2.getTimestamp(index).getTime(), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (ByteType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : (long)this.row$2.getByte(index), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (ShortType$.MODULE$.equals(dataType)) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : (long)this.row$2.getShort(index), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else if (dataType instanceof DecimalType) {
                                                            boolean isNull = this.row$2.isNullAt(index);
                                                            n = this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(rawIndex, isNull ? 0L : this.row$2.getDecimal(index).longValue(), isNull, this.$outer.expandBoundsWithFactor$1, this.$outer.longDecisionBound$1, this.$outer.doubleDecisionBound$1, this.$outer.threadLocalRandom$1);
                                                        } else {
                                                            n = -1;
                                                        }
                                                        int n3 = n;
                                                        return n3;
                                                    }
                                                }
                                                throw new MatchError(tuple2);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.row$2 = row$2;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(int v) {
                                                return this.apply$mcZI$sp(v);
                                            }

                                            public boolean apply$mcZI$sp(int v) {
                                                return v != -1;
                                            }
                                        });
                                        layoutOptimizationStrategy = this.$outer.layoutOptStrategy$1;
                                        if (!((Object)((Object)HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT)).equals((Object)((Object)layoutOptimizationStrategy))) break block2;
                                        byArray = HilbertCurveUtils.indexBytes((HilbertCurve)this.hilbertCurve$1.get(), (long[])((TraversableOnce)values2.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final long apply(int x$16) {
                                                return this.apply$mcJI$sp(x$16);
                                            }

                                            public long apply$mcJI$sp(int x$16) {
                                                return x$16;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long()), 32);
                                        break block3;
                                    }
                                    if (!((Object)((Object)HoodieClusteringConfig.LayoutOptimizationStrategy.ZORDER)).equals((Object)((Object)layoutOptimizationStrategy))) break block4;
                                    byArray = BinaryUtil.interleaving((byte[][])((TraversableOnce)values2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final byte[] apply(int x$17) {
                                            return BinaryUtil.intTo8Byte(x$17);
                                        }
                                    }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), 8);
                                }
                                byte[] mapValues = byArray;
                                return Row$.MODULE$.fromSeq((Seq)row.toSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new byte[][]{mapValues})), Seq$.MODULE$.canBuildFrom()));
                            }
                            throw new MatchError((Object)((Object)layoutOptimizationStrategy));
                        }

                        public /* synthetic */ anonfun.33 org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.expandBoundsWithFactor$1 = expandBoundsWithFactor$1;
                            this.maxBoundNum$1 = maxBoundNum$1;
                            this.longDecisionBound$1 = longDecisionBound$1;
                            this.doubleDecisionBound$1 = doubleDecisionBound$1;
                            this.stringDecisionBound$1 = stringDecisionBound$1;
                            this.threadLocalRandom$1 = threadLocalRandom$1;
                            this.hilbertCurve$1 = hilbertCurve$1;
                        }
                    });
                }

                public final int org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$getRank$1(int rawIndex, long value, boolean isNull, IndexedSeq expandBoundsWithFactor$1, RawDecisionBound longDecisionBound$1, RawDecisionBound doubleDecisionBound$1, ThreadLocalRandom threadLocalRandom$1) {
                    Tuple2 tuple2 = (Tuple2)expandBoundsWithFactor$1.apply(rawIndex);
                    if (tuple2 != null) {
                        Tuple2 tuple22;
                        Object expandBound = tuple2._1();
                        int factor = tuple2._2$mcI$sp();
                        Tuple2 tuple23 = tuple22 = new Tuple2(expandBound, (Object)BoxesRunTime.boxToInteger((int)factor));
                        Object expandBound2 = tuple23._1();
                        int factor2 = tuple23._2$mcI$sp();
                        return isNull ? ScalaRunTime$.MODULE$.array_length(expandBound2) + 1 : (factor2 > 1 ? doubleDecisionBound$1.getBound(BoxesRunTime.boxToDouble((double)((double)value + (double)(threadLocalRandom$1.nextInt(factor2) + 1) * (1.0 / (double)factor2))), (double[])expandBound2) : longDecisionBound$1.getBound(BoxesRunTime.boxToLong((long)value), (long[])expandBound2));
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.layoutOptStrategy$1 = layoutOptStrategy$1;
                    this.zFields$1 = zFields$1;
                    this.boundBroadCast$1 = boundBroadCast$1;
                }
            }, rawRdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class));
            Serializable x$25 = new Serializable(fieldNum){
                public static final long serialVersionUID = 0L;
                private final int fieldNum$1;

                public final ByteArraySorting apply(Row x) {
                    return new ByteArraySorting((byte[])x.getAs(this.fieldNum$1));
                }
                {
                    this.fieldNum$1 = fieldNum$1;
                }
            };
            int x$26 = targetPartitionsCount;
            boolean x$27 = qual$1.sortBy$default$2();
            RDD indexRdd = qual$1.sortBy((Function1)x$25, x$27, x$26, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(ByteArraySorting.class));
            Dataset newDF = df.sparkSession().createDataFrame(indexRdd, new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])df.schema().fields()).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"index"})).s((Seq)Nil$.MODULE$), (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))));
            dataset = newDF.drop("index");
        }
        return dataset;
    }

    public Dataset<Row> sortDataFrameBySampleSupportAllTypes(Dataset<Row> df, Seq<String> zCols, int fileNum) {
        Dataset dataset;
        SparkSession spark = df.sparkSession();
        RDD internalRdd = df.queryExecution().toRdd();
        StructType schema2 = df.schema();
        Seq outputAttributes = df.queryExecution().analyzed().output();
        Seq sortingExpressions = (Seq)outputAttributes.filter((Function1)new Serializable(zCols){
            public static final long serialVersionUID = 0L;
            private final Seq zCols$1;

            public final boolean apply(Attribute p) {
                return this.zCols$1.contains((Object)p.name());
            }
            {
                this.zCols$1 = zCols$1;
            }
        });
        if (sortingExpressions.length() == 0 || sortingExpressions.length() != zCols.size()) {
            dataset = df;
        } else {
            int zOrderBounds = new StringOps(Predef$.MODULE$.augmentString(df.sparkSession().sessionState().conf().getConfString(HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.key(), HoodieClusteringConfig.LAYOUT_OPTIMIZE_BUILD_CURVE_SAMPLE_SIZE.defaultValue().toString()))).toInt();
            RDD sampleRdd = internalRdd.mapPartitionsInternal((Function1)new Serializable(outputAttributes, sortingExpressions){
                public static final long serialVersionUID = 0L;
                private final Seq outputAttributes$1;
                private final Seq sortingExpressions$1;

                public final Iterator<MutablePair<InternalRow, Null$>> apply(Iterator<InternalRow> iter) {
                    UnsafeProjection projection = UnsafeProjection$.MODULE$.create(this.sortingExpressions$1, this.outputAttributes$1);
                    MutablePair mutablePair = new MutablePair();
                    return iter.map((Function1)new Serializable(this, projection, mutablePair){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeProjection projection$1;
                        private final MutablePair mutablePair$1;

                        public final MutablePair<InternalRow, Null$> apply(InternalRow row) {
                            return this.mutablePair$1.update((Object)this.projection$1.apply(row).copy(), null);
                        }
                        {
                            this.projection$1 = projection$1;
                            this.mutablePair$1 = mutablePair$1;
                        }
                    });
                }
                {
                    this.outputAttributes$1 = outputAttributes$1;
                    this.sortingExpressions$1 = sortingExpressions$1;
                }
            }, internalRdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Seq orderings = (Seq)((TraversableLike)((IterableLike)sortingExpressions.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SortOrder apply(Attribute x$18) {
                    return SortOrder$.MODULE$.apply((Expression)x$18, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                }
            }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SortOrder apply(Tuple2<SortOrder, Object> x0$5) {
                    Tuple2<SortOrder, Object> tuple2 = x0$5;
                    if (tuple2 != null) {
                        SortOrder ord = (SortOrder)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        SortOrder sortOrder = ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                        return sortOrder;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq lazyGeneratedOrderings = (Seq)orderings.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LazilyGeneratedOrdering apply(SortOrder ord) {
                    return new LazilyGeneratedOrdering((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{ord})));
                }
            }, Seq$.MODULE$.canBuildFrom());
            RangeSample sample = new RangeSample(zOrderBounds, sampleRdd, RangeSample$.MODULE$.$lessinit$greater$default$3(), RangeSample$.MODULE$.$lessinit$greater$default$4(), ClassTag$.MODULE$.apply(InternalRow.class));
            ArrayBuffer rangeBounds = sample.getRangeBounds();
            LazilyGeneratedOrdering ordering1 = (LazilyGeneratedOrdering)lazyGeneratedOrderings.apply(0);
            UnsafeRow[][] sampleBounds = sample.determineRowBounds(rangeBounds, scala.math.package$.MODULE$.min(zOrderBounds, rangeBounds.length()), lazyGeneratedOrderings, (Seq<Attribute>)sortingExpressions, ordering1, ClassTag$.MODULE$.apply(InternalRow.class));
            Seq origin_orderings = (Seq)((TraversableLike)sortingExpressions.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SortOrder apply(Attribute x$19) {
                    return SortOrder$.MODULE$.apply((Expression)x$19, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
                }
            }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final SortOrder apply(SortOrder ord) {
                    return ord.copy((Expression)new BoundReference(0, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq origin_lazyGeneratedOrderings = (Seq)origin_orderings.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LazilyGeneratedOrdering apply(SortOrder ord) {
                    return new LazilyGeneratedOrdering((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortOrder[]{ord})));
                }
            }, Seq$.MODULE$.canBuildFrom());
            int maxLength = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])sampleBounds).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(UnsafeRow[] x$20) {
                    return x$20.length;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
            Tuple2[] expandSampleBoundsWithFactor = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])sampleBounds).map((Function1)new Serializable(maxLength){
                public static final long serialVersionUID = 0L;
                private final int maxLength$2;

                public final Tuple2<UnsafeRow[], Object> apply(UnsafeRow[] bound) {
                    double fillFactor = (double)this.maxLength$2 / (double)Predef$.MODULE$.refArrayOps((Object[])bound).size();
                    return new Tuple2((Object)bound, (Object)BoxesRunTime.boxToDouble((double)fillFactor));
                }
                {
                    this.maxLength$2 = maxLength$2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Broadcast boundBroadCast = spark.sparkContext().broadcast((Object)expandSampleBoundsWithFactor, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            RDD qual$2 = internalRdd.mapPartitionsInternal((Function1)new Serializable(outputAttributes, sortingExpressions, ordering1, origin_lazyGeneratedOrderings, boundBroadCast){
                public static final long serialVersionUID = 0L;
                public final Seq outputAttributes$1;
                private final Seq sortingExpressions$1;
                public final LazilyGeneratedOrdering ordering1$1;
                public final Seq origin_lazyGeneratedOrderings$1;
                private final Broadcast boundBroadCast$2;

                public final Iterator<MutablePair<InternalRow, byte[]>> apply(Iterator<InternalRow> iter) {
                    Tuple2[] boundsWithFactor = (Tuple2[])this.boundBroadCast$2.value();
                    ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                    int maxBoundNum = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])boundsWithFactor).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<UnsafeRow[], Object> x$21) {
                            return ((UnsafeRow[])x$21._1()).length;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).max((Ordering)Ordering.Int$.MODULE$));
                    Seq origin_Projections = (Seq)this.sortingExpressions$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.48 $outer;

                        public final UnsafeProjection apply(Attribute se) {
                            return UnsafeProjection$.MODULE$.create((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{se})), this.$outer.outputAttributes$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    return iter.map((Function1)new Serializable(this, boundsWithFactor, threadLocalRandom, maxBoundNum, origin_Projections){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.48 $outer;
                        public final Tuple2[] boundsWithFactor$1;
                        public final ThreadLocalRandom threadLocalRandom$2;
                        public final int maxBoundNum$2;
                        private final Seq origin_Projections$1;

                        public final MutablePair<InternalRow, byte[]> apply(InternalRow unsafeRow) {
                            byte[][] interleaveValues = (byte[][])Predef$.MODULE$.intArrayOps((int[])((TraversableOnce)((TraversableLike)((IterableLike)this.origin_Projections$1.zip((GenIterable)this.$outer.origin_lazyGeneratedOrderings$1, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, unsafeRow){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$48$$anonfun$apply$6 $outer;
                                private final InternalRow unsafeRow$1;

                                public final int apply(Tuple2<Tuple2<UnsafeProjection, LazilyGeneratedOrdering>, Object> x0$6) {
                                    Tuple2<Tuple2<UnsafeProjection, LazilyGeneratedOrdering>, Object> tuple2;
                                    block5: {
                                        Tuple2 tuple22;
                                        block8: {
                                            int n;
                                            block7: {
                                                Tuple2 tuple23;
                                                RawDecisionBound<K> decisionBound;
                                                UnsafeRow row;
                                                int index;
                                                block6: {
                                                    tuple2 = x0$6;
                                                    if (tuple2 == null) break block5;
                                                    Tuple2 tuple24 = (Tuple2)tuple2._1();
                                                    index = tuple2._2$mcI$sp();
                                                    if (tuple24 == null) break block5;
                                                    UnsafeProjection rowProject = (UnsafeProjection)tuple24._1();
                                                    LazilyGeneratedOrdering lazyOrdering = (LazilyGeneratedOrdering)tuple24._2();
                                                    row = rowProject.apply(this.unsafeRow$1);
                                                    decisionBound = new RawDecisionBound<K>(lazyOrdering, this.$outer.org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer().ordering1$1, ClassTag$.MODULE$.apply(InternalRow.class));
                                                    if (!row.isNullAt(0)) break block6;
                                                    n = this.$outer.maxBoundNum$2 + 1;
                                                    break block7;
                                                }
                                                tuple22 = this.$outer.boundsWithFactor$1[index];
                                                if (tuple22 == null) break block8;
                                                UnsafeRow[] bound = (UnsafeRow[])tuple22._1();
                                                double factor = tuple22._2$mcD$sp();
                                                Tuple2 tuple25 = tuple23 = new Tuple2((Object)bound, (Object)BoxesRunTime.boxToDouble((double)factor));
                                                UnsafeRow[] bound2 = (UnsafeRow[])tuple25._1();
                                                double factor2 = tuple25._2$mcD$sp();
                                                if (factor2 > 1.0) {
                                                    int currentRank = decisionBound.getBound(row, (InternalRow[])bound2);
                                                    n = currentRank * (int)factor2 + this.$outer.threadLocalRandom$2.nextInt((int)factor2);
                                                } else {
                                                    n = decisionBound.getBound(row, (InternalRow[])bound2);
                                                }
                                            }
                                            int n2 = n;
                                            return n2;
                                        }
                                        throw new MatchError((Object)tuple22);
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.unsafeRow$1 = unsafeRow$1;
                                }
                            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final byte[] apply(int x$23) {
                                    return BinaryUtil.intTo8Byte(x$23);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
                            byte[] zValues = BinaryUtil.interleaving(interleaveValues, 8);
                            MutablePair mutablePair = new MutablePair();
                            return mutablePair.update((Object)unsafeRow, (Object)zValues);
                        }

                        public /* synthetic */ anonfun.48 org$apache$spark$sql$hudi$execution$RangeSampleSort$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.boundsWithFactor$1 = boundsWithFactor$1;
                            this.threadLocalRandom$2 = threadLocalRandom$2;
                            this.maxBoundNum$2 = maxBoundNum$2;
                            this.origin_Projections$1 = origin_Projections$1;
                        }
                    });
                }
                {
                    this.outputAttributes$1 = outputAttributes$1;
                    this.sortingExpressions$1 = sortingExpressions$1;
                    this.ordering1$1 = ordering1$1;
                    this.origin_lazyGeneratedOrderings$1 = origin_lazyGeneratedOrderings$1;
                    this.boundBroadCast$2 = boundBroadCast$2;
                }
            }, internalRdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Serializable x$28 = new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ByteArraySorting apply(MutablePair<InternalRow, byte[]> x) {
                    return new ByteArraySorting((byte[])x._2());
                }
            };
            int x$29 = fileNum;
            boolean x$30 = qual$2.sortBy$default$2();
            RDD indexRdd = qual$2.sortBy((Function1)x$28, x$30, x$29, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()), ClassTag$.MODULE$.apply(ByteArraySorting.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final InternalRow apply(MutablePair<InternalRow, byte[]> x$24) {
                    return (InternalRow)x$24._1();
                }
            }, ClassTag$.MODULE$.apply(InternalRow.class));
            dataset = spark.internalCreateDataFrame(indexRdd, schema2, spark.internalCreateDataFrame$default$3());
        }
        return dataset;
    }

    private RangeSampleSort$() {
        MODULE$ = this;
    }
}

