/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.staticfiles;

import io.javalin.staticfiles.Location;
import io.javalin.staticfiles.ResourceHandler;
import io.javalin.staticfiles.StaticFileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u001e\u0010\u0019\u001a\u00020\b*\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u000e\u0010\u001d\u001a\u00020\b*\u0004\u0018\u00010\u001aH\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/javalin/staticfiles/JettyResourceHandler;", "Lio/javalin/staticfiles/ResourceHandler;", "staticFileConfig", "", "Lio/javalin/staticfiles/StaticFileConfig;", "jettyServer", "Lorg/eclipse/jetty/server/Server;", "ignoreTrailingSlashes", "", "(Ljava/util/Set;Lorg/eclipse/jetty/server/Server;Z)V", "handlers", "", "Lorg/eclipse/jetty/server/handler/gzip/GzipHandler;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getResourcePath", "", "handle", "httpRequest", "Ljavax/servlet/http/HttpServletRequest;", "httpResponse", "Ljavax/servlet/http/HttpServletResponse;", "welcomeFilePath", "target", "isDirectoryWithWelcomeFile", "Lorg/eclipse/jetty/util/resource/Resource;", "handler", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "isFile", "WebjarHandler", "javalin"})
public final class JettyResourceHandler
implements ResourceHandler {
    private final Logger log;
    private final List<GzipHandler> handlers;
    private final boolean ignoreTrailingSlashes;

    @NotNull
    public final String getResourcePath(@NotNull StaticFileConfig staticFileConfig) {
        Intrinsics.checkParameterIsNotNull(staticFileConfig, "staticFileConfig");
        String nosuchdir = "Static resource directory with path: '" + staticFileConfig.getPath() + "' does not exist.";
        if (staticFileConfig.getLocation() == Location.CLASSPATH) {
            Resource classPathResource = Resource.newClassPathResource(staticFileConfig.getPath());
            if (classPathResource == null) {
                throw (Throwable)new RuntimeException(nosuchdir + " Depending on your setup, empty folders might not get copied to classpath.");
            }
            return classPathResource.toString();
        }
        if (!new File(staticFileConfig.getPath()).exists()) {
            throw (Throwable)new RuntimeException(nosuchdir);
        }
        return staticFileConfig.getPath();
    }

    @Override
    public boolean handle(@NotNull HttpServletRequest httpRequest, @NotNull HttpServletResponse httpResponse) {
        Intrinsics.checkParameterIsNotNull(httpRequest, "httpRequest");
        Intrinsics.checkParameterIsNotNull(httpResponse, "httpResponse");
        Object object = httpRequest.getAttribute("jetty-target");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String target = (String)object;
        Object object2 = httpRequest.getAttribute("jetty-request");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.Request");
        }
        Request baseRequest = (Request)object2;
        for (GzipHandler gzipHandler : this.handlers) {
            try {
                Handler handler = gzipHandler.getHandler();
                if (handler == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jetty.server.handler.ResourceHandler");
                }
                org.eclipse.jetty.server.handler.ResourceHandler resourceHandler = (org.eclipse.jetty.server.handler.ResourceHandler)handler;
                Resource resource = resourceHandler.getResource(target);
                if (!this.isFile(resource) && !this.isDirectoryWithWelcomeFile(resource, resourceHandler, target)) continue;
                int maxAge = StringsKt.startsWith$default(target, "/immutable/", false, 2, null) || resourceHandler instanceof WebjarHandler ? 31622400 : 0;
                httpResponse.setHeader("Cache-Control", "max-age=" + maxAge);
                gzipHandler.handle(target, baseRequest, httpRequest, httpResponse);
                httpRequest.setAttribute("handled-as-static-file", (Object)true);
                return true;
            }
            catch (Exception e) {
                this.log.error("Exception occurred while handling static resource", (Throwable)e);
            }
        }
        return false;
    }

    private final boolean isFile(@Nullable Resource $receiver) {
        return $receiver != null && $receiver.exists() && !$receiver.isDirectory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDirectoryWithWelcomeFile(@Nullable Resource $receiver, org.eclipse.jetty.server.handler.ResourceHandler handler, String target) {
        if ($receiver == null) return false;
        if (!$receiver.isDirectory()) return false;
        Resource resource = handler.getResource(this.welcomeFilePath(target));
        if (resource == null) return false;
        if (!resource.exists()) return false;
        return true;
    }

    private final String welcomeFilePath(String target) {
        return !StringsKt.endsWith$default(target, "/", false, 2, null) && this.ignoreTrailingSlashes ? target + "/index.html" : target + "index.html";
    }

    /*
     * WARNING - void declaration
     */
    public JettyResourceHandler(@NotNull Set<StaticFileConfig> staticFileConfig, @NotNull Server jettyServer, boolean ignoreTrailingSlashes) {
        Iterable<GzipHandler> iterable;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(staticFileConfig, "staticFileConfig");
        Intrinsics.checkParameterIsNotNull(jettyServer, "jettyServer");
        this.ignoreTrailingSlashes = ignoreTrailingSlashes;
        this.log = LoggerFactory.getLogger((String)"io.javalin.Javalin");
        Iterable iterable2 = staticFileConfig;
        JettyResourceHandler jettyResourceHandler = this;
        Iterable iterable3 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Handler handler;
            void config;
            GzipHandler gzipHandler;
            StaticFileConfig staticFileConfig2 = (StaticFileConfig)item$iv$iv;
            iterable = destination$iv$iv;
            GzipHandler $receiver = gzipHandler = new GzipHandler();
            $receiver.setServer(jettyServer);
            GzipHandler gzipHandler2 = $receiver;
            if (Intrinsics.areEqual(config.getPath(), "/webjars")) {
                handler = new WebjarHandler();
            } else {
                org.eclipse.jetty.server.handler.ResourceHandler resourceHandler = new org.eclipse.jetty.server.handler.ResourceHandler();
                GzipHandler gzipHandler3 = gzipHandler2;
                org.eclipse.jetty.server.handler.ResourceHandler $receiver2 = resourceHandler;
                $receiver2.setResourceBase(this.getResourcePath((StaticFileConfig)config));
                $receiver2.setDirAllowed(false);
                $receiver2.setEtags(true);
                this.log.info("Static file handler added with path=" + config.getPath() + " and location=" + (Object)((Object)config.getLocation()) + ". Absolute path: '" + this.getResourcePath((StaticFileConfig)config) + "'.");
                org.eclipse.jetty.server.handler.ResourceHandler resourceHandler2 = resourceHandler;
                gzipHandler2 = gzipHandler3;
                handler = resourceHandler2;
            }
            gzipHandler2.setHandler(handler);
            GzipHandler gzipHandler4 = gzipHandler;
            iterable.add(gzipHandler4);
        }
        iterable = (List)destination$iv$iv;
        Iterable $receiver$iv2 = iterable3 = ($receiver$iv = (Iterable)iterable);
        for (Object element$iv : $receiver$iv2) {
            GzipHandler it = (GzipHandler)element$iv;
            it.start();
        }
        jettyResourceHandler.handlers = iterable = iterable3;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lio/javalin/staticfiles/JettyResourceHandler$WebjarHandler;", "Lorg/eclipse/jetty/server/handler/ResourceHandler;", "(Lio/javalin/staticfiles/JettyResourceHandler;)V", "getResource", "Lorg/eclipse/jetty/util/resource/Resource;", "kotlin.jvm.PlatformType", "path", "", "javalin"})
    public final class WebjarHandler
    extends org.eclipse.jetty.server.handler.ResourceHandler {
        @Override
        public Resource getResource(@NotNull String path) {
            Intrinsics.checkParameterIsNotNull(path, "path");
            Resource resource = Resource.newClassPathResource("META-INF/resources" + path);
            if (resource == null) {
                resource = super.getResource(path);
            }
            return resource;
        }
    }
}

