/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.ClientUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public abstract class AbstractHoodieClient
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(AbstractHoodieClient.class);
    protected final transient FileSystem fs;
    protected final transient JavaSparkContext jsc;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    private transient Option<EmbeddedTimelineService> timelineServer;
    private final boolean shouldStopTimelineServer;

    protected AbstractHoodieClient(JavaSparkContext jsc, HoodieWriteConfig clientConfig) {
        this(jsc, clientConfig, Option.empty());
    }

    protected AbstractHoodieClient(JavaSparkContext jsc, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineServer) {
        this.fs = FSUtils.getFs(clientConfig.getBasePath(), jsc.hadoopConfiguration());
        this.jsc = jsc;
        this.basePath = clientConfig.getBasePath();
        this.config = clientConfig;
        this.timelineServer = timelineServer;
        this.shouldStopTimelineServer = !timelineServer.isPresent();
        this.startEmbeddedServerView();
    }

    @Override
    public void close() {
        this.stopEmbeddedServerView(true);
    }

    private synchronized void stopEmbeddedServerView(boolean resetViewStorageConfig) {
        if (this.timelineServer.isPresent() && this.shouldStopTimelineServer) {
            LOG.info((Object)"Stopping Timeline service !!");
            this.timelineServer.get().stop();
        }
        this.timelineServer = Option.empty();
        if (resetViewStorageConfig) {
            this.config.resetViewStorageConfig();
        }
    }

    private synchronized void startEmbeddedServerView() {
        if (this.config.isEmbeddedTimelineServerEnabled()) {
            if (!this.timelineServer.isPresent()) {
                LOG.info((Object)"Starting Timeline service !!");
                this.timelineServer = Option.of(new EmbeddedTimelineService(this.jsc.hadoopConfiguration(), this.jsc.getConf(), this.config.getClientSpecifiedViewStorageConfig()));
                try {
                    this.timelineServer.get().startServer();
                    this.config.setViewStorageConfig(this.timelineServer.get().getRemoteFileSystemViewConfig());
                }
                catch (IOException e) {
                    LOG.warn((Object)"Unable to start timeline service. Proceeding as if embedded server is disabled", (Throwable)e);
                    this.stopEmbeddedServerView(false);
                }
            } else {
                LOG.info((Object)"Timeline Server already running. Not restarting the service");
            }
        } else {
            LOG.info((Object)"Embedded Timeline Server is disabled. Not starting timeline service");
        }
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public Option<EmbeddedTimelineService> getTimelineServer() {
        return this.timelineServer;
    }

    protected HoodieTableMetaClient createMetaClient(boolean loadActiveTimelineOnLoad) {
        return ClientUtils.createMetaClient(this.jsc, this.config, loadActiveTimelineOnLoad);
    }
}

