/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionHelper$;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;

public final class AvroConversionUtils$ {
    public static final AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace) {
        Schema avroSchema = this.convertStructTypeToAvroSchema(df.schema(), structName, recordNamespace);
        return this.createRdd(df, avroSchema, structName, recordNamespace);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, Schema avroSchema, String structName, String recordNamespace) {
        StructType dataType = (StructType)SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        String avroSchemaAsJsonString = avroSchema.toString();
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(dataType);
        Seq x$1 = qual$1.resolveAndBind$default$1();
        Analyzer x$2 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$1, x$2);
        RDD qual$2 = df.queryExecution().toRdd().map((Function1)new Serializable(encoder){
            public static final long serialVersionUID = 0L;
            private final ExpressionEncoder encoder$1;

            public final Row apply(InternalRow row) {
                return (Row)this.encoder$1.fromRow(row);
            }
            {
                this.encoder$1 = encoder$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        Serializable x$3 = new Serializable(structName, recordNamespace, dataType, avroSchemaAsJsonString){
            public static final long serialVersionUID = 0L;
            private final String structName$1;
            private final String recordNamespace$1;
            private final StructType dataType$1;
            private final String avroSchemaAsJsonString$1;

            public final Iterator<GenericRecord> apply(Iterator<Row> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    Schema avroSchema = new Schema.Parser().parse(this.avroSchemaAsJsonString$1);
                    Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToAvro(avroSchema, (DataType)this.dataType$1, this.structName$1, this.recordNamespace$1);
                    iterator2 = records.map((Function1)new Serializable(this, convertor){
                        public static final long serialVersionUID = 0L;
                        private final Function1 convertor$1;

                        public final GenericRecord apply(Row x) {
                            return (GenericRecord)this.convertor$1.apply((Object)x);
                        }
                        {
                            this.convertor$1 = convertor$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.structName$1 = structName$1;
                this.recordNamespace$1 = recordNamespace$1;
                this.dataType$1 = dataType$1;
                this.avroSchemaAsJsonString$1 = avroSchemaAsJsonString$1;
            }
        };
        boolean x$4 = qual$2.mapPartitions$default$2();
        return qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(GenericRecord.class));
    }

    public RDD<HoodieKey> createRddForDeletes(Dataset<Row> df, String rowField, String partitionField) {
        return df.rdd().map((Function1)new Serializable(rowField, partitionField){
            public static final long serialVersionUID = 0L;
            private final String rowField$1;
            private final String partitionField$1;

            public final HoodieKey apply(Row row) {
                return new HoodieKey((String)row.getAs(this.rowField$1), (String)row.getAs(this.partitionField$1));
            }
            {
                this.rowField$1 = rowField$1;
                this.partitionField$1 = partitionField$1;
            }
        }, ClassTag$.MODULE$.apply(HoodieKey.class));
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1)new Serializable(schemaStr){
            public static final long serialVersionUID = 0L;
            private final String schemaStr$1;

            public final Iterator<Row> apply(Iterator<GenericRecord> records) {
                Iterator iterator2;
                if (records.isEmpty()) {
                    iterator2 = package$.MODULE$.Iterator().empty();
                } else {
                    Schema schema = new Schema.Parser().parse(this.schemaStr$1);
                    StructType dataType = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schema);
                    Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToRow(schema, (DataType)dataType);
                    iterator2 = records.map((Function1)new Serializable(this, convertor){
                        public static final long serialVersionUID = 0L;
                        private final Function1 convertor$2;

                        public final Row apply(GenericRecord x) {
                            return (Row)this.convertor$2.apply((Object)x);
                        }
                        {
                            this.convertor$2 = convertor$2;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.schemaStr$1 = schemaStr$1;
            }
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public String getNewRecordNamespace(DataType elementDataType, String currentRecordNamespace, String elementName) {
        DataType dataType = elementDataType;
        String string = dataType instanceof StructType ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{currentRecordNamespace, elementName})) : currentRecordNamespace;
        return string;
    }

    public Schema convertStructTypeToAvroSchema(StructType structType, String structName, String recordNamespace) {
        return SchemaConverters$.MODULE$.toAvroType((DataType)structType, false, structName, recordNamespace);
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        return (StructType)SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

