/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieReadClient;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.SlashEncodedDayPartitionValueExtractor;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class DataSourceUtils {
    public static String getNestedFieldValAsString(GenericRecord record, String fieldName, boolean returnNullIfNotFound) {
        Object obj = DataSourceUtils.getNestedFieldVal(record, fieldName, returnNullIfNotFound);
        return obj == null ? null : obj.toString();
    }

    public static Object getNestedFieldVal(GenericRecord record, String fieldName, boolean returnNullIfNotFound) {
        String part;
        Object val;
        int i;
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (i = 0; i < parts.length && (val = valueNode.get(part = parts[i])) != null; ++i) {
            if (i == parts.length - 1) {
                return val;
            }
            if (!(val instanceof GenericRecord)) {
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        throw new HoodieException(fieldName + "(Part -" + parts[i] + ") field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
    }

    public static KeyGenerator createKeyGenerator(TypedProperties props) throws IOException {
        String keyGeneratorClass = props.getString(DataSourceWriteOptions.KEYGENERATOR_CLASS_OPT_KEY(), DataSourceWriteOptions.DEFAULT_KEYGENERATOR_CLASS_OPT_VAL());
        try {
            return (KeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, props);
        }
        catch (Throwable e) {
            throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
        }
    }

    public static HoodieRecordPayload createPayload(String payloadClass, GenericRecord record, Comparable orderingVal) throws IOException {
        try {
            return (HoodieRecordPayload)ReflectionUtils.loadClass(payloadClass, new Class[]{GenericRecord.class, Comparable.class}, new Object[]{record, orderingVal});
        }
        catch (Throwable e) {
            throw new IOException("Could not create payload for class: " + payloadClass, e);
        }
    }

    public static void checkRequiredProperties(TypedProperties props, List<String> checkPropNames) {
        checkPropNames.stream().forEach(prop -> {
            if (!props.containsKey(prop)) {
                throw new HoodieNotSupportedException("Required property " + prop + " is missing");
            }
        });
    }

    public static HoodieWriteClient createHoodieClient(JavaSparkContext jssc, String schemaStr, String basePath, String tblName, Map<String, String> parameters) {
        boolean inlineCompact = parameters.get(DataSourceWriteOptions.TABLE_TYPE_OPT_KEY()).equals(DataSourceWriteOptions.MOR_TABLE_TYPE_OPT_VAL());
        boolean combineInserts = Boolean.parseBoolean(parameters.get(DataSourceWriteOptions.INSERT_DROP_DUPS_OPT_KEY()));
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(basePath).withAutoCommit(false).combineInput(combineInserts, true).withSchema(schemaStr).forTable(tblName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withPayloadClass(parameters.get(DataSourceWriteOptions.PAYLOAD_CLASS_OPT_KEY())).withInlineCompaction(inlineCompact).build()).withProps(parameters).build();
        return new HoodieWriteClient(jssc, writeConfig, true);
    }

    public static JavaRDD<WriteStatus> doWriteOperation(HoodieWriteClient client, JavaRDD<HoodieRecord> hoodieRecords, String commitTime, String operation) {
        if (operation.equals(DataSourceWriteOptions.BULK_INSERT_OPERATION_OPT_VAL())) {
            return client.bulkInsert(hoodieRecords, commitTime);
        }
        if (operation.equals(DataSourceWriteOptions.INSERT_OPERATION_OPT_VAL())) {
            return client.insert(hoodieRecords, commitTime);
        }
        return client.upsert(hoodieRecords, commitTime);
    }

    public static JavaRDD<WriteStatus> doDeleteOperation(HoodieWriteClient client, JavaRDD<HoodieKey> hoodieKeys, String commitTime) {
        return client.delete(hoodieKeys, commitTime);
    }

    public static HoodieRecord createHoodieRecord(GenericRecord gr, Comparable orderingVal, HoodieKey hKey, String payloadClass) throws IOException {
        HoodieRecordPayload payload = DataSourceUtils.createPayload(payloadClass, gr, orderingVal);
        return new HoodieRecord<HoodieRecordPayload>(hKey, payload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, HoodieWriteConfig writeConfig, Option<EmbeddedTimelineService> timelineService) {
        HoodieReadClient client = null;
        try {
            client = new HoodieReadClient(jssc, writeConfig, timelineService);
            JavaRDD javaRDD = client.tagLocation(incomingHoodieRecords).filter((Function & Serializable)r -> !((HoodieRecord)r).isCurrentLocationKnown());
            return javaRDD;
        }
        catch (TableNotFoundException e) {
            JavaRDD<HoodieRecord> javaRDD = incomingHoodieRecords;
            return javaRDD;
        }
        finally {
            if (null != client) {
                client.close();
            }
        }
    }

    public static JavaRDD<HoodieRecord> dropDuplicates(JavaSparkContext jssc, JavaRDD<HoodieRecord> incomingHoodieRecords, Map<String, String> parameters, Option<EmbeddedTimelineService> timelineService) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(parameters.get("path")).withProps(parameters).build();
        return DataSourceUtils.dropDuplicates(jssc, incomingHoodieRecords, writeConfig, timelineService);
    }

    public static HiveSyncConfig buildHiveSyncConfig(TypedProperties props, String basePath) {
        DataSourceUtils.checkRequiredProperties(props, Arrays.asList(DataSourceWriteOptions.HIVE_TABLE_OPT_KEY()));
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.basePath = basePath;
        hiveSyncConfig.usePreApacheInputFormat = props.getBoolean(DataSourceWriteOptions.HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY(), Boolean.valueOf(DataSourceWriteOptions.DEFAULT_USE_PRE_APACHE_INPUT_FORMAT_OPT_VAL()));
        hiveSyncConfig.databaseName = props.getString(DataSourceWriteOptions.HIVE_DATABASE_OPT_KEY(), DataSourceWriteOptions.DEFAULT_HIVE_DATABASE_OPT_VAL());
        hiveSyncConfig.tableName = props.getString(DataSourceWriteOptions.HIVE_TABLE_OPT_KEY());
        hiveSyncConfig.hiveUser = props.getString(DataSourceWriteOptions.HIVE_USER_OPT_KEY(), DataSourceWriteOptions.DEFAULT_HIVE_USER_OPT_VAL());
        hiveSyncConfig.hivePass = props.getString(DataSourceWriteOptions.HIVE_PASS_OPT_KEY(), DataSourceWriteOptions.DEFAULT_HIVE_PASS_OPT_VAL());
        hiveSyncConfig.jdbcUrl = props.getString(DataSourceWriteOptions.HIVE_URL_OPT_KEY(), DataSourceWriteOptions.DEFAULT_HIVE_URL_OPT_VAL());
        hiveSyncConfig.partitionFields = props.getStringList(DataSourceWriteOptions.HIVE_PARTITION_FIELDS_OPT_KEY(), ",", new ArrayList<String>());
        hiveSyncConfig.partitionValueExtractorClass = props.getString(DataSourceWriteOptions.HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY(), SlashEncodedDayPartitionValueExtractor.class.getName());
        return hiveSyncConfig;
    }
}

