/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hudi.AbstractHoodieClient;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.AvroUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieCleanClient<T extends HoodieRecordPayload>
extends AbstractHoodieClient {
    private static final Logger LOG = LogManager.getLogger(HoodieCleanClient.class);
    private final transient HoodieMetrics metrics;

    public HoodieCleanClient(JavaSparkContext jsc, HoodieWriteConfig clientConfig, HoodieMetrics metrics) {
        this(jsc, clientConfig, metrics, Option.empty());
    }

    public HoodieCleanClient(JavaSparkContext jsc, HoodieWriteConfig clientConfig, HoodieMetrics metrics, Option<EmbeddedTimelineService> timelineService) {
        super(jsc, clientConfig, timelineService);
        this.metrics = metrics;
    }

    public void clean() throws HoodieIOException {
        String startCleanTime = HoodieActiveTimeline.createNewInstantTime();
        this.clean(startCleanTime);
    }

    protected HoodieCleanMetadata clean(String startCleanTime) throws HoodieIOException {
        HoodieCleanerPlan cleanerPlan;
        HoodieTable table = HoodieTable.getHoodieTable(this.createMetaClient(true), this.config, this.jsc);
        table.getCleanTimeline().filterInflightsAndRequested().getInstants().forEach(hoodieInstant -> {
            LOG.info((Object)("There were previously unfinished cleaner operations. Finishing Instant=" + hoodieInstant));
            this.runClean(table, (HoodieInstant)hoodieInstant);
        });
        Option<HoodieCleanerPlan> cleanerPlanOpt = this.scheduleClean(startCleanTime);
        if (cleanerPlanOpt.isPresent() && (cleanerPlan = cleanerPlanOpt.get()).getFilesToBeDeletedPerPartition() != null && !cleanerPlan.getFilesToBeDeletedPerPartition().isEmpty()) {
            HoodieTable hoodieTable = HoodieTable.getHoodieTable(this.createMetaClient(true), this.config, this.jsc);
            return this.runClean(hoodieTable, HoodieTimeline.getCleanRequestedInstant(startCleanTime), cleanerPlan);
        }
        return null;
    }

    @VisibleForTesting
    protected Option<HoodieCleanerPlan> scheduleClean(String startCleanTime) {
        HoodieTable table = HoodieTable.getHoodieTable(this.createMetaClient(true), this.config, this.jsc);
        HoodieCleanerPlan cleanerPlan = table.scheduleClean(this.jsc);
        if (cleanerPlan.getFilesToBeDeletedPerPartition() != null && !cleanerPlan.getFilesToBeDeletedPerPartition().isEmpty()) {
            HoodieInstant cleanInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", startCleanTime);
            try {
                table.getActiveTimeline().saveToCleanRequested(cleanInstant, AvroUtils.serializeCleanerPlan(cleanerPlan));
                LOG.info((Object)("Requesting Cleaning with instant time " + cleanInstant));
            }
            catch (IOException e) {
                LOG.error((Object)"Got exception when saving cleaner requested file", (Throwable)e);
                throw new HoodieIOException(e.getMessage(), e);
            }
            return Option.of(cleanerPlan);
        }
        return Option.empty();
    }

    @VisibleForTesting
    protected HoodieCleanMetadata runClean(HoodieTable<T> table, HoodieInstant cleanInstant) {
        try {
            HoodieCleanerPlan cleanerPlan = CleanerUtils.getCleanerPlan(table.getMetaClient(), cleanInstant);
            return this.runClean(table, cleanInstant, cleanerPlan);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private HoodieCleanMetadata runClean(HoodieTable<T> table, HoodieInstant cleanInstant, HoodieCleanerPlan cleanerPlan) {
        Preconditions.checkArgument((cleanInstant.getState().equals((Object)HoodieInstant.State.REQUESTED) || cleanInstant.getState().equals((Object)HoodieInstant.State.INFLIGHT) ? 1 : 0) != 0);
        try {
            List<HoodieCleanStat> cleanStats;
            LOG.info((Object)"Cleaner started");
            Timer.Context context = this.metrics.getCleanCtx();
            if (!cleanInstant.isInflight()) {
                cleanInstant = table.getActiveTimeline().transitionCleanRequestedToInflight(cleanInstant, AvroUtils.serializeCleanerPlan(cleanerPlan));
            }
            if ((cleanStats = table.clean(this.jsc, cleanInstant, cleanerPlan)).isEmpty()) {
                return HoodieCleanMetadata.newBuilder().build();
            }
            Option<Long> durationInMs = Option.empty();
            if (context != null) {
                durationInMs = Option.of(this.metrics.getDurationInMs(context.stop()));
                LOG.info((Object)("cleanerElaspsedTime (Minutes): " + durationInMs.get() / 60000L));
            }
            HoodieTableMetaClient metaClient = this.createMetaClient(true);
            HoodieCleanMetadata metadata = CleanerUtils.convertCleanMetadata(metaClient, cleanInstant.getTimestamp(), durationInMs, cleanStats);
            LOG.info((Object)("Cleaned " + metadata.getTotalFilesDeleted() + " files. Earliest Retained :" + metadata.getEarliestCommitToRetain()));
            this.metrics.updateCleanMetrics(durationInMs.orElseGet(() -> -1L), metadata.getTotalFilesDeleted());
            table.getActiveTimeline().transitionCleanInflightToComplete(new HoodieInstant(true, "clean", cleanInstant.getTimestamp()), AvroUtils.serializeCleanMetadata(metadata));
            LOG.info((Object)("Marked clean started on " + cleanInstant.getTimestamp() + " as complete"));
            return metadata;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to clean up after commit", e);
        }
    }
}

