/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;

public class HoodieDataSourceHelpers {
    public static boolean hasNewCommits(FileSystem fs, String basePath, String commitTimestamp) {
        return HoodieDataSourceHelpers.listCommitsSince(fs, basePath, commitTimestamp).size() > 0;
    }

    public static List<String> listCommitsSince(FileSystem fs, String basePath, String instantTimestamp) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return timeline.findInstantsAfter(instantTimestamp, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    public static String latestCommit(FileSystem fs, String basePath) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return timeline.lastInstant().get().getTimestamp();
    }

    public static HoodieTimeline allCompletedCommitsCompactions(FileSystem fs, String basePath) {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(fs.getConf(), basePath, true);
        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            return metaClient.getActiveTimeline().getTimelineOfActions(Sets.newHashSet((Object[])new String[]{"commit", "deltacommit"}));
        }
        return metaClient.getCommitTimeline().filterCompletedInstants();
    }
}

