/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieWriteClient;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.TypedProperties;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HoodieSparkSqlWriter$ {
    public static final HoodieSparkSqlWriter$ MODULE$;
    private final Logger org$apache$hudi$HoodieSparkSqlWriter$$log;

    static {
        new HoodieSparkSqlWriter$();
    }

    public Logger org$apache$hudi$HoodieSparkSqlWriter$$log() {
        return this.org$apache$hudi$HoodieSparkSqlWriter$$log;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Tuple2<Object, Option<String>> write(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> df) {
        block13: {
            sparkContext = sqlContext.sparkContext();
            path = parameters.get((Object)"path");
            tblName = parameters.get((Object)"hoodie.table.name");
            if (path.isEmpty() || tblName.isEmpty()) {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "', 'path' must be set."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hoodie.table.name"})));
            }
            var8_8 = sparkContext.getConf().getOption("spark.serializer");
            if (!(var8_8 instanceof Some) || !(ser = (String)(var9_9 = (Some)var8_8).x()).equals("org.apache.spark.serializer.KryoSerializer")) break block13;
            var11_11 = BoxedUnit.UNIT;
            tableType = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY());
            if (!new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()))).toBoolean()) ** GOTO lbl-1000
            v0 = parameters.apply((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY());
            var14_13 = DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL();
            if (!(v0 != null ? v0.equals(var14_13) == false : var14_13 != null)) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not applicable "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.UPSERT_OPERATION_OPT_VAL()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"when ", " is set to be true, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"overriding the ", " to be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()}))).toString());
                v1 = DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL();
            } else lbl-1000:
            // 2 sources

            {
                v1 = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY());
            }
            operation = v1;
            jsc = new JavaSparkContext(sparkContext);
            basePath = new Path((String)parameters.apply((Object)"path"));
            commitTime = HoodieActiveTimeline.createNewInstantTime();
            fs = basePath.getFileSystem(sparkContext.hadoopConfiguration());
            exists = fs.exists(new Path(basePath, HoodieTableMetaClient.METAFOLDER_NAME));
            if (!operation.equalsIgnoreCase(DataSourceWriteOptions$.MODULE$.DELETE_OPERATION_OPT_VAL())) ** GOTO lbl43
            v2 = mode;
            var34_20 = SaveMode.Append;
            if (v2 != null ? v2.equals(var34_20) == false : var34_20 != null) ** GOTO lbl42
            structName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName.get()}));
            nameSpace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName.get()}));
            sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
            keyGenerator = DataSourceUtils.createKeyGenerator(this.toProperties(parameters));
            genericRecords = AvroConversionUtils$.MODULE$.createRdd(df, structName, nameSpace);
            hoodieKeysToDelete = genericRecords.map((Function1)new Serializable(keyGenerator){
                public static final long serialVersionUID = 0L;
                private final KeyGenerator keyGenerator$2;

                public final HoodieKey apply(GenericRecord gr) {
                    return this.keyGenerator$2.getKey(gr);
                }
                {
                    this.keyGenerator$2 = keyGenerator$2;
                }
            }, ClassTag$.MODULE$.apply(HoodieKey.class)).toJavaRDD();
            if (exists) {
                client = DataSourceUtils.createHoodieClient(jsc, Schema.create((Schema.Type)Schema.Type.NULL).toString(), (String)path.get(), (String)tblName.get(), JavaConversions$.MODULE$.mapAsJavaMap(parameters));
                client.startCommitWithTime(commitTime);
                writeStatuses = DataSourceUtils.doDeleteOperation(client, (JavaRDD<HoodieKey>)hoodieKeysToDelete, commitTime);
                v3 = new Tuple2(writeStatuses, (Object)client);
            } else {
                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
lbl42:
                // 1 sources

                throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Append is the only save mode applicable for ", " operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})));
lbl43:
                // 1 sources

                structName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_record"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName.get()}));
                nameSpace = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tblName.get()}));
                sparkContext.getConf().registerKryoClasses((Class[])((Object[])new Class[]{GenericData.class, Schema.class}));
                schema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(df.schema(), structName, nameSpace);
                sparkContext.getConf().registerAvroSchemas((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema[]{schema}));
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered avro schema : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema.toString(true)})));
                keyGenerator = DataSourceUtils.createKeyGenerator(this.toProperties(parameters));
                genericRecords = AvroConversionUtils$.MODULE$.createRdd(df, structName, nameSpace);
                hoodieAllIncomingRecords = genericRecords.map((Function1)new Serializable(parameters, keyGenerator){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.immutable.Map parameters$1;
                    private final KeyGenerator keyGenerator$1;

                    public final HoodieRecord<? extends HoodieRecordPayload<? extends HoodieRecordPayload<?>>> apply(GenericRecord gr) {
                        String orderingVal = DataSourceUtils.getNestedFieldValAsString(gr, (String)this.parameters$1.apply((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), false);
                        return DataSourceUtils.createHoodieRecord(gr, (Comparable)((Object)orderingVal), this.keyGenerator$1.getKey(gr), (String)this.parameters$1.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()));
                    }
                    {
                        this.parameters$1 = parameters$1;
                        this.keyGenerator$1 = keyGenerator$1;
                    }
                }, ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD();
                v4 = mode;
                var28_34 = SaveMode.ErrorIfExists;
                if (!(v4 != null ? v4.equals(var28_34) == false : var28_34 != null) && exists) {
                    throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                }
                v5 = mode;
                var29_35 = SaveMode.Ignore;
                if (!(v5 != null ? v5.equals(var29_35) == false : var29_35 != null) && exists) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Ignoring & not performing actual writes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                    v6 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), Option.<T>empty());
                } else {
                    v6 = BoxedUnit.UNIT;
                }
                v7 = mode;
                var30_36 = SaveMode.Overwrite;
                if (!(v7 != null ? v7.equals(var30_36) == false : var30_36 != null) && exists) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().warn((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hoodie table at ", " already exists. Deleting existing data & overwriting with new data."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{basePath})));
                    fs.delete(basePath, true);
                    exists = false;
                }
                v8 /* !! */  = exists != false ? BoxedUnit.UNIT : HoodieTableMetaClient.initTableType(sparkContext.hadoopConfiguration(), (String)path.get(), tableType, (String)tblName.get(), "archived", (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()));
                client = DataSourceUtils.createHoodieClient(jsc, schema.toString(), (String)path.get(), (String)tblName.get(), JavaConversions$.MODULE$.mapAsJavaMap(parameters));
                v9 = hoodieRecords = new StringOps(Predef$.MODULE$.augmentString((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()))).toBoolean() != false ? DataSourceUtils.dropDuplicates(jsc, hoodieAllIncomingRecords, JavaConversions$.MODULE$.mapAsJavaMap(parameters), client.getTimelineServer()) : hoodieAllIncomingRecords;
                if (hoodieRecords.isEmpty()) {
                    this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"new batch has no new records, skipping...");
                    v10 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), Option.<T>empty());
                } else {
                    v10 = BoxedUnit.UNIT;
                }
                client.startCommitWithTime(commitTime);
                writeStatuses = DataSourceUtils.doWriteOperation(client, hoodieRecords, commitTime, operation);
                v3 = var21_40 = new Tuple2(writeStatuses, (Object)client);
            }
            if (var21_40 != null) {
                writeStatuses = (JavaRDD)var21_40._1();
                writeClient = (HoodieWriteClient)var21_40._2();
                if (writeClient instanceof HoodieWriteClient) {
                    var44_43 = writeClient;
                    var20_45 = var45_44 = new Tuple2((Object)writeStatuses, (Object)var44_43);
                    writeStatuses = (JavaRDD)var20_45._1();
                    writeClient = (HoodieWriteClient)var20_45._2();
                    writeSuccessful = this.checkWriteStatus((JavaRDD<WriteStatus>)writeStatuses, parameters, writeClient, commitTime, basePath, operation, jsc);
                    return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)writeSuccessful), Option.ofNullable(commitTime));
                }
            }
            throw new MatchError((Object)var21_40);
        }
        throw new HoodieException("hoodie only support org.apache.spark.serializer.KryoSerializer as spark.serializer");
    }

    public scala.collection.immutable.Map<String, String> parametersWithWriteDefaults(scala.collection.immutable.Map<String, String> parameters) {
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_TABLE_TYPE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_PRECOMBINE_FIELD_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_PAYLOAD_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_RECORDKEY_FIELD_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_PARTITIONPATH_FIELD_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_KEYGENERATOR_CLASS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_COMMIT_METADATA_KEYPREFIX_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_INSERT_DROP_DUPS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_STREAMING_RETRY_CNT_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_STREAMING_RETRY_INTERVAL_MS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_STREAMING_IGNORE_FAILED_BATCH_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_SYNC_ENABLED_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_DATABASE_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_DATABASE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_TABLE_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_USER_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_USER_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_PASS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_PASS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_URL_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_URL_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_FIELDS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_PARTITION_FIELDS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_PARTITION_EXTRACTOR_CLASS_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING_OPT_KEY()), (Object)DataSourceWriteOptions$.MODULE$.DEFAULT_HIVE_STYLE_PARTITIONING_OPT_VAL())}))).$plus$plus(DataSourceWriteOptions$.MODULE$.translateStorageTypeToTableType(parameters));
    }

    /*
     * WARNING - void declaration
     */
    public TypedProperties toProperties(scala.collection.immutable.Map<String, String> params) {
        void var2_2;
        TypedProperties props = new TypedProperties();
        params.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final TypedProperties props$1;

            public final Object apply(Tuple2<String, String> kv) {
                return this.props$1.setProperty((String)kv._1(), (String)kv._2());
            }
            {
                this.props$1 = props$1;
            }
        });
        return var2_2;
    }

    private boolean syncHive(Path basePath, FileSystem fs, scala.collection.immutable.Map<String, String> parameters) {
        HiveSyncConfig hiveSyncConfig = this.buildSyncConfig(basePath, parameters);
        HiveConf hiveConf = new HiveConf();
        hiveConf.addResource(fs.getConf());
        new HiveSyncTool(hiveSyncConfig, hiveConf, fs).syncHoodieTable();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private HiveSyncConfig buildSyncConfig(Path basePath, scala.collection.immutable.Map<String, String> parameters) {
        void var3_3;
        HiveSyncConfig hiveSyncConfig = new HiveSyncConfig();
        hiveSyncConfig.basePath = basePath.toString();
        hiveSyncConfig.usePreApacheInputFormat = Predef$.MODULE$.boolean2Boolean(parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_USE_PRE_APACHE_INPUT_FORMAT_OPT_KEY()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String r) {
                return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
            }
        }));
        hiveSyncConfig.databaseName = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_DATABASE_OPT_KEY());
        hiveSyncConfig.tableName = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_OPT_KEY());
        hiveSyncConfig.hiveUser = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_USER_OPT_KEY());
        hiveSyncConfig.hivePass = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PASS_OPT_KEY());
        hiveSyncConfig.jdbcUrl = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_URL_OPT_KEY());
        hiveSyncConfig.partitionFields = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_FIELDS_OPT_KEY())).split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$3) {
                return !x$3.isEmpty();
            }
        })).toList()));
        hiveSyncConfig.partitionValueExtractorClass = (String)parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_PARTITION_EXTRACTOR_CLASS_OPT_KEY());
        return var3_3;
    }

    private boolean checkWriteStatus(JavaRDD<WriteStatus> writeStatuses, scala.collection.immutable.Map<String, String> parameters, HoodieWriteClient<?> client, String commitTime, Path basePath, String operation, JavaSparkContext jsc) {
        boolean bl;
        long errorCount = writeStatuses.rdd().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(WriteStatus ws) {
                return ws.hasErrors();
            }
        }).count();
        if (errorCount == 0L) {
            boolean bl2;
            boolean commitSuccess;
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)"No errors. Proceeding to commit the write.");
            scala.collection.immutable.Map metaMap = (scala.collection.immutable.Map)parameters.filter((Function1)new Serializable(parameters){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map parameters$2;

                public final boolean apply(Tuple2<String, String> kv) {
                    return ((String)kv._1()).startsWith((String)this.parameters$2.apply((Object)DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX_OPT_KEY()));
                }
                {
                    this.parameters$2 = parameters$2;
                }
            });
            boolean bl3 = commitSuccess = metaMap.isEmpty() ? client.commit(commitTime, writeStatuses) : client.commit(commitTime, writeStatuses, Option.of(new HashMap(JavaConversions$.MODULE$.mapAsJavaMap((Map)metaMap))));
            if (commitSuccess) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)commitTime).append((Object)" successful!").toString());
            } else {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Commit ").append((Object)commitTime).append((Object)" failed!").toString());
            }
            boolean hiveSyncEnabled = parameters.get((Object)DataSourceWriteOptions$.MODULE$.HIVE_SYNC_ENABLED_OPT_KEY()).exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String r) {
                    return new StringOps(Predef$.MODULE$.augmentString(r)).toBoolean();
                }
            });
            if (hiveSyncEnabled) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().info((Object)new StringBuilder().append((Object)"Syncing to Hive Metastore (URL: ").append(parameters.apply((Object)DataSourceWriteOptions$.MODULE$.HIVE_URL_OPT_KEY())).append((Object)")").toString());
                FileSystem fs = FSUtils.getFs(basePath.toString(), jsc.hadoopConfiguration());
                bl2 = this.syncHive(basePath, fs, parameters);
            } else {
                bl2 = true;
            }
            boolean syncHiveSucess = bl2;
            client.close();
            bl = commitSuccess && syncHiveSucess;
        } else {
            this.org$apache$hudi$HoodieSparkSqlWriter$$log().error((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed with ", " errors :"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation, BoxesRunTime.boxToLong((long)errorCount)})));
            if (this.org$apache$hudi$HoodieSparkSqlWriter$$log().isTraceEnabled()) {
                this.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Printing out the top 100 errors");
                Predef$.MODULE$.refArrayOps((Object[])writeStatuses.rdd().filter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(WriteStatus ws) {
                        return ws.hasErrors();
                    }
                }).take(100)).foreach((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final void apply(WriteStatus ws) {
                        HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)"Global error :", ws.getGlobalError());
                        if (ws.getErrors().size() > 0) {
                            JavaConversions$.MODULE$.mapAsScalaMap(ws.getErrors()).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<HoodieKey, Throwable> kt) {
                                    HoodieSparkSqlWriter$.MODULE$.org$apache$hudi$HoodieSparkSqlWriter$$log().trace((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error for key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{kt._1()})), (Throwable)kt._2());
                                }
                            });
                        }
                    }
                });
            }
            bl = false;
        }
        return bl;
    }

    private HoodieSparkSqlWriter$() {
        MODULE$ = this;
        this.org$apache$hudi$HoodieSparkSqlWriter$$log = LogManager.getLogger(this.getClass());
    }
}

