/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u0001%\u00111#\u00138de\u0016lWM\u001c;bYJ+G.\u0019;j_:T!a\u0001\u0003\u0002\t!,H-\u001b\u0006\u0003\u000b\u0019\ta!\u00199bG\",'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001QA\u0003\u0005\u0002\f%5\tAB\u0003\u0002\u000e\u001d\u000591o\\;sG\u0016\u001c(BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#\u0011\tQa\u001d9be.L!a\u0005\u0007\u0003\u0019\t\u000b7/\u001a*fY\u0006$\u0018n\u001c8\u0011\u0005-)\u0012B\u0001\f\r\u0005%!\u0016M\u00197f'\u000e\fg\u000e\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010^\u000b\u00025A\u00111\u0004H\u0007\u0002\u001d%\u0011QD\u0004\u0002\u000b'Fc5i\u001c8uKb$\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0017M\fHnQ8oi\u0016DH\u000f\t\u0005\tC\u0001\u0011)\u0019!C\u0001E\u0005A!-Y:f!\u0006$\b.F\u0001$!\t!#F\u0004\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIc%\u0001\u0004Qe\u0016$WMZ\u0005\u0003W1\u0012aa\u0015;sS:<'BA\u0015'\u0011!q\u0003A!A!\u0002\u0013\u0019\u0013!\u00032bg\u0016\u0004\u0016\r\u001e5!\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0014!C8qiB\u000b'/Y7t+\u0005\u0011\u0004\u0003\u0002\u00134G\rJ!\u0001\u000e\u0017\u0003\u00075\u000b\u0007\u000f\u0003\u00057\u0001\t\u0005\t\u0015!\u00033\u0003)y\u0007\u000f\u001e)be\u0006l7\u000f\t\u0005\tq\u0001\u0011)\u0019!C\u0001s\u0005QQo]3s'\u000eDW-\\1\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!\u0010\b\u0002\u000bQL\b/Z:\n\u0005}b$AC*ueV\u001cG\u000fV=qK\"A\u0011\t\u0001B\u0001B\u0003%!(A\u0006vg\u0016\u00148k\u00195f[\u0006\u0004\u0003\"B\"\u0001\t\u0003!\u0015A\u0002\u001fj]&$h\bF\u0003F\u000f\"K%\n\u0005\u0002G\u00015\t!\u0001C\u0003\u0019\u0005\u0002\u0007!\u0004C\u0003\"\u0005\u0002\u00071\u0005C\u00031\u0005\u0002\u0007!\u0007C\u00039\u0005\u0002\u0007!\bC\u0004M\u0001\t\u0007I\u0011B'\u0002\u00071|w-F\u0001O!\ty%+D\u0001Q\u0015\t\tF!A\u0003m_\u001e$$.\u0003\u0002T!\n1Aj\\4hKJDa!\u0016\u0001!\u0002\u0013q\u0015\u0001\u00027pO\u0002Bqa\u0016\u0001C\u0002\u0013\u0005\u0001,\u0001\u0002ggV\t\u0011\f\u0005\u0002[=6\t1L\u0003\u0002X9*\u0011Q\fB\u0001\u0007Q\u0006$wn\u001c9\n\u0005}[&A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"1\u0011\r\u0001Q\u0001\ne\u000b1AZ:!\u0011\u001d\u0019\u0007A1A\u0005\u0002\u0011\f!\"\\3uC\u000ec\u0017.\u001a8u+\u0005)\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0015!\u0018M\u00197f\u0015\tQ'!\u0001\u0004d_6lwN\\\u0005\u0003Y\u001e\u0014Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG\u000f\u0003\u0004o\u0001\u0001\u0006I!Z\u0001\f[\u0016$\u0018m\u00117jK:$\b\u0005C\u0004q\u0001\t\u0007I\u0011B9\u0002\u0017!|w\u000eZ5f)\u0006\u0014G.Z\u000b\u0002eB\u00191/^<\u000e\u0003QT!\u0001\u001b\u0002\n\u0005Y$(a\u0003%p_\u0012LW\rV1cY\u0016\u0004\"!\n=\n\u0005e4#a\u0002(pi\"Lgn\u001a\u0005\u0007w\u0002\u0001\u000b\u0011\u0002:\u0002\u0019!|w\u000eZ5f)\u0006\u0014G.\u001a\u0011\t\u000fu\u0004!\u0019!C\u0001}\u0006q1m\\7nSR$\u0016.\\3mS:,W#A@\u0011\u0007\u0019\f\t!C\u0002\u0002\u0004\u001d\u0014a\u0002S8pI&,G+[7fY&tW\rC\u0004\u0002\b\u0001\u0001\u000b\u0011B@\u0002\u001f\r|W.\\5u)&lW\r\\5oK\u0002B\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\u0002\u00171\f7\u000f^%ogR\fg\u000e^\u000b\u0003\u0003\u001f\u0001B!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+9\u0017\u0001\u0003;j[\u0016d\u0017N\\3\n\t\u0005e\u00111\u0003\u0002\u000e\u0011>|G-[3J]N$\u0018M\u001c;\t\u0011\u0005u\u0001\u0001)A\u0005\u0003\u001f\tA\u0002\\1ti&s7\u000f^1oi\u0002B\u0011\"!\t\u0001\u0005\u0004%\t!a\t\u0002\u001f\r|W.\\5ugR{'+\u001a;ve:,\"!!\n\u0011\r\u0005\u001d\u0012QFA\b\u001d\r)\u0013\u0011F\u0005\u0004\u0003W1\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003_\t\tD\u0001\u0003MSN$(bAA\u0016M!A\u0011Q\u0007\u0001!\u0002\u0013\t)#\u0001\td_6l\u0017\u000e^:U_J+G/\u001e:oA!A\u0011\u0011\b\u0001C\u0002\u0013\u0005\u0011(\u0001\u0007mCR,7\u000f^*dQ\u0016l\u0017\rC\u0004\u0002>\u0001\u0001\u000b\u0011\u0002\u001e\u0002\u001b1\fG/Z:u'\u000eDW-\\1!\u0011%\t\t\u0005\u0001b\u0001\n\u0003\t\u0019%A\u0004gS2$XM]:\u0016\u0005\u0005\u0015\u0003#B\u0013\u0002H\u0005-\u0013bAA%M\t)\u0011I\u001d:bsB!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0004W\u0005=\u0003\u0002CA.\u0001\u0001\u0006I!!\u0012\u0002\u0011\u0019LG\u000e^3sg\u0002Ba!a\u0018\u0001\t\u0003J\u0014AB:dQ\u0016l\u0017\rC\u0004\u0002d\u0001!\t%!\u001a\u0002\u0013\t,\u0018\u000e\u001c3TG\u0006tGCAA4!\u0019\tI'a\u001c\u0002t5\u0011\u00111\u000e\u0006\u0004\u0003[\u0002\u0012a\u0001:eI&!\u0011\u0011OA6\u0005\r\u0011F\t\u0012\t\u00047\u0005U\u0014bAA<\u001d\t\u0019!k\\<")
public class IncrementalRelation
extends BaseRelation
implements TableScan {
    private final SQLContext sqlContext;
    private final String basePath;
    private final scala.collection.immutable.Map<String, String> optParams;
    private final StructType userSchema;
    private final Logger log;
    private final FileSystem fs;
    private final HoodieTableMetaClient metaClient;
    private final HoodieTable<Nothing$> hoodieTable;
    private final HoodieTimeline commitTimeline;
    private final HoodieInstant lastInstant;
    private final List<HoodieInstant> commitsToReturn;
    private final StructType latestSchema;
    private final String[] filters;

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public String basePath() {
        return this.basePath;
    }

    public scala.collection.immutable.Map<String, String> optParams() {
        return this.optParams;
    }

    public StructType userSchema() {
        return this.userSchema;
    }

    private Logger log() {
        return this.log;
    }

    public FileSystem fs() {
        return this.fs;
    }

    public HoodieTableMetaClient metaClient() {
        return this.metaClient;
    }

    private HoodieTable<Nothing$> hoodieTable() {
        return this.hoodieTable;
    }

    public HoodieTimeline commitTimeline() {
        return this.commitTimeline;
    }

    public HoodieInstant lastInstant() {
        return this.lastInstant;
    }

    public List<HoodieInstant> commitsToReturn() {
        return this.commitsToReturn;
    }

    public StructType latestSchema() {
        return this.latestSchema;
    }

    public String[] filters() {
        return this.filters;
    }

    public StructType schema() {
        return this.latestSchema();
    }

    public RDD<Row> buildScan() {
        RDD rDD;
        HashMap fileIdToFullPath = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.commitsToReturn().foreach((Function1)new Serializable(this, fileIdToFullPath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IncrementalRelation $outer;
            private final HashMap fileIdToFullPath$1;

            public final HashMap<String, String> apply(HoodieInstant commit) {
                HoodieCommitMetadata metadata = HoodieCommitMetadata.fromBytes(this.$outer.commitTimeline().getInstantDetails(commit).get(), HoodieCommitMetadata.class);
                return (HashMap)this.fileIdToFullPath$1.$plus$plus$eq((TraversableOnce)JavaConversions$.MODULE$.mapAsScalaMap(metadata.getFileIdAndFullPaths(this.$outer.basePath())).toMap(Predef$.MODULE$.$conforms()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileIdToFullPath$1 = fileIdToFullPath$1;
            }
        });
        this.sqlContext().sparkContext().hadoopConfiguration().unset("mapreduce.input.pathFilter.class");
        scala.collection.immutable.Map sOpts = (scala.collection.immutable.Map)this.optParams().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> p) {
                return !((String)p._1()).equalsIgnoreCase("path");
            }
        });
        if (fileIdToFullPath.isEmpty()) {
            rDD = this.sqlContext().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(Row.class));
        } else {
            this.log().info((Object)new StringBuilder().append((Object)"Additional Filters to be applied to incremental source are :").append((Object)this.filters()).toString());
            rDD = ((Dataset)Predef$.MODULE$.refArrayOps((Object[])this.filters()).foldLeft((Object)this.sqlContext().read().options((Map)sOpts).schema(this.latestSchema()).parquet((Seq)fileIdToFullPath.values().toList()).filter(String.format("%s >= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, ((HoodieInstant)this.commitsToReturn().head()).getTimestamp())).filter(String.format("%s <= '%s'", HoodieRecord.COMMIT_TIME_METADATA_FIELD, ((HoodieInstant)this.commitsToReturn().last()).getTimestamp())), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Dataset<Row> apply(Dataset<Row> e, String f) {
                    return e.filter(f);
                }
            })).toDF().rdd();
        }
        return rDD;
    }

    public IncrementalRelation(SQLContext sqlContext, String basePath, scala.collection.immutable.Map<String, String> optParams, StructType userSchema) {
        this.sqlContext = sqlContext;
        this.basePath = basePath;
        this.optParams = optParams;
        this.userSchema = userSchema;
        this.log = LogManager.getLogger(IncrementalRelation.class);
        this.fs = new Path(basePath).getFileSystem(sqlContext.sparkContext().hadoopConfiguration());
        this.metaClient = new HoodieTableMetaClient(sqlContext.sparkContext().hadoopConfiguration(), basePath, true);
        if (this.metaClient().getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            throw new HoodieException("Incremental view not implemented yet, for merge-on-read tables");
        }
        this.hoodieTable = HoodieTable.getHoodieTable(this.metaClient(), HoodieWriteConfig.newBuilder().withPath(basePath).build(), JavaSparkContext$.MODULE$.fromSparkContext(sqlContext.sparkContext()));
        this.commitTimeline = this.hoodieTable().getMetaClient().getCommitTimeline().filterCompletedInstants();
        if (this.commitTimeline().empty()) {
            throw new HoodieException("No instants to incrementally pull");
        }
        if (optParams.contains((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY())) {
            String[] stringArray;
            this.lastInstant = this.commitTimeline().lastInstant().get();
            this.commitsToReturn = JavaConversions$.MODULE$.asScalaIterator(this.commitTimeline().findInstantsInRange((String)optParams.apply((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY()), (String)optParams.getOrElse((Object)DataSourceReadOptions$.MODULE$.END_INSTANTTIME_OPT_KEY(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IncrementalRelation $outer;

                public final String apply() {
                    return this.$outer.lastInstant().getTimestamp();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).getInstants().iterator()).toList();
            HoodieInstant instant = (HoodieInstant)this.commitsToReturn().lastOption().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IncrementalRelation $outer;

                public final HoodieInstant apply() {
                    return this.$outer.lastInstant();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            HoodieCommitMetadata latestMeta = HoodieCommitMetadata.fromBytes(this.commitTimeline().getInstantDetails(instant).get(), HoodieCommitMetadata.class);
            String metaFilePath = latestMeta.getFileIdAndFullPaths(basePath).values().iterator().next();
            this.latestSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(ParquetUtils.readAvroSchema(sqlContext.sparkContext().hadoopConfiguration(), new Path(metaFilePath)));
            if (optParams.contains((Object)DataSourceReadOptions$.MODULE$.PUSH_DOWN_INCR_FILTERS_OPT_KEY())) {
                String filterStr = (String)optParams.get((Object)DataSourceReadOptions$.MODULE$.PUSH_DOWN_INCR_FILTERS_OPT_KEY()).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])filterStr.split(",")).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        return !x$1.isEmpty();
                    }
                });
            } else {
                stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
            }
            this.filters = stringArray;
            return;
        }
        throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specify the begin instant time to pull from using "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"option ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME_OPT_KEY()}))).toString());
    }
}

