/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.embedded;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.SerializableConfiguration;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.util.NetworkUtils;
import org.apache.hudi.timeline.service.TimelineService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;

public class EmbeddedTimelineService {
    private static final Logger LOG = LogManager.getLogger(EmbeddedTimelineService.class);
    private int serverPort;
    private String hostAddr;
    private final SerializableConfiguration hadoopConf;
    private final FileSystemViewStorageConfig config;
    private transient FileSystemViewManager viewManager;
    private transient TimelineService server;

    public EmbeddedTimelineService(Configuration hadoopConf, SparkConf sparkConf, FileSystemViewStorageConfig config) {
        this.setHostAddrFromSparkConf(sparkConf);
        if (this.hostAddr == null) {
            this.hostAddr = NetworkUtils.getHostname();
        }
        this.config = config;
        this.hadoopConf = new SerializableConfiguration(hadoopConf);
        this.viewManager = this.createViewManager();
    }

    private FileSystemViewManager createViewManager() {
        FileSystemViewStorageConfig.Builder builder = FileSystemViewStorageConfig.newBuilder().fromProperties(this.config.getProps());
        FileSystemViewStorageType storageType = builder.build().getStorageType();
        if (storageType.equals((Object)FileSystemViewStorageType.REMOTE_ONLY) || storageType.equals((Object)FileSystemViewStorageType.REMOTE_FIRST)) {
            builder.withStorageType(FileSystemViewStorageType.MEMORY);
        }
        return FileSystemViewManager.createViewManager(this.hadoopConf, builder.build());
    }

    public void startServer() throws IOException {
        this.server = new TimelineService(0, this.viewManager, this.hadoopConf.newCopy());
        this.serverPort = this.server.startService();
        LOG.info((Object)("Started embedded timeline server at " + this.hostAddr + ":" + this.serverPort));
    }

    private void setHostAddrFromSparkConf(SparkConf sparkConf) {
        String hostAddr = sparkConf.get("spark.driver.host", null);
        if (hostAddr != null) {
            LOG.info((Object)("Overriding hostIp to (" + hostAddr + ") found in spark-conf. It was " + this.hostAddr));
            this.hostAddr = hostAddr;
        } else {
            LOG.warn((Object)"Unable to find driver bind address from spark config");
        }
    }

    public FileSystemViewStorageConfig getRemoteFileSystemViewConfig() {
        return FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.REMOTE_FIRST).withRemoteServerHost(this.hostAddr).withRemoteServerPort(this.serverPort).build();
    }

    public FileSystemViewManager getViewManager() {
        return this.viewManager;
    }

    public void stop() {
        if (null != this.server) {
            LOG.info((Object)"Closing Timeline server");
            this.server.close();
            this.server = null;
            this.viewManager = null;
            LOG.info((Object)"Closed Timeline server");
        }
    }
}

