/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;

public abstract class BaseAvroPayload
implements Serializable {
    public final byte[] recordBytes;
    protected final Comparable orderingVal;

    public BaseAvroPayload(GenericRecord record, Comparable orderingVal) {
        try {
            this.recordBytes = record != null ? HoodieAvroUtils.avroToBytes(record) : new byte[]{};
        }
        catch (IOException io) {
            throw new HoodieIOException("Cannot convert GenericRecord to bytes", io);
        }
        this.orderingVal = orderingVal;
        if (orderingVal == null) {
            throw new HoodieException("Ordering value is null for record: " + record);
        }
    }
}

