/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.BaseAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.common.util.Option;

public class OverwriteWithLatestAvroPayload
extends BaseAvroPayload
implements HoodieRecordPayload<OverwriteWithLatestAvroPayload> {
    public OverwriteWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteWithLatestAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, record1 -> 0);
    }

    @Override
    public OverwriteWithLatestAvroPayload preCombine(OverwriteWithLatestAvroPayload another) {
        if (another.orderingVal.compareTo(this.orderingVal) > 0) {
            return another;
        }
        return this;
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> recordOption = this.getInsertValue(schema);
        if (!recordOption.isPresent()) {
            return Option.empty();
        }
        GenericRecord genericRecord = (GenericRecord)recordOption.get();
        Object deleteMarker = genericRecord.get("_hoodie_is_deleted");
        if (deleteMarker instanceof Boolean && ((Boolean)deleteMarker).booleanValue()) {
            return Option.empty();
        }
        return Option.of(genericRecord);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        return this.recordBytes.length == 0 ? Option.empty() : Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
    }
}

