/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.storage.SizeAwareDataInputStream;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlockVersion;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;

public class HoodieAvroDataBlock
extends HoodieLogBlock {
    private List<IndexedRecord> records;
    private Schema schema;
    private ThreadLocal<BinaryEncoder> encoderCache = new ThreadLocal();
    private ThreadLocal<BinaryDecoder> decoderCache = new ThreadLocal();

    public HoodieAvroDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(header, footer, Option.empty(), Option.empty(), null, false);
        this.records = records;
        this.schema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
    }

    public HoodieAvroDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header) {
        this(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>());
    }

    private HoodieAvroDataBlock(Option<byte[]> content, @Nonnull FSDataInputStream inputStream, boolean readBlockLazily, Option<HoodieLogBlock.HoodieLogBlockContentLocation> blockContentLocation, Schema readerSchema, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> headers, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        super(headers, footer, blockContentLocation, content, inputStream, readBlockLazily);
        this.schema = readerSchema;
    }

    public static HoodieLogBlock getBlock(HoodieLogFile logFile, FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, long position, long blockSize, long blockEndpos, Schema readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer) {
        return new HoodieAvroDataBlock(content, inputStream, readBlockLazily, Option.of(new HoodieLogBlock.HoodieLogBlockContentLocation(logFile, position, blockSize, blockEndpos)), readerSchema, header, footer);
    }

    @Override
    public byte[] getContentBytes() throws IOException {
        if (this.getContent().isPresent()) {
            return this.getContent().get();
        }
        if (this.readBlockLazily && !this.getContent().isPresent() && this.records == null) {
            this.createRecordsFromContentBytes();
        }
        Schema schema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        output.writeInt(HoodieLogBlock.version);
        output.writeInt(this.records.size());
        Iterator<IndexedRecord> itr = this.records.iterator();
        while (itr.hasNext()) {
            IndexedRecord s = itr.next();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)temp, this.encoderCache.get());
            this.encoderCache.set(encoder);
            try {
                writer.write((Object)s, (Encoder)encoder);
                encoder.flush();
                int size = temp.toByteArray().length;
                output.writeInt(size);
                output.write(temp.toByteArray());
                itr.remove();
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
            }
        }
        output.close();
        return baos.toByteArray();
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.AVRO_DATA_BLOCK;
    }

    public List<IndexedRecord> getRecords() {
        if (this.records == null) {
            try {
                this.createRecordsFromContentBytes();
            }
            catch (IOException io) {
                throw new HoodieIOException("Unable to convert content bytes to records", io);
            }
        }
        return this.records;
    }

    public Schema getSchema() {
        if (this.records == null) {
            this.getRecords();
        }
        return this.schema;
    }

    private void createRecordsFromContentBytes() throws IOException {
        if (this.readBlockLazily && !this.getContent().isPresent()) {
            this.inflate();
        }
        SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(this.getContent().get())));
        int version = dis.readInt();
        HoodieAvroDataBlockVersion logBlockVersion = new HoodieAvroDataBlockVersion(version);
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        if (this.schema == null) {
            this.schema = writerSchema;
        }
        GenericDatumReader reader = new GenericDatumReader(writerSchema, this.schema);
        int totalRecords = 0;
        if (logBlockVersion.hasRecordCount()) {
            totalRecords = dis.readInt();
        }
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>(totalRecords);
        for (int i = 0; i < totalRecords; ++i) {
            int recordLength = dis.readInt();
            BinaryDecoder decoder2 = DecoderFactory.get().binaryDecoder(this.getContent().get(), dis.getNumberOfBytesRead().intValue(), recordLength, this.decoderCache.get());
            this.decoderCache.set(decoder2);
            IndexedRecord record = (IndexedRecord)reader.read(null, (Decoder)decoder2);
            records.add(record);
            dis.skipBytes(recordLength);
        }
        dis.close();
        this.records = records;
        this.deflate();
    }

    @Deprecated
    @VisibleForTesting
    public HoodieAvroDataBlock(List<IndexedRecord> records, Schema schema) {
        super(new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), Option.empty(), Option.empty(), null, false);
        this.records = records;
        this.schema = schema;
    }

    @Deprecated
    public static HoodieLogBlock getBlock(byte[] content, Schema readerSchema) throws IOException {
        SizeAwareDataInputStream dis = new SizeAwareDataInputStream(new DataInputStream(new ByteArrayInputStream(content)));
        int schemaLength = dis.readInt();
        byte[] compressedSchema = new byte[schemaLength];
        dis.readFully(compressedSchema, 0, schemaLength);
        Schema writerSchema = new Schema.Parser().parse(HoodieAvroUtils.decompress(compressedSchema));
        if (readerSchema == null) {
            readerSchema = writerSchema;
        }
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        int totalRecords = dis.readInt();
        ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>(totalRecords);
        for (int i = 0; i < totalRecords; ++i) {
            int recordLength = dis.readInt();
            BinaryDecoder decoder2 = DecoderFactory.get().binaryDecoder(content, dis.getNumberOfBytesRead().intValue(), recordLength, null);
            IndexedRecord record = (IndexedRecord)reader.read(null, (Decoder)decoder2);
            records.add(record);
            dis.skipBytes(recordLength);
        }
        dis.close();
        return new HoodieAvroDataBlock(records, readerSchema);
    }

    @Deprecated
    @VisibleForTesting
    public byte[] getBytes(Schema schema) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(baos);
        byte[] schemaContent = HoodieAvroUtils.compress(schema.toString());
        output.writeInt(schemaContent.length);
        output.write(schemaContent);
        output.writeInt(this.records.size());
        Iterator<IndexedRecord> itr = this.records.iterator();
        while (itr.hasNext()) {
            IndexedRecord s = itr.next();
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)temp, null);
            try {
                writer.write((Object)s, (Encoder)encoder);
                encoder.flush();
                int size = temp.toByteArray().length;
                output.writeInt(size);
                output.write(temp.toByteArray());
                itr.remove();
            }
            catch (IOException e) {
                throw new HoodieIOException("IOException converting HoodieAvroDataBlock to bytes", e);
            }
        }
        output.close();
        return baos.toByteArray();
    }
}

