/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import com.google.common.collect.Sets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.table.HoodieTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieDefaultTimeline
implements HoodieTimeline {
    private static final Logger LOG = LogManager.getLogger(HoodieDefaultTimeline.class);
    private static final String HASHING_ALGORITHM = "SHA-256";
    protected transient Function<HoodieInstant, Option<byte[]>> details;
    private List<HoodieInstant> instants;
    private String timelineHash;

    public HoodieDefaultTimeline(Stream<HoodieInstant> instants, Function<HoodieInstant, Option<byte[]>> details) {
        this.details = details;
        this.setInstants(instants.collect(Collectors.toList()));
    }

    public void setInstants(List<HoodieInstant> instants) {
        MessageDigest md;
        this.instants = instants;
        try {
            md = MessageDigest.getInstance(HASHING_ALGORITHM);
            this.instants.stream().forEach(i -> md.update(StringUtils.joinUsingDelim("_", i.getTimestamp(), i.getAction(), i.getState().name()).getBytes()));
        }
        catch (NoSuchAlgorithmException nse) {
            throw new HoodieException(nse);
        }
        this.timelineHash = StringUtils.toHexString(md.digest());
    }

    public HoodieDefaultTimeline() {
    }

    @Override
    public HoodieTimeline filterInflights() {
        return new HoodieDefaultTimeline(this.instants.stream().filter(HoodieInstant::isInflight), this.details);
    }

    @Override
    public HoodieTimeline filterInflightsAndRequested() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T i) -> i.getState().equals((Object)HoodieInstant.State.REQUESTED) || i.getState().equals((Object)HoodieInstant.State.INFLIGHT)), this.details);
    }

    @Override
    public HoodieTimeline filterPendingExcludingCompaction() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T instant) -> !instant.isCompleted() && !instant.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedInstants() {
        return new HoodieDefaultTimeline(this.instants.stream().filter(HoodieInstant::isCompleted), this.details);
    }

    @Override
    public HoodieTimeline filterCompletedAndCompactionInstants() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> !s.isInflight() || s.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieTimeline getCommitsAndCompactionTimeline() {
        HashSet validActions = Sets.newHashSet((Object[])new String[]{"commit", "deltacommit", "compaction"});
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> validActions.contains(s.getAction())), this.details);
    }

    @Override
    public HoodieTimeline filterPendingCompactionTimeline() {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> s.getAction().equals("compaction")), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsInRange(String startTs, String endTs) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), startTs, GREATER) && HoodieTimeline.compareTimestamps(s.getTimestamp(), endTs, LESSER_OR_EQUAL)), this.details);
    }

    @Override
    public HoodieDefaultTimeline findInstantsAfter(String commitTime, int numCommits) {
        return new HoodieDefaultTimeline(this.instants.stream().filter((? super T s) -> HoodieTimeline.compareTimestamps(s.getTimestamp(), commitTime, GREATER)).limit(numCommits), this.details);
    }

    @Override
    public HoodieTimeline filter(Predicate<HoodieInstant> filter) {
        return new HoodieDefaultTimeline(this.instants.stream().filter(filter), this.details);
    }

    @Override
    public boolean empty() {
        return !this.instants.stream().findFirst().isPresent();
    }

    @Override
    public int countInstants() {
        return this.instants.size();
    }

    @Override
    public Option<HoodieInstant> firstInstant() {
        return Option.fromJavaOptional(this.instants.stream().findFirst());
    }

    @Override
    public Option<HoodieInstant> nthInstant(int n) {
        if (this.empty() || n >= this.countInstants()) {
            return Option.empty();
        }
        return Option.of(this.instants.get(n));
    }

    @Override
    public Option<HoodieInstant> lastInstant() {
        return this.empty() ? Option.empty() : this.nthInstant(this.countInstants() - 1);
    }

    @Override
    public Option<HoodieInstant> nthFromLastInstant(int n) {
        if (this.countInstants() < n + 1) {
            return Option.empty();
        }
        return this.nthInstant(this.countInstants() - 1 - n);
    }

    @Override
    public boolean containsInstant(HoodieInstant instant) {
        return this.instants.stream().anyMatch(s -> s.equals(instant));
    }

    @Override
    public boolean containsOrBeforeTimelineStarts(String instant) {
        return this.instants.stream().anyMatch(s -> s.getTimestamp().equals(instant)) || this.isBeforeTimelineStarts(instant);
    }

    @Override
    public String getTimelineHash() {
        return this.timelineHash;
    }

    @Override
    public Stream<HoodieInstant> getInstants() {
        return this.instants.stream();
    }

    @Override
    public Stream<HoodieInstant> getReverseOrderedInstants() {
        List instants = this.getInstants().collect(Collectors.toList());
        Collections.reverse(instants);
        return instants.stream();
    }

    @Override
    public boolean isBeforeTimelineStarts(String instant) {
        Option<HoodieInstant> firstCommit = this.firstInstant();
        return firstCommit.isPresent() && HoodieTimeline.compareTimestamps(instant, firstCommit.get().getTimestamp(), LESSER);
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        return this.details.apply(instant);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.instants.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

