/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.avro.model.HoodieSavepointPartitionMetadata;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.util.Option;

public class AvroUtils {
    private static final Integer DEFAULT_VERSION = 1;

    public static HoodieRestoreMetadata convertRestoreMetadata(String startRestoreTime, Option<Long> durationInMs, List<String> commits, Map<String, List<HoodieRollbackStat>> commitToStats) {
        ImmutableMap.Builder commitToStatBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<HoodieRollbackStat>> commitToStat : commitToStats.entrySet()) {
            commitToStatBuilder.put((Object)commitToStat.getKey(), Arrays.asList(AvroUtils.convertRollbackMetadata(startRestoreTime, durationInMs, commits, commitToStat.getValue())));
        }
        return new HoodieRestoreMetadata(startRestoreTime, durationInMs.orElseGet(() -> -1L), commits, (Map<String, List<HoodieRollbackMetadata>>)commitToStatBuilder.build(), DEFAULT_VERSION);
    }

    public static HoodieRollbackMetadata convertRollbackMetadata(String startRollbackTime, Option<Long> durationInMs, List<String> commits, List<HoodieRollbackStat> rollbackStats) {
        ImmutableMap.Builder partitionMetadataBuilder = ImmutableMap.builder();
        int totalDeleted = 0;
        for (HoodieRollbackStat stat : rollbackStats) {
            HoodieRollbackPartitionMetadata metadata = new HoodieRollbackPartitionMetadata(stat.getPartitionPath(), stat.getSuccessDeleteFiles(), stat.getFailedDeleteFiles());
            partitionMetadataBuilder.put((Object)stat.getPartitionPath(), (Object)metadata);
            totalDeleted += stat.getSuccessDeleteFiles().size();
        }
        return new HoodieRollbackMetadata(startRollbackTime, durationInMs.orElseGet(() -> -1L), totalDeleted, commits, (Map<String, HoodieRollbackPartitionMetadata>)partitionMetadataBuilder.build(), DEFAULT_VERSION);
    }

    public static HoodieSavepointMetadata convertSavepointMetadata(String user, String comment, Map<String, List<String>> latestFiles) {
        ImmutableMap.Builder partitionMetadataBuilder = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> stat : latestFiles.entrySet()) {
            HoodieSavepointPartitionMetadata metadata = new HoodieSavepointPartitionMetadata(stat.getKey(), stat.getValue());
            partitionMetadataBuilder.put((Object)stat.getKey(), (Object)metadata);
        }
        return new HoodieSavepointMetadata(user, System.currentTimeMillis(), comment, (Map<String, HoodieSavepointPartitionMetadata>)partitionMetadataBuilder.build(), DEFAULT_VERSION);
    }

    public static Option<byte[]> serializeCompactionPlan(HoodieCompactionPlan compactionWorkload) throws IOException {
        return AvroUtils.serializeAvroMetadata(compactionWorkload, HoodieCompactionPlan.class);
    }

    public static Option<byte[]> serializeCleanerPlan(HoodieCleanerPlan cleanPlan) throws IOException {
        return AvroUtils.serializeAvroMetadata(cleanPlan, HoodieCleanerPlan.class);
    }

    public static Option<byte[]> serializeCleanMetadata(HoodieCleanMetadata metadata) throws IOException {
        return AvroUtils.serializeAvroMetadata(metadata, HoodieCleanMetadata.class);
    }

    public static Option<byte[]> serializeSavepointMetadata(HoodieSavepointMetadata metadata) throws IOException {
        return AvroUtils.serializeAvroMetadata(metadata, HoodieSavepointMetadata.class);
    }

    public static Option<byte[]> serializeRollbackMetadata(HoodieRollbackMetadata rollbackMetadata) throws IOException {
        return AvroUtils.serializeAvroMetadata(rollbackMetadata, HoodieRollbackMetadata.class);
    }

    public static Option<byte[]> serializeRestoreMetadata(HoodieRestoreMetadata restoreMetadata) throws IOException {
        return AvroUtils.serializeAvroMetadata(restoreMetadata, HoodieRestoreMetadata.class);
    }

    public static <T extends SpecificRecordBase> Option<byte[]> serializeAvroMetadata(T metadata, Class<T> clazz) throws IOException {
        SpecificDatumWriter datumWriter = new SpecificDatumWriter(clazz);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        fileWriter.create(metadata.getSchema(), (OutputStream)baos);
        fileWriter.append(metadata);
        fileWriter.flush();
        return Option.of(baos.toByteArray());
    }

    public static HoodieCleanerPlan deserializeCleanerPlan(byte[] bytes) throws IOException {
        return AvroUtils.deserializeAvroMetadata(bytes, HoodieCleanerPlan.class);
    }

    public static HoodieCompactionPlan deserializeCompactionPlan(byte[] bytes) throws IOException {
        return AvroUtils.deserializeAvroMetadata(bytes, HoodieCompactionPlan.class);
    }

    public static HoodieCleanMetadata deserializeHoodieCleanMetadata(byte[] bytes) throws IOException {
        return AvroUtils.deserializeAvroMetadata(bytes, HoodieCleanMetadata.class);
    }

    public static HoodieSavepointMetadata deserializeHoodieSavepointMetadata(byte[] bytes) throws IOException {
        return AvroUtils.deserializeAvroMetadata(bytes, HoodieSavepointMetadata.class);
    }

    public static <T extends SpecificRecordBase> T deserializeAvroMetadata(byte[] bytes, Class<T> clazz) throws IOException {
        SpecificDatumReader reader = new SpecificDatumReader(clazz);
        FileReader fileReader = DataFileReader.openReader((SeekableInput)new SeekableByteArrayInput(bytes), (DatumReader)reader);
        Preconditions.checkArgument((boolean)fileReader.hasNext(), (Object)("Could not deserialize metadata of type " + clazz));
        return (T)((SpecificRecordBase)fileReader.next());
    }
}

