/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.config.DefaultHoodieConfig;
import org.apache.hudi.index.hbase.DefaultHBaseQPSResourceAllocator;

public class HoodieHBaseIndexConfig
extends DefaultHoodieConfig {
    public static final String HBASE_ZKQUORUM_PROP = "hoodie.index.hbase.zkquorum";
    public static final String HBASE_ZKPORT_PROP = "hoodie.index.hbase.zkport";
    public static final String HBASE_TABLENAME_PROP = "hoodie.index.hbase.table";
    public static final String HBASE_GET_BATCH_SIZE_PROP = "hoodie.index.hbase.get.batch.size";
    public static final String HBASE_ZK_ZNODEPARENT = "hoodie.index.hbase.zknode.path";
    public static final String HBASE_PUT_BATCH_SIZE_PROP = "hoodie.index.hbase.put.batch.size";
    public static final String HBASE_INDEX_QPS_ALLOCATOR_CLASS = "hoodie.index.hbase.qps.allocator.class";
    public static final String DEFAULT_HBASE_INDEX_QPS_ALLOCATOR_CLASS = DefaultHBaseQPSResourceAllocator.class.getName();
    public static final String HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE_PROP = "hoodie.index.hbase.put.batch.size.autocompute";
    public static final String DEFAULT_HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE = "false";
    public static final String HBASE_QPS_FRACTION_PROP = "hoodie.index.hbase.qps.fraction";
    public static String HBASE_MAX_QPS_PER_REGION_SERVER_PROP = "hoodie.index.hbase.max.qps.per.region.server";
    public static final int DEFAULT_HBASE_BATCH_SIZE = 100;
    public static final int DEFAULT_HBASE_MAX_QPS_PER_REGION_SERVER = 1000;
    public static final float DEFAULT_HBASE_QPS_FRACTION = 0.5f;
    public static final String HOODIE_INDEX_COMPUTE_QPS_DYNAMICALLY = "hoodie.index.hbase.dynamic_qps";
    public static final boolean DEFAULT_HOODIE_INDEX_COMPUTE_QPS_DYNAMICALLY = false;
    public static final String HBASE_MIN_QPS_FRACTION_PROP = "hoodie.index.hbase.min.qps.fraction";
    public static final String HBASE_MAX_QPS_FRACTION_PROP = "hoodie.index.hbase.max.qps.fraction";
    public static final String HOODIE_INDEX_DESIRED_PUTS_TIME_IN_SECS = "hoodie.index.hbase.desired_puts_time_in_secs";
    public static final int DEFAULT_HOODIE_INDEX_DESIRED_PUTS_TIME_IN_SECS = 600;
    public static final String HBASE_SLEEP_MS_PUT_BATCH_PROP = "hoodie.index.hbase.sleep.ms.for.put.batch";
    public static final String HBASE_SLEEP_MS_GET_BATCH_PROP = "hoodie.index.hbase.sleep.ms.for.get.batch";
    public static final String HOODIE_INDEX_HBASE_ZK_SESSION_TIMEOUT_MS = "hoodie.index.hbase.zk.session_timeout_ms";
    public static final int DEFAULT_ZK_SESSION_TIMEOUT_MS = 60000;
    public static final String HOODIE_INDEX_HBASE_ZK_CONNECTION_TIMEOUT_MS = "hoodie.index.hbase.zk.connection_timeout_ms";
    public static final int DEFAULT_ZK_CONNECTION_TIMEOUT_MS = 15000;
    public static final String HBASE_ZK_PATH_QPS_ROOT = "hoodie.index.hbase.zkpath.qps_root";
    public static final String DEFAULT_HBASE_ZK_PATH_QPS_ROOT = "/QPS_ROOT";

    public HoodieHBaseIndexConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder hbaseZkQuorum(String zkString) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_ZKQUORUM_PROP, zkString);
            return this;
        }

        public Builder hbaseZkPort(int port) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_ZKPORT_PROP, String.valueOf(port));
            return this;
        }

        public Builder hbaseTableName(String tableName) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_TABLENAME_PROP, tableName);
            return this;
        }

        public Builder hbaseZkZnodeQPSPath(String zkZnodeQPSPath) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_ZK_PATH_QPS_ROOT, zkZnodeQPSPath);
            return this;
        }

        public Builder hbaseIndexGetBatchSize(int getBatchSize) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_GET_BATCH_SIZE_PROP, String.valueOf(getBatchSize));
            return this;
        }

        public Builder hbaseIndexPutBatchSize(int putBatchSize) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_PROP, String.valueOf(putBatchSize));
            return this;
        }

        public Builder hbaseIndexPutBatchSizeAutoCompute(boolean putBatchSizeAutoCompute) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE_PROP, String.valueOf(putBatchSizeAutoCompute));
            return this;
        }

        public Builder hbaseIndexDesiredPutsTime(int desiredPutsTime) {
            this.props.setProperty(HoodieHBaseIndexConfig.HOODIE_INDEX_DESIRED_PUTS_TIME_IN_SECS, String.valueOf(desiredPutsTime));
            return this;
        }

        public Builder hbaseIndexShouldComputeQPSDynamically(boolean shouldComputeQPsDynamically) {
            this.props.setProperty(HoodieHBaseIndexConfig.HOODIE_INDEX_COMPUTE_QPS_DYNAMICALLY, String.valueOf(shouldComputeQPsDynamically));
            return this;
        }

        public Builder hbaseIndexQPSFraction(float qpsFraction) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_QPS_FRACTION_PROP, String.valueOf(qpsFraction));
            return this;
        }

        public Builder hbaseIndexMinQPSFraction(float minQPSFraction) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_MIN_QPS_FRACTION_PROP, String.valueOf(minQPSFraction));
            return this;
        }

        public Builder hbaseIndexMaxQPSFraction(float maxQPSFraction) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_MAX_QPS_FRACTION_PROP, String.valueOf(maxQPSFraction));
            return this;
        }

        public Builder hbaseIndexSleepMsBetweenPutBatch(int sleepMsBetweenPutBatch) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_SLEEP_MS_PUT_BATCH_PROP, String.valueOf(sleepMsBetweenPutBatch));
            return this;
        }

        public Builder hbaseIndexSleepMsBetweenGetBatch(int sleepMsBetweenGetBatch) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_SLEEP_MS_GET_BATCH_PROP, String.valueOf(sleepMsBetweenGetBatch));
            return this;
        }

        public Builder withQPSResourceAllocatorType(String qpsResourceAllocatorClass) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_INDEX_QPS_ALLOCATOR_CLASS, qpsResourceAllocatorClass);
            return this;
        }

        public Builder hbaseIndexZkSessionTimeout(int zkSessionTimeout) {
            this.props.setProperty(HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_SESSION_TIMEOUT_MS, String.valueOf(zkSessionTimeout));
            return this;
        }

        public Builder hbaseIndexZkConnectionTimeout(int zkConnectionTimeout) {
            this.props.setProperty(HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_CONNECTION_TIMEOUT_MS, String.valueOf(zkConnectionTimeout));
            return this;
        }

        public Builder hbaseZkZnodeParent(String zkZnodeParent) {
            this.props.setProperty(HoodieHBaseIndexConfig.HBASE_ZK_ZNODEPARENT, zkZnodeParent);
            return this;
        }

        public Builder hbaseIndexMaxQPSPerRegionServer(int maxQPSPerRegionServer) {
            this.props.setProperty(HBASE_MAX_QPS_PER_REGION_SERVER_PROP, String.valueOf(maxQPSPerRegionServer));
            return this;
        }

        public HoodieHBaseIndexConfig build() {
            HoodieHBaseIndexConfig config = new HoodieHBaseIndexConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_GET_BATCH_SIZE_PROP), HoodieHBaseIndexConfig.HBASE_GET_BATCH_SIZE_PROP, String.valueOf(100));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_PROP), HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_PROP, String.valueOf(100));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE_PROP), HoodieHBaseIndexConfig.HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE_PROP, HoodieHBaseIndexConfig.DEFAULT_HBASE_PUT_BATCH_SIZE_AUTO_COMPUTE);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_QPS_FRACTION_PROP), HoodieHBaseIndexConfig.HBASE_QPS_FRACTION_PROP, String.valueOf(0.5f));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HBASE_MAX_QPS_PER_REGION_SERVER_PROP), HBASE_MAX_QPS_PER_REGION_SERVER_PROP, String.valueOf(1000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HOODIE_INDEX_COMPUTE_QPS_DYNAMICALLY), HoodieHBaseIndexConfig.HOODIE_INDEX_COMPUTE_QPS_DYNAMICALLY, String.valueOf(false));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_INDEX_QPS_ALLOCATOR_CLASS), HoodieHBaseIndexConfig.HBASE_INDEX_QPS_ALLOCATOR_CLASS, String.valueOf(DEFAULT_HBASE_INDEX_QPS_ALLOCATOR_CLASS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HOODIE_INDEX_DESIRED_PUTS_TIME_IN_SECS), HoodieHBaseIndexConfig.HOODIE_INDEX_DESIRED_PUTS_TIME_IN_SECS, String.valueOf(600));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_ZK_PATH_QPS_ROOT), HoodieHBaseIndexConfig.HBASE_ZK_PATH_QPS_ROOT, HoodieHBaseIndexConfig.DEFAULT_HBASE_ZK_PATH_QPS_ROOT);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_SESSION_TIMEOUT_MS), HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_SESSION_TIMEOUT_MS, String.valueOf(60000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_CONNECTION_TIMEOUT_MS), HoodieHBaseIndexConfig.HOODIE_INDEX_HBASE_ZK_CONNECTION_TIMEOUT_MS, String.valueOf(15000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieHBaseIndexConfig.HBASE_INDEX_QPS_ALLOCATOR_CLASS), HoodieHBaseIndexConfig.HBASE_INDEX_QPS_ALLOCATOR_CLASS, String.valueOf(DEFAULT_HBASE_INDEX_QPS_ALLOCATOR_CLASS));
            return config;
        }
    }
}

