/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.config.DefaultHoodieConfig;
import org.apache.spark.SparkEnv;
import org.apache.spark.util.Utils;

@Immutable
public class HoodieMemoryConfig
extends DefaultHoodieConfig {
    public static final String MAX_MEMORY_FRACTION_FOR_MERGE_PROP = "hoodie.memory.merge.fraction";
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_MERGE = String.valueOf(0.6);
    public static final String MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP = "hoodie.memory.compaction.fraction";
    public static final String DEFAULT_MAX_MEMORY_FRACTION_FOR_COMPACTION = String.valueOf(0.6);
    public static final long DEFAULT_MAX_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x40000000L;
    public static final long DEFAULT_MIN_MEMORY_FOR_SPILLABLE_MAP_IN_BYTES = 0x6400000L;
    public static final String MAX_MEMORY_FOR_MERGE_PROP = "hoodie.memory.merge.max.size";
    public static final String MAX_MEMORY_FOR_COMPACTION_PROP = "hoodie.memory.compaction.max.size";
    public static final String MAX_DFS_STREAM_BUFFER_SIZE_PROP = "hoodie.memory.dfs.buffer.max.size";
    public static final int DEFAULT_MAX_DFS_STREAM_BUFFER_SIZE = 0x1000000;
    public static final String SPILLABLE_MAP_BASE_PATH_PROP = "hoodie.memory.spillable.map.path";
    public static final String DEFAULT_SPILLABLE_MAP_BASE_PATH = "/tmp/";
    public static final String WRITESTATUS_FAILURE_FRACTION_PROP = "hoodie.memory.writestatus.failure.fraction";
    public static final double DEFAULT_WRITESTATUS_FAILURE_FRACTION = 0.1;

    private HoodieMemoryConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withMaxMemoryFractionPerPartitionMerge(double maxMemoryFractionPerPartitionMerge) {
            this.props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE_PROP, String.valueOf(maxMemoryFractionPerPartitionMerge));
            return this;
        }

        public Builder withMaxMemoryMaxSize(long mergeMaxSize, long compactionMaxSize) {
            this.props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE_PROP, String.valueOf(mergeMaxSize));
            this.props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION_PROP, String.valueOf(compactionMaxSize));
            return this;
        }

        public Builder withMaxMemoryFractionPerCompaction(double maxMemoryFractionPerCompaction) {
            this.props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP, String.valueOf(maxMemoryFractionPerCompaction));
            return this;
        }

        public Builder withMaxDFSStreamBufferSize(int maxStreamBufferSize) {
            this.props.setProperty(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE_PROP, String.valueOf(maxStreamBufferSize));
            return this;
        }

        public Builder withWriteStatusFailureFraction(double failureFraction) {
            this.props.setProperty(HoodieMemoryConfig.WRITESTATUS_FAILURE_FRACTION_PROP, String.valueOf(failureFraction));
            return this;
        }

        private long getMaxMemoryAllowedForMerge(String maxMemoryFraction) {
            String SPARK_EXECUTOR_MEMORY_PROP = "spark.executor.memory";
            String SPARK_EXECUTOR_MEMORY_FRACTION_PROP = "spark.memory.fraction";
            String DEFAULT_SPARK_EXECUTOR_MEMORY_FRACTION = "0.6";
            String DEFAULT_SPARK_EXECUTOR_MEMORY_MB = "1024";
            if (SparkEnv.get() != null) {
                long executorMemoryInBytes = (long)(Utils.memoryStringToMb((String)SparkEnv.get().conf().get("spark.executor.memory", "1024")) * 1024) * 1024L;
                double memoryFraction = Double.parseDouble(SparkEnv.get().conf().get("spark.memory.fraction", "0.6"));
                double maxMemoryFractionForMerge = Double.parseDouble(maxMemoryFraction);
                double userAvailableMemory = (double)executorMemoryInBytes * (1.0 - memoryFraction);
                long maxMemoryForMerge = (long)Math.floor(userAvailableMemory * maxMemoryFractionForMerge);
                return Math.max(0x6400000L, maxMemoryForMerge);
            }
            return 0x40000000L;
        }

        public HoodieMemoryConfig build() {
            HoodieMemoryConfig config = new HoodieMemoryConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP), HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP, DEFAULT_MAX_MEMORY_FRACTION_FOR_COMPACTION);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE_PROP), HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE_PROP, DEFAULT_MAX_MEMORY_FRACTION_FOR_MERGE);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE_PROP), HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE_PROP, String.valueOf(this.getMaxMemoryAllowedForMerge(this.props.getProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE_PROP))));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION_PROP), HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION_PROP, String.valueOf(this.getMaxMemoryAllowedForMerge(this.props.getProperty(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION_PROP))));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE_PROP), HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE_PROP, String.valueOf(0x1000000));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH_PROP), HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH_PROP, HoodieMemoryConfig.DEFAULT_SPILLABLE_MAP_BASE_PATH);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieMemoryConfig.WRITESTATUS_FAILURE_FRACTION_PROP), HoodieMemoryConfig.WRITESTATUS_FAILURE_FRACTION_PROP, String.valueOf(0.1));
            return config;
        }
    }
}

