/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.config.DefaultHoodieConfig;

@Immutable
public class HoodieStorageConfig
extends DefaultHoodieConfig {
    public static final String PARQUET_FILE_MAX_BYTES = "hoodie.parquet.max.file.size";
    public static final String DEFAULT_PARQUET_FILE_MAX_BYTES;
    public static final String PARQUET_BLOCK_SIZE_BYTES = "hoodie.parquet.block.size";
    public static final String DEFAULT_PARQUET_BLOCK_SIZE_BYTES;
    public static final String PARQUET_PAGE_SIZE_BYTES = "hoodie.parquet.page.size";
    public static final String DEFAULT_PARQUET_PAGE_SIZE_BYTES;
    public static final String LOGFILE_SIZE_MAX_BYTES = "hoodie.logfile.max.size";
    public static final String DEFAULT_LOGFILE_SIZE_MAX_BYTES;
    public static final String LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES = "hoodie.logfile.data.block.max.size";
    public static final String DEFAULT_LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES;
    public static final String PARQUET_COMPRESSION_RATIO = "hoodie.parquet.compression.ratio";
    public static final String DEFAULT_STREAM_COMPRESSION_RATIO;
    public static final String PARQUET_COMPRESSION_CODEC = "hoodie.parquet.compression.codec";
    public static final String DEFAULT_PARQUET_COMPRESSION_CODEC = "gzip";
    public static final String LOGFILE_TO_PARQUET_COMPRESSION_RATIO = "hoodie.logfile.to.parquet.compression.ratio";
    public static final String DEFAULT_LOGFILE_TO_PARQUET_COMPRESSION_RATIO;

    private HoodieStorageConfig(Properties props) {
        super(props);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        DEFAULT_PARQUET_BLOCK_SIZE_BYTES = DEFAULT_PARQUET_FILE_MAX_BYTES = String.valueOf(0x7800000);
        DEFAULT_PARQUET_PAGE_SIZE_BYTES = String.valueOf(0x100000);
        DEFAULT_LOGFILE_SIZE_MAX_BYTES = String.valueOf(0x40000000);
        DEFAULT_LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES = String.valueOf(0x10000000);
        DEFAULT_STREAM_COMPRESSION_RATIO = String.valueOf(0.1);
        DEFAULT_LOGFILE_TO_PARQUET_COMPRESSION_RATIO = String.valueOf(0.35);
    }

    public static class Builder {
        private final Properties props = new Properties();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.props.putAll((Map<?, ?>)props);
            return this;
        }

        public Builder limitFileSize(long maxFileSize) {
            this.props.setProperty(HoodieStorageConfig.PARQUET_FILE_MAX_BYTES, String.valueOf(maxFileSize));
            return this;
        }

        public Builder parquetBlockSize(int blockSize) {
            this.props.setProperty(HoodieStorageConfig.PARQUET_BLOCK_SIZE_BYTES, String.valueOf(blockSize));
            return this;
        }

        public Builder parquetPageSize(int pageSize) {
            this.props.setProperty(HoodieStorageConfig.PARQUET_PAGE_SIZE_BYTES, String.valueOf(pageSize));
            return this;
        }

        public Builder logFileDataBlockMaxSize(int dataBlockSize) {
            this.props.setProperty(HoodieStorageConfig.LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES, String.valueOf(dataBlockSize));
            return this;
        }

        public Builder logFileMaxSize(int logFileSize) {
            this.props.setProperty(HoodieStorageConfig.LOGFILE_SIZE_MAX_BYTES, String.valueOf(logFileSize));
            return this;
        }

        public Builder parquetCompressionRatio(double parquetCompressionRatio) {
            this.props.setProperty(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO, String.valueOf(parquetCompressionRatio));
            return this;
        }

        public Builder parquetCompressionCodec(String parquetCompressionCodec) {
            this.props.setProperty(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC, parquetCompressionCodec);
            return this;
        }

        public Builder logFileToParquetCompressionRatio(double logFileToParquetCompressionRatio) {
            this.props.setProperty(HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO, String.valueOf(logFileToParquetCompressionRatio));
            return this;
        }

        public HoodieStorageConfig build() {
            HoodieStorageConfig config = new HoodieStorageConfig(this.props);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.PARQUET_FILE_MAX_BYTES), HoodieStorageConfig.PARQUET_FILE_MAX_BYTES, DEFAULT_PARQUET_FILE_MAX_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.PARQUET_BLOCK_SIZE_BYTES), HoodieStorageConfig.PARQUET_BLOCK_SIZE_BYTES, DEFAULT_PARQUET_BLOCK_SIZE_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.PARQUET_PAGE_SIZE_BYTES), HoodieStorageConfig.PARQUET_PAGE_SIZE_BYTES, DEFAULT_PARQUET_PAGE_SIZE_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES), HoodieStorageConfig.LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES, DEFAULT_LOGFILE_DATA_BLOCK_SIZE_MAX_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.LOGFILE_SIZE_MAX_BYTES), HoodieStorageConfig.LOGFILE_SIZE_MAX_BYTES, DEFAULT_LOGFILE_SIZE_MAX_BYTES);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO), HoodieStorageConfig.PARQUET_COMPRESSION_RATIO, DEFAULT_STREAM_COMPRESSION_RATIO);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC), HoodieStorageConfig.PARQUET_COMPRESSION_CODEC, HoodieStorageConfig.DEFAULT_PARQUET_COMPRESSION_CODEC);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO), HoodieStorageConfig.LOGFILE_TO_PARQUET_COMPRESSION_RATIO, DEFAULT_LOGFILE_TO_PARQUET_COMPRESSION_RATIO);
            return config;
        }
    }
}

