/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.TimelineLayoutVersion;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.ConsistencyGuardConfig;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.DefaultHoodieConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieHBaseIndexConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieMemoryConfig;
import org.apache.hudi.config.HoodieMetricsConfig;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.compact.strategy.CompactionStrategy;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.storage.StorageLevel;

@Immutable
public class HoodieWriteConfig
extends DefaultHoodieConfig {
    public static final String TABLE_NAME = "hoodie.table.name";
    private static final String TIMELINE_LAYOUT_VERSION = "hoodie.timeline.layout.version";
    private static final String BASE_PATH_PROP = "hoodie.base.path";
    private static final String AVRO_SCHEMA = "hoodie.avro.schema";
    private static final String DEFAULT_PARALLELISM = "1500";
    private static final String INSERT_PARALLELISM = "hoodie.insert.shuffle.parallelism";
    private static final String BULKINSERT_PARALLELISM = "hoodie.bulkinsert.shuffle.parallelism";
    private static final String UPSERT_PARALLELISM = "hoodie.upsert.shuffle.parallelism";
    private static final String DELETE_PARALLELISM = "hoodie.delete.shuffle.parallelism";
    private static final String DEFAULT_ROLLBACK_PARALLELISM = "100";
    private static final String ROLLBACK_PARALLELISM = "hoodie.rollback.parallelism";
    private static final String WRITE_BUFFER_LIMIT_BYTES = "hoodie.write.buffer.limit.bytes";
    private static final String DEFAULT_WRITE_BUFFER_LIMIT_BYTES = String.valueOf(0x400000);
    private static final String COMBINE_BEFORE_INSERT_PROP = "hoodie.combine.before.insert";
    private static final String DEFAULT_COMBINE_BEFORE_INSERT = "false";
    private static final String COMBINE_BEFORE_UPSERT_PROP = "hoodie.combine.before.upsert";
    private static final String DEFAULT_COMBINE_BEFORE_UPSERT = "true";
    private static final String COMBINE_BEFORE_DELETE_PROP = "hoodie.combine.before.delete";
    private static final String DEFAULT_COMBINE_BEFORE_DELETE = "true";
    private static final String WRITE_STATUS_STORAGE_LEVEL = "hoodie.write.status.storage.level";
    private static final String DEFAULT_WRITE_STATUS_STORAGE_LEVEL = "MEMORY_AND_DISK_SER";
    private static final String HOODIE_AUTO_COMMIT_PROP = "hoodie.auto.commit";
    private static final String DEFAULT_HOODIE_AUTO_COMMIT = "true";
    private static final String HOODIE_ASSUME_DATE_PARTITIONING_PROP = "hoodie.assume.date.partitioning";
    private static final String DEFAULT_ASSUME_DATE_PARTITIONING = "false";
    private static final String HOODIE_WRITE_STATUS_CLASS_PROP = "hoodie.writestatus.class";
    private static final String DEFAULT_HOODIE_WRITE_STATUS_CLASS = WriteStatus.class.getName();
    private static final String FINALIZE_WRITE_PARALLELISM = "hoodie.finalize.write.parallelism";
    private static final String DEFAULT_FINALIZE_WRITE_PARALLELISM = "1500";
    private static final String EMBEDDED_TIMELINE_SERVER_ENABLED = "hoodie.embed.timeline.server";
    private static final String DEFAULT_EMBEDDED_TIMELINE_SERVER_ENABLED = "false";
    private static final String FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP = "hoodie.fail.on.timeline.archiving";
    private static final String DEFAULT_FAIL_ON_TIMELINE_ARCHIVING_ENABLED = "true";
    private static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.initial_interval_ms";
    private static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = 2000L;
    private static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = "hoodie.consistency.check.max_interval_ms";
    private static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = 300000L;
    private static final String MAX_CONSISTENCY_CHECKS_PROP = "hoodie.consistency.check.max_checks";
    private static int DEFAULT_MAX_CONSISTENCY_CHECKS = 7;
    private ConsistencyGuardConfig consistencyGuardConfig;
    private final FileSystemViewStorageConfig clientSpecifiedViewStorageConfig;
    private FileSystemViewStorageConfig viewStorageConfig;

    private HoodieWriteConfig(Properties props) {
        super(props);
        Properties newProps = new Properties();
        newProps.putAll((Map<?, ?>)props);
        this.consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().fromProperties(newProps).build();
        this.viewStorageConfig = this.clientSpecifiedViewStorageConfig = FileSystemViewStorageConfig.newBuilder().fromProperties(newProps).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getBasePath() {
        return this.props.getProperty(BASE_PATH_PROP);
    }

    public String getSchema() {
        return this.props.getProperty(AVRO_SCHEMA);
    }

    public void setSchema(String schemaStr) {
        this.props.setProperty(AVRO_SCHEMA, schemaStr);
    }

    public String getTableName() {
        return this.props.getProperty(TABLE_NAME);
    }

    public Boolean shouldAutoCommit() {
        return Boolean.parseBoolean(this.props.getProperty(HOODIE_AUTO_COMMIT_PROP));
    }

    public Boolean shouldAssumeDatePartitioning() {
        return Boolean.parseBoolean(this.props.getProperty(HOODIE_ASSUME_DATE_PARTITIONING_PROP));
    }

    public Integer getTimelineLayoutVersion() {
        return Integer.parseInt(this.props.getProperty(TIMELINE_LAYOUT_VERSION));
    }

    public int getBulkInsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(BULKINSERT_PARALLELISM));
    }

    public int getInsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(INSERT_PARALLELISM));
    }

    public int getUpsertShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(UPSERT_PARALLELISM));
    }

    public int getDeleteShuffleParallelism() {
        return Integer.parseInt(this.props.getProperty(DELETE_PARALLELISM));
    }

    public int getRollbackParallelism() {
        return Integer.parseInt(this.props.getProperty(ROLLBACK_PARALLELISM));
    }

    public int getWriteBufferLimitBytes() {
        return Integer.parseInt(this.props.getProperty(WRITE_BUFFER_LIMIT_BYTES, DEFAULT_WRITE_BUFFER_LIMIT_BYTES));
    }

    public boolean shouldCombineBeforeInsert() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_INSERT_PROP));
    }

    public boolean shouldCombineBeforeUpsert() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_UPSERT_PROP));
    }

    public boolean shouldCombineBeforeDelete() {
        return Boolean.parseBoolean(this.props.getProperty(COMBINE_BEFORE_DELETE_PROP));
    }

    public StorageLevel getWriteStatusStorageLevel() {
        return StorageLevel.fromString((String)this.props.getProperty(WRITE_STATUS_STORAGE_LEVEL));
    }

    public String getWriteStatusClassName() {
        return this.props.getProperty(HOODIE_WRITE_STATUS_CLASS_PROP);
    }

    public int getFinalizeWriteParallelism() {
        return Integer.parseInt(this.props.getProperty(FINALIZE_WRITE_PARALLELISM));
    }

    public boolean isEmbeddedTimelineServerEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(EMBEDDED_TIMELINE_SERVER_ENABLED));
    }

    public boolean isFailOnTimelineArchivingEnabled() {
        return Boolean.parseBoolean(this.props.getProperty(FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP));
    }

    public int getMaxConsistencyChecks() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECKS_PROP));
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return Integer.parseInt(this.props.getProperty(MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP));
    }

    public HoodieCleaningPolicy getCleanerPolicy() {
        return HoodieCleaningPolicy.valueOf(this.props.getProperty("hoodie.cleaner.policy"));
    }

    public int getCleanerFileVersionsRetained() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.fileversions.retained"));
    }

    public int getCleanerCommitsRetained() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.commits.retained"));
    }

    public int getMaxCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.keep.max.commits"));
    }

    public int getMinCommitsToKeep() {
        return Integer.parseInt(this.props.getProperty("hoodie.keep.min.commits"));
    }

    public int getParquetSmallFileLimit() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.small.file.limit"));
    }

    public int getCopyOnWriteInsertSplitSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.copyonwrite.insert.split.size"));
    }

    public int getCopyOnWriteRecordSizeEstimate() {
        return Integer.parseInt(this.props.getProperty("hoodie.copyonwrite.record.size.estimate"));
    }

    public boolean shouldAutoTuneInsertSplits() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.copyonwrite.insert.auto.split"));
    }

    public int getCleanerParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.cleaner.parallelism"));
    }

    public boolean isAutoClean() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.clean.automatic"));
    }

    public boolean incrementalCleanerModeEnabled() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.cleaner.incremental.mode"));
    }

    public boolean isInlineCompaction() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.compact.inline"));
    }

    public int getInlineCompactDeltaCommitMax() {
        return Integer.parseInt(this.props.getProperty("hoodie.compact.inline.max.delta.commits"));
    }

    public CompactionStrategy getCompactionStrategy() {
        return (CompactionStrategy)ReflectionUtils.loadClass(this.props.getProperty("hoodie.compaction.strategy"));
    }

    public Long getTargetIOPerCompactionInMB() {
        return Long.parseLong(this.props.getProperty("hoodie.compaction.target.io"));
    }

    public Boolean getCompactionLazyBlockReadEnabled() {
        return Boolean.valueOf(this.props.getProperty("hoodie.compaction.lazy.block.read"));
    }

    public Boolean getCompactionReverseLogReadEnabled() {
        return Boolean.valueOf(this.props.getProperty("hoodie.compaction.reverse.log.read"));
    }

    public String getPayloadClass() {
        return this.props.getProperty("hoodie.compaction.payload.class");
    }

    public int getTargetPartitionsPerDayBasedCompaction() {
        return Integer.parseInt(this.props.getProperty("hoodie.compaction.daybased.target.partitions"));
    }

    public int getCommitArchivalBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.commits.archival.batch"));
    }

    public HoodieIndex.IndexType getIndexType() {
        return HoodieIndex.IndexType.valueOf(this.props.getProperty("hoodie.index.type"));
    }

    public int getBloomFilterNumEntries() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.bloom.num_entries"));
    }

    public double getBloomFilterFPP() {
        return Double.parseDouble(this.props.getProperty("hoodie.index.bloom.fpp"));
    }

    public String getHbaseZkQuorum() {
        return this.props.getProperty("hoodie.index.hbase.zkquorum");
    }

    public int getHbaseZkPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.zkport"));
    }

    public String getHBaseZkZnodeParent() {
        return this.props.getProperty("hoodie.index.hbase.zknode.path");
    }

    public String getHbaseTableName() {
        return this.props.getProperty("hoodie.index.hbase.table");
    }

    public int getHbaseIndexGetBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.get.batch.size"));
    }

    public int getHbaseIndexPutBatchSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.put.batch.size"));
    }

    public Boolean getHbaseIndexPutBatchSizeAutoCompute() {
        return Boolean.valueOf(this.props.getProperty("hoodie.index.hbase.put.batch.size.autocompute"));
    }

    public String getHBaseQPSResourceAllocatorClass() {
        return this.props.getProperty("hoodie.index.hbase.qps.allocator.class");
    }

    public String getHBaseQPSZKnodePath() {
        return this.props.getProperty("hoodie.index.hbase.zkpath.qps_root");
    }

    public String getHBaseZkZnodeSessionTimeout() {
        return this.props.getProperty("hoodie.index.hbase.zk.session_timeout_ms");
    }

    public String getHBaseZkZnodeConnectionTimeout() {
        return this.props.getProperty("hoodie.index.hbase.zk.connection_timeout_ms");
    }

    public boolean getHBaseIndexShouldComputeQPSDynamically() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.index.hbase.dynamic_qps"));
    }

    public int getHBaseIndexDesiredPutsTime() {
        return Integer.parseInt(this.props.getProperty("hoodie.index.hbase.desired_puts_time_in_secs"));
    }

    public String getBloomFilterType() {
        return this.props.getProperty("hoodie.bloom.index.filter.type");
    }

    public int getDynamicBloomFilterMaxNumEntries() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.filter.dynamic.max.entries"));
    }

    public float getHbaseIndexQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.qps.fraction"));
    }

    public float getHBaseIndexMinQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.min.qps.fraction"));
    }

    public float getHBaseIndexMaxQPSFraction() {
        return Float.parseFloat(this.props.getProperty("hoodie.index.hbase.max.qps.fraction"));
    }

    public int getHbaseIndexMaxQPSPerRegionServer() {
        return Integer.parseInt(this.props.getProperty(HoodieHBaseIndexConfig.HBASE_MAX_QPS_PER_REGION_SERVER_PROP));
    }

    public int getBloomIndexParallelism() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.parallelism"));
    }

    public boolean getBloomIndexPruneByRanges() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.prune.by.ranges"));
    }

    public boolean getBloomIndexUseCaching() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.use.caching"));
    }

    public boolean useBloomIndexTreebasedFilter() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.use.treebased.filter"));
    }

    public boolean useBloomIndexBucketizedChecking() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.bloom.index.bucketized.checking"));
    }

    public int getBloomIndexKeysPerBucket() {
        return Integer.parseInt(this.props.getProperty("hoodie.bloom.index.keys.per.bucket"));
    }

    public StorageLevel getBloomIndexInputStorageLevel() {
        return StorageLevel.fromString((String)this.props.getProperty("hoodie.bloom.index.input.storage.level"));
    }

    public long getParquetMaxFileSize() {
        return Long.parseLong(this.props.getProperty("hoodie.parquet.max.file.size"));
    }

    public int getParquetBlockSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.block.size"));
    }

    public int getParquetPageSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.parquet.page.size"));
    }

    public int getLogFileDataBlockMaxSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.logfile.data.block.max.size"));
    }

    public int getLogFileMaxSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.logfile.max.size"));
    }

    public double getParquetCompressionRatio() {
        return Double.parseDouble(this.props.getProperty("hoodie.parquet.compression.ratio"));
    }

    public CompressionCodecName getParquetCompressionCodec() {
        return CompressionCodecName.fromConf((String)this.props.getProperty("hoodie.parquet.compression.codec"));
    }

    public double getLogFileToParquetCompressionRatio() {
        return Double.parseDouble(this.props.getProperty("hoodie.logfile.to.parquet.compression.ratio"));
    }

    public boolean isMetricsOn() {
        return Boolean.parseBoolean(this.props.getProperty("hoodie.metrics.on"));
    }

    public MetricsReporterType getMetricsReporterType() {
        return MetricsReporterType.valueOf(this.props.getProperty("hoodie.metrics.reporter.type"));
    }

    public String getGraphiteServerHost() {
        return this.props.getProperty("hoodie.metrics.graphite.host");
    }

    public int getGraphiteServerPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.graphite.port"));
    }

    public String getGraphiteMetricPrefix() {
        return this.props.getProperty("hoodie.metrics.graphite.metric.prefix");
    }

    public String getJmxHost() {
        return this.props.getProperty("hoodie.metrics.jmx.host");
    }

    public int getJmxPort() {
        return Integer.parseInt(this.props.getProperty("hoodie.metrics.jmx.port"));
    }

    public Double getMaxMemoryFractionPerPartitionMerge() {
        return Double.valueOf(this.props.getProperty("hoodie.memory.merge.fraction"));
    }

    public Double getMaxMemoryFractionPerCompaction() {
        return Double.valueOf(this.props.getProperty("hoodie.memory.compaction.fraction"));
    }

    public Long getMaxMemoryPerPartitionMerge() {
        return Long.valueOf(this.props.getProperty("hoodie.memory.merge.max.size"));
    }

    public Long getMaxMemoryPerCompaction() {
        return Long.valueOf(this.props.getProperty("hoodie.memory.compaction.max.size"));
    }

    public int getMaxDFSStreamBufferSize() {
        return Integer.parseInt(this.props.getProperty("hoodie.memory.dfs.buffer.max.size"));
    }

    public String getSpillableMapBasePath() {
        return this.props.getProperty("hoodie.memory.spillable.map.path");
    }

    public double getWriteStatusFailureFraction() {
        return Double.parseDouble(this.props.getProperty("hoodie.memory.writestatus.failure.fraction"));
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public void setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
        this.consistencyGuardConfig = consistencyGuardConfig;
    }

    public FileSystemViewStorageConfig getViewStorageConfig() {
        return this.viewStorageConfig;
    }

    public void setViewStorageConfig(FileSystemViewStorageConfig viewStorageConfig) {
        this.viewStorageConfig = viewStorageConfig;
    }

    public void resetViewStorageConfig() {
        this.setViewStorageConfig(this.getClientSpecifiedViewStorageConfig());
    }

    public FileSystemViewStorageConfig getClientSpecifiedViewStorageConfig() {
        return this.clientSpecifiedViewStorageConfig;
    }

    public static class Builder {
        private final Properties props = new Properties();
        private boolean isIndexConfigSet = false;
        private boolean isStorageConfigSet = false;
        private boolean isCompactionConfigSet = false;
        private boolean isMetricsConfigSet = false;
        private boolean isMemoryConfigSet = false;
        private boolean isViewConfigSet = false;
        private boolean isConsistencyGuardSet = false;

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.props.load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromInputStream(InputStream inputStream) throws IOException {
            try {
                this.props.load(inputStream);
                Builder builder = this;
                return builder;
            }
            finally {
                inputStream.close();
            }
        }

        public Builder withProps(Map kvprops) {
            this.props.putAll((Map<?, ?>)kvprops);
            return this;
        }

        public Builder withPath(String basePath) {
            this.props.setProperty(HoodieWriteConfig.BASE_PATH_PROP, basePath);
            return this;
        }

        public Builder withSchema(String schemaStr) {
            this.props.setProperty(HoodieWriteConfig.AVRO_SCHEMA, schemaStr);
            return this;
        }

        public Builder forTable(String tableName) {
            this.props.setProperty(HoodieWriteConfig.TABLE_NAME, tableName);
            return this;
        }

        public Builder withTimelineLayoutVersion(int version) {
            this.props.setProperty(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(version));
            return this;
        }

        public Builder withBulkInsertParallelism(int bulkInsertParallelism) {
            this.props.setProperty(HoodieWriteConfig.BULKINSERT_PARALLELISM, String.valueOf(bulkInsertParallelism));
            return this;
        }

        public Builder withParallelism(int insertShuffleParallelism, int upsertShuffleParallelism) {
            this.props.setProperty(HoodieWriteConfig.INSERT_PARALLELISM, String.valueOf(insertShuffleParallelism));
            this.props.setProperty(HoodieWriteConfig.UPSERT_PARALLELISM, String.valueOf(upsertShuffleParallelism));
            return this;
        }

        public Builder withRollbackParallelism(int rollbackParallelism) {
            this.props.setProperty(HoodieWriteConfig.ROLLBACK_PARALLELISM, String.valueOf(rollbackParallelism));
            return this;
        }

        public Builder withWriteBufferLimitBytes(int writeBufferLimit) {
            this.props.setProperty(HoodieWriteConfig.WRITE_BUFFER_LIMIT_BYTES, String.valueOf(writeBufferLimit));
            return this;
        }

        public Builder combineInput(boolean onInsert, boolean onUpsert) {
            this.props.setProperty(HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP, String.valueOf(onInsert));
            this.props.setProperty(HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP, String.valueOf(onUpsert));
            return this;
        }

        public Builder withWriteStatusStorageLevel(String level) {
            this.props.setProperty(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL, level);
            return this;
        }

        public Builder withIndexConfig(HoodieIndexConfig indexConfig) {
            this.props.putAll((Map<?, ?>)indexConfig.getProps());
            this.isIndexConfigSet = true;
            return this;
        }

        public Builder withStorageConfig(HoodieStorageConfig storageConfig) {
            this.props.putAll((Map<?, ?>)storageConfig.getProps());
            this.isStorageConfigSet = true;
            return this;
        }

        public Builder withCompactionConfig(HoodieCompactionConfig compactionConfig) {
            this.props.putAll((Map<?, ?>)compactionConfig.getProps());
            this.isCompactionConfigSet = true;
            return this;
        }

        public Builder withMetricsConfig(HoodieMetricsConfig metricsConfig) {
            this.props.putAll((Map<?, ?>)metricsConfig.getProps());
            this.isMetricsConfigSet = true;
            return this;
        }

        public Builder withMemoryConfig(HoodieMemoryConfig memoryConfig) {
            this.props.putAll((Map<?, ?>)memoryConfig.getProps());
            this.isMemoryConfigSet = true;
            return this;
        }

        public Builder withAutoCommit(boolean autoCommit) {
            this.props.setProperty(HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP, String.valueOf(autoCommit));
            return this;
        }

        public Builder withAssumeDatePartitioning(boolean assumeDatePartitioning) {
            this.props.setProperty(HoodieWriteConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP, String.valueOf(assumeDatePartitioning));
            return this;
        }

        public Builder withWriteStatusClass(Class<? extends WriteStatus> writeStatusClass) {
            this.props.setProperty(HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP, writeStatusClass.getName());
            return this;
        }

        public Builder withFileSystemViewConfig(FileSystemViewStorageConfig viewStorageConfig) {
            this.props.putAll((Map<?, ?>)viewStorageConfig.getProps());
            this.isViewConfigSet = true;
            return this;
        }

        public Builder withConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.props.putAll((Map<?, ?>)consistencyGuardConfig.getProps());
            this.isConsistencyGuardSet = true;
            return this;
        }

        public Builder withFinalizeWriteParallelism(int parallelism) {
            this.props.setProperty(HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM, String.valueOf(parallelism));
            return this;
        }

        public Builder withEmbeddedTimelineServerEnabled(boolean enabled) {
            this.props.setProperty(HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED, String.valueOf(enabled));
            return this;
        }

        public HoodieWriteConfig build() {
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.INSERT_PARALLELISM), HoodieWriteConfig.INSERT_PARALLELISM, "1500");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.BULKINSERT_PARALLELISM), HoodieWriteConfig.BULKINSERT_PARALLELISM, "1500");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.UPSERT_PARALLELISM), HoodieWriteConfig.UPSERT_PARALLELISM, "1500");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.DELETE_PARALLELISM), HoodieWriteConfig.DELETE_PARALLELISM, "1500");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.ROLLBACK_PARALLELISM), HoodieWriteConfig.ROLLBACK_PARALLELISM, HoodieWriteConfig.DEFAULT_ROLLBACK_PARALLELISM);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP), HoodieWriteConfig.COMBINE_BEFORE_INSERT_PROP, "false");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP), HoodieWriteConfig.COMBINE_BEFORE_UPSERT_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.COMBINE_BEFORE_DELETE_PROP), HoodieWriteConfig.COMBINE_BEFORE_DELETE_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL), HoodieWriteConfig.WRITE_STATUS_STORAGE_LEVEL, HoodieWriteConfig.DEFAULT_WRITE_STATUS_STORAGE_LEVEL);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP), HoodieWriteConfig.HOODIE_AUTO_COMMIT_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP), HoodieWriteConfig.HOODIE_ASSUME_DATE_PARTITIONING_PROP, "false");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP), HoodieWriteConfig.HOODIE_WRITE_STATUS_CLASS_PROP, DEFAULT_HOODIE_WRITE_STATUS_CLASS);
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM), HoodieWriteConfig.FINALIZE_WRITE_PARALLELISM, "1500");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED), HoodieWriteConfig.EMBEDDED_TIMELINE_SERVER_ENABLED, "false");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP), HoodieWriteConfig.INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP), HoodieWriteConfig.MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP, String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.MAX_CONSISTENCY_CHECKS_PROP), HoodieWriteConfig.MAX_CONSISTENCY_CHECKS_PROP, String.valueOf(DEFAULT_MAX_CONSISTENCY_CHECKS));
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP), HoodieWriteConfig.FAIL_ON_TIMELINE_ARCHIVING_ENABLED_PROP, "true");
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isIndexConfigSet, HoodieIndexConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isStorageConfigSet, HoodieStorageConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isCompactionConfigSet, HoodieCompactionConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isMetricsConfigSet, HoodieMetricsConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isMemoryConfigSet, HoodieMemoryConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isViewConfigSet, FileSystemViewStorageConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.isConsistencyGuardSet, ConsistencyGuardConfig.newBuilder().fromProperties(this.props).build());
            DefaultHoodieConfig.setDefaultOnCondition(this.props, !this.props.containsKey(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION), HoodieWriteConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(TimelineLayoutVersion.CURR_VERSION));
            String layoutVersion = this.props.getProperty(HoodieWriteConfig.TIMELINE_LAYOUT_VERSION);
            new TimelineLayoutVersion(Integer.parseInt(layoutVersion));
            HoodieWriteConfig config = new HoodieWriteConfig(this.props);
            Preconditions.checkArgument((config.getBasePath() != null ? 1 : 0) != 0);
            return config;
        }
    }
}

