/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.func;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.func.CopyOnWriteLazyInsertIterable;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.table.HoodieTable;

public class MergeOnReadLazyInsertIterable<T extends HoodieRecordPayload>
extends CopyOnWriteLazyInsertIterable<T> {
    public MergeOnReadLazyInsertIterable(Iterator<HoodieRecord<T>> sortedRecordItr, HoodieWriteConfig config, String commitTime, HoodieTable<T> hoodieTable, String idPfx) {
        super(sortedRecordItr, config, commitTime, hoodieTable, idPfx);
    }

    @Override
    protected CopyOnWriteLazyInsertIterable.CopyOnWriteInsertHandler getInsertHandler() {
        return new MergeOnReadInsertHandler();
    }

    protected class MergeOnReadInsertHandler
    extends CopyOnWriteLazyInsertIterable.CopyOnWriteInsertHandler {
        protected MergeOnReadInsertHandler() {
        }

        @Override
        protected void consumeOneRecord(CopyOnWriteLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> payload) {
            Object insertPayload = payload.record;
            ArrayList<WriteStatus> statuses = new ArrayList<WriteStatus>();
            if (this.handle == null) {
                this.handle = new HoodieAppendHandle(MergeOnReadLazyInsertIterable.this.hoodieConfig, MergeOnReadLazyInsertIterable.this.commitTime, MergeOnReadLazyInsertIterable.this.hoodieTable, MergeOnReadLazyInsertIterable.this.getNextFileId(MergeOnReadLazyInsertIterable.this.idPrefix));
            }
            if (this.handle.canWrite((HoodieRecord)insertPayload)) {
                this.handle.write((HoodieRecord)insertPayload, payload.insertValue, payload.exception);
            } else {
                this.handle.close();
                statuses.add(this.handle.getWriteStatus());
                this.handle = new HoodieAppendHandle(MergeOnReadLazyInsertIterable.this.hoodieConfig, MergeOnReadLazyInsertIterable.this.commitTime, MergeOnReadLazyInsertIterable.this.hoodieTable, MergeOnReadLazyInsertIterable.this.getNextFileId(MergeOnReadLazyInsertIterable.this.idPrefix));
                this.handle.write((HoodieRecord)insertPayload, payload.insertValue, payload.exception);
            }
        }
    }
}

