/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.parquet.schema.MessageType;

public class SchemaDifference {
    private final MessageType storageSchema;
    private final Map<String, String> tableSchema;
    private final List<String> deleteColumns;
    private final Map<String, String> updateColumnTypes;
    private final Map<String, String> addColumnTypes;

    private SchemaDifference(MessageType storageSchema, Map<String, String> tableSchema, List<String> deleteColumns, Map<String, String> updateColumnTypes, Map<String, String> addColumnTypes) {
        this.storageSchema = storageSchema;
        this.tableSchema = tableSchema;
        this.deleteColumns = ImmutableList.copyOf(deleteColumns);
        this.updateColumnTypes = ImmutableMap.copyOf(updateColumnTypes);
        this.addColumnTypes = ImmutableMap.copyOf(addColumnTypes);
    }

    public List<String> getDeleteColumns() {
        return this.deleteColumns;
    }

    public Map<String, String> getUpdateColumnTypes() {
        return this.updateColumnTypes;
    }

    public Map<String, String> getAddColumnTypes() {
        return this.addColumnTypes;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("deleteColumns", this.deleteColumns).add("updateColumnTypes", this.updateColumnTypes).add("addColumnTypes", this.addColumnTypes).toString();
    }

    public static Builder newBuilder(MessageType storageSchema, Map<String, String> tableSchema) {
        return new Builder(storageSchema, tableSchema);
    }

    public boolean isEmpty() {
        return this.deleteColumns.isEmpty() && this.updateColumnTypes.isEmpty() && this.addColumnTypes.isEmpty();
    }

    public static class Builder {
        private final MessageType storageSchema;
        private final Map<String, String> tableSchema;
        private List<String> deleteColumns;
        private Map<String, String> updateColumnTypes;
        private Map<String, String> addColumnTypes;

        public Builder(MessageType storageSchema, Map<String, String> tableSchema) {
            this.storageSchema = storageSchema;
            this.tableSchema = tableSchema;
            this.deleteColumns = Lists.newArrayList();
            this.updateColumnTypes = Maps.newHashMap();
            this.addColumnTypes = Maps.newHashMap();
        }

        public Builder deleteTableColumn(String column) {
            this.deleteColumns.add(column);
            return this;
        }

        public Builder updateTableColumn(String column, String storageColumnType) {
            this.updateColumnTypes.put(column, storageColumnType);
            return this;
        }

        public Builder addTableColumn(String name, String type) {
            this.addColumnTypes.put(name, type);
            return this;
        }

        public SchemaDifference build() {
            return new SchemaDifference(this.storageSchema, this.tableSchema, this.deleteColumns, this.updateColumnTypes, this.addColumnTypes);
        }
    }
}

