/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.Serializable;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.InMemoryHashIndex;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.HoodieGlobalBloomIndex;
import org.apache.hudi.index.hbase.HBaseIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public abstract class HoodieIndex<T extends HoodieRecordPayload>
implements Serializable {
    protected final HoodieWriteConfig config;

    protected HoodieIndex(HoodieWriteConfig config) {
        this.config = config;
    }

    public static <T extends HoodieRecordPayload> HoodieIndex<T> createIndex(HoodieWriteConfig config, JavaSparkContext jsc) throws HoodieIndexException {
        switch (config.getIndexType()) {
            case HBASE: {
                return new HBaseIndex(config);
            }
            case INMEMORY: {
                return new InMemoryHashIndex(config);
            }
            case BLOOM: {
                return new HoodieBloomIndex(config);
            }
            case GLOBAL_BLOOM: {
                return new HoodieGlobalBloomIndex(config);
            }
        }
        throw new HoodieIndexException("Index type unspecified, set " + (Object)((Object)config.getIndexType()));
    }

    public abstract JavaPairRDD<HoodieKey, Option<Pair<String, String>>> fetchRecordLocation(JavaRDD<HoodieKey> var1, JavaSparkContext var2, HoodieTable<T> var3);

    public abstract JavaRDD<HoodieRecord<T>> tagLocation(JavaRDD<HoodieRecord<T>> var1, JavaSparkContext var2, HoodieTable<T> var3) throws HoodieIndexException;

    public abstract JavaRDD<WriteStatus> updateLocation(JavaRDD<WriteStatus> var1, JavaSparkContext var2, HoodieTable<T> var3) throws HoodieIndexException;

    public abstract boolean rollbackCommit(String var1);

    public abstract boolean isGlobal();

    public abstract boolean canIndexLogFiles();

    public abstract boolean isImplicitWithStorage();

    public void close() {
    }

    public static enum IndexType {
        HBASE,
        INMEMORY,
        BLOOM,
        GLOBAL_BLOOM;

    }
}

