/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;

public class InMemoryHashIndex<T extends HoodieRecordPayload>
extends HoodieIndex<T> {
    private static ConcurrentMap<HoodieKey, HoodieRecordLocation> recordLocationMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InMemoryHashIndex(HoodieWriteConfig config) {
        super(config);
        Class<InMemoryHashIndex> clazz = InMemoryHashIndex.class;
        synchronized (InMemoryHashIndex.class) {
            if (recordLocationMap == null) {
                recordLocationMap = new ConcurrentHashMap<HoodieKey, HoodieRecordLocation>();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public JavaPairRDD<HoodieKey, Option<Pair<String, String>>> fetchRecordLocation(JavaRDD<HoodieKey> hoodieKeys, JavaSparkContext jsc, HoodieTable<T> hoodieTable) {
        throw new UnsupportedOperationException("InMemory index does not implement check exist yet");
    }

    @Override
    public JavaRDD<HoodieRecord<T>> tagLocation(JavaRDD<HoodieRecord<T>> recordRDD, JavaSparkContext jsc, HoodieTable<T> hoodieTable) {
        return recordRDD.mapPartitionsWithIndex((Function2)new LocationTagFunction(), true);
    }

    @Override
    public JavaRDD<WriteStatus> updateLocation(JavaRDD<WriteStatus> writeStatusRDD, JavaSparkContext jsc, HoodieTable<T> hoodieTable) {
        return writeStatusRDD.map((Function)new Function<WriteStatus, WriteStatus>(){

            public WriteStatus call(WriteStatus writeStatus) {
                for (HoodieRecord record : writeStatus.getWrittenRecords()) {
                    if (writeStatus.isErrored(record.getKey())) continue;
                    HoodieKey key = record.getKey();
                    Option<HoodieRecordLocation> newLocation = record.getNewLocation();
                    if (newLocation.isPresent()) {
                        recordLocationMap.put(key, newLocation.get());
                        continue;
                    }
                    recordLocationMap.remove(key);
                }
                return writeStatus;
            }
        });
    }

    @Override
    public boolean rollbackCommit(String commitTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean canIndexLogFiles() {
        return true;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return false;
    }

    class LocationTagFunction
    implements Function2<Integer, Iterator<HoodieRecord<T>>, Iterator<HoodieRecord<T>>> {
        LocationTagFunction() {
        }

        public Iterator<HoodieRecord<T>> call(Integer partitionNum, Iterator<HoodieRecord<T>> hoodieRecordIterator) {
            ArrayList taggedRecords = new ArrayList();
            while (hoodieRecordIterator.hasNext()) {
                HoodieRecord rec = hoodieRecordIterator.next();
                if (recordLocationMap.containsKey(rec.getKey())) {
                    rec.unseal();
                    rec.setCurrentLocation((HoodieRecordLocation)recordLocationMap.get(rec.getKey()));
                    rec.seal();
                }
                taggedRecords.add(rec);
            }
            return taggedRecords.iterator();
        }
    }
}

