/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import com.google.common.base.Objects;
import java.io.Serializable;

public class BloomIndexFileInfo
implements Serializable {
    private final String fileId;
    private final String minRecordKey;
    private final String maxRecordKey;

    public BloomIndexFileInfo(String fileId, String minRecordKey, String maxRecordKey) {
        this.fileId = fileId;
        this.minRecordKey = minRecordKey;
        this.maxRecordKey = maxRecordKey;
    }

    public BloomIndexFileInfo(String fileId) {
        this.fileId = fileId;
        this.minRecordKey = null;
        this.maxRecordKey = null;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getMinRecordKey() {
        return this.minRecordKey;
    }

    public String getMaxRecordKey() {
        return this.maxRecordKey;
    }

    public boolean hasKeyRanges() {
        return this.minRecordKey != null && this.maxRecordKey != null;
    }

    public boolean isKeyInRange(String recordKey) {
        assert (this.minRecordKey != null);
        assert (this.maxRecordKey != null);
        return this.minRecordKey.compareTo(recordKey) <= 0 && this.maxRecordKey.compareTo(recordKey) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomIndexFileInfo that = (BloomIndexFileInfo)o;
        return Objects.equal((Object)that.fileId, (Object)this.fileId) && Objects.equal((Object)that.minRecordKey, (Object)this.minRecordKey) && Objects.equal((Object)that.maxRecordKey, (Object)this.maxRecordKey);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fileId, this.minRecordKey, this.maxRecordKey});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BloomIndexFileInfo {");
        sb.append(" fileId=").append(this.fileId);
        sb.append(" minRecordKey=").append(this.minRecordKey);
        sb.append(" maxRecordKey=").append(this.maxRecordKey);
        sb.append('}');
        return sb.toString();
    }
}

