/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.func.LazyIterableIterator;
import org.apache.hudi.io.HoodieKeyLookupHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.function.Function2;
import scala.Tuple2;

public class HoodieBloomIndexCheckFunction
implements Function2<Integer, Iterator<Tuple2<String, HoodieKey>>, Iterator<List<HoodieKeyLookupHandle.KeyLookupResult>>> {
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig config;

    public HoodieBloomIndexCheckFunction(HoodieTable hoodieTable, HoodieWriteConfig config) {
        this.hoodieTable = hoodieTable;
        this.config = config;
    }

    public Iterator<List<HoodieKeyLookupHandle.KeyLookupResult>> call(Integer partition, Iterator<Tuple2<String, HoodieKey>> fileParitionRecordKeyTripletItr) {
        return new LazyKeyCheckIterator(fileParitionRecordKeyTripletItr);
    }

    class LazyKeyCheckIterator
    extends LazyIterableIterator<Tuple2<String, HoodieKey>, List<HoodieKeyLookupHandle.KeyLookupResult>> {
        private HoodieKeyLookupHandle keyLookupHandle;

        LazyKeyCheckIterator(Iterator<Tuple2<String, HoodieKey>> filePartitionRecordKeyTripletItr) {
            super(filePartitionRecordKeyTripletItr);
        }

        @Override
        protected void start() {
        }

        @Override
        protected List<HoodieKeyLookupHandle.KeyLookupResult> computeNext() {
            ArrayList<HoodieKeyLookupHandle.KeyLookupResult> ret = new ArrayList<HoodieKeyLookupHandle.KeyLookupResult>();
            try {
                while (this.inputItr.hasNext()) {
                    Tuple2 currentTuple = (Tuple2)this.inputItr.next();
                    String fileId = (String)currentTuple._1;
                    String partitionPath = ((HoodieKey)currentTuple._2).getPartitionPath();
                    String recordKey = ((HoodieKey)currentTuple._2).getRecordKey();
                    Pair<String, String> partitionPathFilePair = Pair.of(partitionPath, fileId);
                    if (this.keyLookupHandle == null) {
                        this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBloomIndexCheckFunction.this.config, HoodieBloomIndexCheckFunction.this.hoodieTable, partitionPathFilePair);
                    }
                    if (this.keyLookupHandle.getPartitionPathFilePair().equals(partitionPathFilePair)) {
                        this.keyLookupHandle.addKey(recordKey);
                        continue;
                    }
                    ret.add(this.keyLookupHandle.getLookupResult());
                    this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBloomIndexCheckFunction.this.config, HoodieBloomIndexCheckFunction.this.hoodieTable, partitionPathFilePair);
                    this.keyLookupHandle.addKey(recordKey);
                    break;
                }
                if (!this.inputItr.hasNext()) {
                    ret.add(this.keyLookupHandle.getLookupResult());
                }
            }
            catch (Throwable e) {
                if (e instanceof HoodieException) {
                    throw e;
                }
                throw new HoodieIndexException("Error checking bloom filter index. ", e);
            }
            return ret;
        }

        @Override
        protected void end() {
        }
    }
}

