/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedGlobalIndexFileFilter;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class HoodieGlobalBloomIndex<T extends HoodieRecordPayload>
extends HoodieBloomIndex<T> {
    public HoodieGlobalBloomIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    @VisibleForTesting
    List<Tuple2<String, BloomIndexFileInfo>> loadInvolvedFiles(List<String> partitions, JavaSparkContext jsc, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        try {
            List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(metaClient.getFs(), metaClient.getBasePath(), this.config.shouldAssumeDatePartitioning());
            return super.loadInvolvedFiles(allPartitionPaths, jsc, hoodieTable);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to load all partitions", e);
        }
    }

    @Override
    @VisibleForTesting
    JavaRDD<Tuple2<String, HoodieKey>> explodeRecordRDDWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, JavaPairRDD<String, String> partitionRecordKeyPairRDD) {
        IndexFileFilter indexFileFilter = this.config.getBloomIndexPruneByRanges() ? new IntervalTreeBasedGlobalIndexFileFilter(partitionToFileIndexInfo) : new ListBasedGlobalIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairRDD.map((Function & Serializable)partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair._2();
            String partitionPath = (String)partitionRecordKeyPair._1();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new Tuple2(partitionFileIdPair.getRight(), (Object)new HoodieKey(recordKey, (String)partitionFileIdPair.getLeft()))).collect(Collectors.toList());
        }).flatMap(List::iterator);
    }

    @Override
    protected JavaRDD<HoodieRecord<T>> tagLocationBacktoRecords(JavaPairRDD<HoodieKey, HoodieRecordLocation> keyLocationPairRDD, JavaRDD<HoodieRecord<T>> recordRDD) {
        JavaPairRDD incomingRowKeyRecordPairRDD = recordRDD.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)record.getRecordKey(), record));
        JavaPairRDD existingRecordKeyToRecordLocationHoodieKeyMap = keyLocationPairRDD.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)((HoodieKey)p._1).getRecordKey(), (Object)new Tuple2(p._2, p._1)));
        return incomingRowKeyRecordPairRDD.leftOuterJoin(existingRecordKeyToRecordLocationHoodieKeyMap).values().map((Function & Serializable)record -> {
            HoodieRecord hoodieRecord = (HoodieRecord)record._1;
            Optional recordLocationHoodieKeyPair = (Optional)record._2;
            if (recordLocationHoodieKeyPair.isPresent()) {
                return this.getTaggedRecord(new HoodieRecord((HoodieKey)((Tuple2)recordLocationHoodieKeyPair.get())._2, hoodieRecord.getData()), Option.ofNullable(((Tuple2)recordLocationHoodieKeyPair.get())._1));
            }
            return this.getTaggedRecord(hoodieRecord, Option.empty());
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

