/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.storage.HoodieStorageWriter;
import org.apache.hudi.io.storage.HoodieStorageWriterFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;

public class HoodieCreateHandle<T extends HoodieRecordPayload>
extends HoodieWriteHandle<T> {
    private static final Logger LOG = LogManager.getLogger(HoodieCreateHandle.class);
    private final HoodieStorageWriter<IndexedRecord> storageWriter;
    private final Path path;
    private long recordsWritten = 0L;
    private long insertRecordsWritten = 0L;
    private long recordsDeleted = 0L;
    private Iterator<HoodieRecord<T>> recordIterator;
    private boolean useWriterSchema = false;

    public HoodieCreateHandle(HoodieWriteConfig config, String commitTime, HoodieTable<T> hoodieTable, String partitionPath, String fileId) {
        super(config, commitTime, fileId, hoodieTable);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.path = this.makeNewPath(partitionPath);
        try {
            HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.fs, commitTime, new Path(config.getBasePath()), FSUtils.getPartitionPath(config.getBasePath(), partitionPath));
            partitionMetadata.trySave(TaskContext.getPartitionId());
            this.createMarkerFile(partitionPath);
            this.storageWriter = HoodieStorageWriterFactory.getStorageWriter(commitTime, this.path, hoodieTable, config, this.writerSchema);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize HoodieStorageWriter for path " + this.path, e);
        }
        LOG.info((Object)("New CreateHandle for partition :" + partitionPath + " with fileId " + fileId));
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String commitTime, HoodieTable<T> hoodieTable, String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordIterator) {
        this(config, commitTime, hoodieTable, partitionPath, fileId);
        this.recordIterator = recordIterator;
        this.useWriterSchema = true;
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return this.storageWriter.canWrite() && record.getPartitionPath().equals(this.writeStatus.getPartitionPath());
    }

    @Override
    public void write(HoodieRecord record, Option<IndexedRecord> avroRecord) {
        Option<Map<String, String>> recordMetadata = record.getData().getMetadata();
        try {
            if (avroRecord.isPresent()) {
                GenericRecord recordWithMetadataInSchema = this.rewriteRecord((GenericRecord)avroRecord.get());
                this.storageWriter.writeAvroWithMetadata((IndexedRecord)recordWithMetadataInSchema, record);
                record.unseal();
                record.setNewLocation(new HoodieRecordLocation(this.instantTime, this.writeStatus.getFileId()));
                record.seal();
                ++this.recordsWritten;
                ++this.insertRecordsWritten;
            } else {
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(record, recordMetadata);
            record.deflate();
        }
        catch (Throwable t) {
            this.writeStatus.markFailure(record, t, recordMetadata);
            LOG.error((Object)("Error writing record " + record), t);
        }
    }

    public void write() {
        try {
            while (this.recordIterator.hasNext()) {
                HoodieRecord<T> record = this.recordIterator.next();
                if (this.useWriterSchema) {
                    this.write(record, record.getData().getInsertValue(this.writerSchema));
                    continue;
                }
                this.write(record, record.getData().getInsertValue(this.originalSchema));
            }
        }
        catch (IOException io) {
            throw new HoodieInsertException("Failed to insert records for path " + this.path, io);
        }
    }

    @Override
    public WriteStatus getWriteStatus() {
        return this.writeStatus;
    }

    @Override
    public WriteStatus close() {
        LOG.info((Object)("Closing the file " + this.writeStatus.getFileId() + " as we are done with all the records " + this.recordsWritten));
        try {
            this.storageWriter.close();
            HoodieWriteStat stat = new HoodieWriteStat();
            stat.setPartitionPath(this.writeStatus.getPartitionPath());
            stat.setNumWrites(this.recordsWritten);
            stat.setNumDeletes(this.recordsDeleted);
            stat.setNumInserts(this.insertRecordsWritten);
            stat.setPrevCommit("null");
            stat.setFileId(this.writeStatus.getFileId());
            stat.setPath(new Path(this.config.getBasePath()), this.path);
            long fileSizeInBytes = FSUtils.getFileSize(this.fs, this.path);
            stat.setTotalWriteBytes(fileSizeInBytes);
            stat.setFileSizeInBytes(fileSizeInBytes);
            stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalCreateTime(this.timer.endTimer());
            stat.setRuntimeStats(runtimeStats);
            this.writeStatus.setStat(stat);
            LOG.info((Object)String.format("CreateHandle for partitionPath %s fileID %s, took %d ms.", stat.getPartitionPath(), stat.getFileId(), runtimeStats.getTotalCreateTime()));
            return this.writeStatus;
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to close the Insert Handle for path " + this.path, e);
        }
    }
}

