/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.filter.BloomFilter;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.HoodieReadHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieKeyLookupHandle<T extends HoodieRecordPayload>
extends HoodieReadHandle<T> {
    private static final Logger LOG = LogManager.getLogger(HoodieKeyLookupHandle.class);
    private final HoodieTableType tableType;
    private final BloomFilter bloomFilter;
    private final List<String> candidateRecordKeys;
    private long totalKeysChecked;

    public HoodieKeyLookupHandle(HoodieWriteConfig config, HoodieTable<T> hoodieTable, Pair<String, String> partitionPathFilePair) {
        super(config, null, hoodieTable, partitionPathFilePair);
        this.tableType = hoodieTable.getMetaClient().getTableType();
        this.candidateRecordKeys = new ArrayList<String>();
        this.totalKeysChecked = 0L;
        HoodieTimer timer = new HoodieTimer().startTimer();
        this.bloomFilter = ParquetUtils.readBloomFilterFromParquetMetadata(hoodieTable.getHadoopConf(), new Path(this.getLatestDataFile().getPath()));
        LOG.info((Object)String.format("Read bloom filter from %s in %d ms", partitionPathFilePair, timer.endTimer()));
    }

    public static List<String> checkCandidatesAgainstFile(Configuration configuration, List<String> candidateRecordKeys, Path filePath) throws HoodieIndexException {
        ArrayList<String> foundRecordKeys = new ArrayList<String>();
        try {
            if (!candidateRecordKeys.isEmpty()) {
                HoodieTimer timer = new HoodieTimer().startTimer();
                Set<String> fileRowKeys = ParquetUtils.filterParquetRowKeys(configuration, filePath, new HashSet<String>(candidateRecordKeys));
                foundRecordKeys.addAll(fileRowKeys);
                LOG.info((Object)String.format("Checked keys against file %s, in %d ms. #candidates (%d) #found (%d)", filePath, timer.endTimer(), candidateRecordKeys.size(), foundRecordKeys.size()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Keys matching for file " + filePath + " => " + foundRecordKeys));
                }
            }
        }
        catch (Exception e) {
            throw new HoodieIndexException("Error checking candidate keys against file.", e);
        }
        return foundRecordKeys;
    }

    public void addKey(String recordKey) {
        if (this.bloomFilter.mightContain(recordKey)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Record key " + recordKey + " matches bloom filter in  " + this.partitionPathFilePair));
            }
            this.candidateRecordKeys.add(recordKey);
        }
        ++this.totalKeysChecked;
    }

    public KeyLookupResult getLookupResult() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("#The candidate row keys for " + this.partitionPathFilePair + " => " + this.candidateRecordKeys));
        }
        HoodieBaseFile dataFile = this.getLatestDataFile();
        List<String> matchingKeys = HoodieKeyLookupHandle.checkCandidatesAgainstFile(this.hoodieTable.getHadoopConf(), this.candidateRecordKeys, new Path(dataFile.getPath()));
        LOG.info((Object)String.format("Total records (%d), bloom filter candidates (%d)/fp(%d), actual matches (%d)", this.totalKeysChecked, this.candidateRecordKeys.size(), this.candidateRecordKeys.size() - matchingKeys.size(), matchingKeys.size()));
        return new KeyLookupResult((String)this.partitionPathFilePair.getRight(), (String)this.partitionPathFilePair.getLeft(), dataFile.getCommitTime(), matchingKeys);
    }

    public static class KeyLookupResult {
        private final String fileId;
        private final String baseInstantTime;
        private final List<String> matchingRecordKeys;
        private final String partitionPath;

        public KeyLookupResult(String fileId, String partitionPath, String baseInstantTime, List<String> matchingRecordKeys) {
            this.fileId = fileId;
            this.partitionPath = partitionPath;
            this.baseInstantTime = baseInstantTime;
            this.matchingRecordKeys = matchingRecordKeys;
        }

        public String getFileId() {
            return this.fileId;
        }

        public String getBaseInstantTime() {
            return this.baseInstantTime;
        }

        public String getPartitionPath() {
            return this.partitionPath;
        }

        public List<String> getMatchingRecordKeys() {
            return this.matchingRecordKeys;
        }
    }
}

