/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieReadHandle<T extends HoodieRecordPayload>
extends HoodieIOHandle {
    protected final Pair<String, String> partitionPathFilePair;

    public HoodieReadHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T> hoodieTable, Pair<String, String> partitionPathFilePair) {
        super(config, instantTime, hoodieTable);
        this.partitionPathFilePair = partitionPathFilePair;
    }

    @Override
    protected FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    public Pair<String, String> getPartitionPathFilePair() {
        return this.partitionPathFilePair;
    }

    public String getFileId() {
        return this.partitionPathFilePair.getRight();
    }

    protected HoodieBaseFile getLatestDataFile() {
        return this.hoodieTable.getBaseFileOnlyView().getLatestBaseFile(this.partitionPathFilePair.getLeft(), this.partitionPathFilePair.getRight()).get();
    }
}

