/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.TaskContext;

public abstract class HoodieWriteHandle<T extends HoodieRecordPayload>
extends HoodieIOHandle {
    private static final Logger LOG = LogManager.getLogger(HoodieWriteHandle.class);
    protected final Schema originalSchema;
    protected final Schema writerSchema;
    protected HoodieTimer timer;
    protected final WriteStatus writeStatus;
    protected final String fileId;
    protected final String writeToken;

    public HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String fileId, HoodieTable<T> hoodieTable) {
        super(config, instantTime, hoodieTable);
        this.fileId = fileId;
        this.writeToken = HoodieWriteHandle.makeSparkWriteToken();
        this.originalSchema = new Schema.Parser().parse(config.getSchema());
        this.writerSchema = HoodieWriteHandle.createHoodieWriteSchema(this.originalSchema);
        this.timer = new HoodieTimer().startTimer();
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass(config.getWriteStatusClassName(), !hoodieTable.getIndex().isImplicitWithStorage(), config.getWriteStatusFailureFraction());
    }

    private static String makeSparkWriteToken() {
        return FSUtils.makeWriteToken(TaskContext.getPartitionId(), TaskContext.get().stageId(), TaskContext.get().taskAttemptId());
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public Path makeNewPath(String partitionPath) {
        Path path = FSUtils.getPartitionPath(this.config.getBasePath(), partitionPath);
        try {
            this.fs.mkdirs(path);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new Path(path.toString(), FSUtils.makeDataFileName(this.instantTime, this.writeToken, this.fileId));
    }

    protected void createMarkerFile(String partitionPath) {
        Path markerPath = this.makeNewMarkerPath(partitionPath);
        try {
            LOG.info((Object)("Creating Marker Path=" + markerPath));
            this.fs.create(markerPath, false).close();
        }
        catch (IOException e) {
            throw new HoodieException("Failed to create marker file " + markerPath, e);
        }
    }

    private Path makeNewMarkerPath(String partitionPath) {
        Path markerRootPath = new Path(this.hoodieTable.getMetaClient().getMarkerFolderPath(this.instantTime));
        Path path = FSUtils.getPartitionPath(markerRootPath, partitionPath);
        try {
            this.fs.mkdirs(path);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new Path(path.toString(), FSUtils.makeMarkerFile(this.instantTime, this.writeToken, this.fileId));
    }

    public Schema getWriterSchema() {
        return this.writerSchema;
    }

    public boolean canWrite(HoodieRecord record) {
        return false;
    }

    public void write(HoodieRecord record, Option<IndexedRecord> insertValue) {
    }

    public void write(HoodieRecord record, Option<IndexedRecord> avroRecord, Option<Exception> exception) {
        Option<Map<String, String>> recordMetadata = record.getData().getMetadata();
        if (exception.isPresent() && exception.get() instanceof Throwable) {
            this.writeStatus.markFailure(record, exception.get(), recordMetadata);
            LOG.error((Object)("Error writing record " + record), (Throwable)exception.get());
        } else {
            this.write(record, avroRecord);
        }
    }

    protected GenericRecord rewriteRecord(GenericRecord record) {
        return HoodieAvroUtils.rewriteRecord(record, this.writerSchema);
    }

    public abstract WriteStatus close();

    public abstract WriteStatus getWriteStatus();

    @Override
    protected FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }
}

