/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compact.strategy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.compact.strategy.CompactionStrategy;

public class BoundedIOCompactionStrategy
extends CompactionStrategy {
    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        ArrayList finalOperations = Lists.newArrayList();
        long targetIORemaining = writeConfig.getTargetIOPerCompactionInMB();
        for (HoodieCompactionOperation op : operations) {
            long opIo = op.getMetrics().get("TOTAL_IO_MB").longValue();
            finalOperations.add(op);
            if ((targetIORemaining -= opIo) > 0L) continue;
            return finalOperations;
        }
        return finalOperations;
    }
}

