/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compact.strategy;

import com.google.common.annotations.VisibleForTesting;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.compact.strategy.DayBasedCompactionStrategy;

public class BoundedPartitionAwareCompactionStrategy
extends DayBasedCompactionStrategy {
    SimpleDateFormat dateFormat = new SimpleDateFormat(datePartitionFormat);

    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        String earliestPartitionPathToCompact = this.dateFormat.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday(-1 * writeConfig.getTargetPartitionsPerDayBasedCompaction()));
        return operations.stream().collect(Collectors.groupingBy(HoodieCompactionOperation::getPartitionPath)).entrySet().stream().sorted(Map.Entry.comparingByKey(comparator)).filter(e -> comparator.compare(earliestPartitionPathToCompact, e.getKey()) >= 0).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
    }

    @Override
    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> partitionPaths) {
        String earliestPartitionPathToCompact = this.dateFormat.format(BoundedPartitionAwareCompactionStrategy.getDateAtOffsetFromToday(-1 * writeConfig.getTargetPartitionsPerDayBasedCompaction()));
        return partitionPaths.stream().map(partition -> partition.replace("/", "-")).sorted(Comparator.reverseOrder()).map(partitionPath -> partitionPath.replace("-", "/")).filter(e -> comparator.compare(earliestPartitionPathToCompact, e) >= 0).collect(Collectors.toList());
    }

    @VisibleForTesting
    public static Date getDateAtOffsetFromToday(int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, offset);
        return calendar.getTime();
    }
}

