/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compact.strategy;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;

public abstract class CompactionStrategy
implements Serializable {
    public static final String TOTAL_IO_READ_MB = "TOTAL_IO_READ_MB";
    public static final String TOTAL_IO_WRITE_MB = "TOTAL_IO_WRITE_MB";
    public static final String TOTAL_IO_MB = "TOTAL_IO_MB";
    public static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILES_SIZE";
    public static final String TOTAL_LOG_FILES = "TOTAL_LOG_FILES";

    public Map<String, Double> captureMetrics(HoodieWriteConfig writeConfig, Option<HoodieBaseFile> dataFile, String partitionPath, List<HoodieLogFile> logFiles) {
        HashMap metrics = Maps.newHashMap();
        Long defaultMaxParquetFileSize = writeConfig.getParquetMaxFileSize();
        Long totalLogFileSize = logFiles.stream().map(HoodieLogFile::getFileSize).filter(size -> size >= 0L).reduce((size1, size2) -> size1 + size2).orElse(0L);
        Long totalIORead = FSUtils.getSizeInMB((dataFile.isPresent() ? dataFile.get().getFileSize() : 0L) + totalLogFileSize);
        Long totalIOWrite = FSUtils.getSizeInMB(dataFile.isPresent() ? dataFile.get().getFileSize() : defaultMaxParquetFileSize.longValue());
        Long totalIO = totalIORead + totalIOWrite;
        metrics.put(TOTAL_IO_READ_MB, totalIORead.doubleValue());
        metrics.put(TOTAL_IO_WRITE_MB, totalIOWrite.doubleValue());
        metrics.put(TOTAL_IO_MB, totalIO.doubleValue());
        metrics.put(TOTAL_LOG_FILE_SIZE, totalLogFileSize.doubleValue());
        metrics.put(TOTAL_LOG_FILES, Double.valueOf(logFiles.size()));
        return metrics;
    }

    public HoodieCompactionPlan generateCompactionPlan(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return HoodieCompactionPlan.newBuilder().setOperations(this.orderAndFilter(writeConfig, operations, pendingCompactionPlans)).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).build();
    }

    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return operations;
    }

    public List<String> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        return allPartitionPaths;
    }
}

