/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compact.strategy;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.compact.strategy.BoundedIOCompactionStrategy;

public class LogFileSizeBasedCompactionStrategy
extends BoundedIOCompactionStrategy
implements Comparator<HoodieCompactionOperation> {
    private static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILE_SIZE";

    @Override
    public Map<String, Double> captureMetrics(HoodieWriteConfig config, Option<HoodieBaseFile> dataFile, String partitionPath, List<HoodieLogFile> logFiles) {
        Map<String, Double> metrics = super.captureMetrics(config, dataFile, partitionPath, logFiles);
        Long totalLogFileSize = logFiles.stream().map(HoodieLogFile::getFileSize).filter(size -> size >= 0L).reduce(Long::sum).orElse(0L);
        metrics.put(TOTAL_LOG_FILE_SIZE, totalLogFileSize.doubleValue());
        return metrics;
    }

    @Override
    public List<HoodieCompactionOperation> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return super.orderAndFilter(writeConfig, operations.stream().sorted(this).collect(Collectors.toList()), pendingCompactionPlans);
    }

    @Override
    public int compare(HoodieCompactionOperation op1, HoodieCompactionOperation op2) {
        Long totalLogSize1 = op1.getMetrics().get(TOTAL_LOG_FILE_SIZE).longValue();
        Long totalLogSize2 = op2.getMetrics().get(TOTAL_LOG_FILE_SIZE).longValue();
        return totalLogSize2.compareTo(totalLogSize1);
    }
}

