/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.io.storage.HoodieWrapperFileSystem;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.FSUtils;
import org.apache.hudi.common.util.HoodieAvroUtils;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.HoodieStorageWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.spark.TaskContext;

public class HoodieParquetWriter<T extends HoodieRecordPayload, R extends IndexedRecord>
extends ParquetWriter<IndexedRecord>
implements HoodieStorageWriter<R> {
    private static AtomicLong recordIndex = new AtomicLong(1L);
    private final Path file;
    private final HoodieWrapperFileSystem fs;
    private final long maxFileSize;
    private final HoodieAvroWriteSupport writeSupport;
    private final String commitTime;
    private final Schema schema;

    public HoodieParquetWriter(String commitTime, Path file, HoodieParquetConfig parquetConfig, Schema schema) throws IOException {
        super(HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf()), ParquetFileWriter.Mode.CREATE, (WriteSupport)parquetConfig.getWriteSupport(), parquetConfig.getCompressionCodecName(), parquetConfig.getBlockSize(), parquetConfig.getPageSize(), parquetConfig.getPageSize(), true, false, ParquetWriter.DEFAULT_WRITER_VERSION, HoodieParquetWriter.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.file = HoodieWrapperFileSystem.convertToHoodiePath(file, parquetConfig.getHadoopConf());
        this.fs = (HoodieWrapperFileSystem)this.file.getFileSystem(HoodieParquetWriter.registerFileSystem(file, parquetConfig.getHadoopConf()));
        this.maxFileSize = parquetConfig.getMaxFileSize() + Math.round((double)parquetConfig.getMaxFileSize() * parquetConfig.getCompressionRatio());
        this.writeSupport = parquetConfig.getWriteSupport();
        this.commitTime = commitTime;
        this.schema = schema;
    }

    public static Configuration registerFileSystem(Path file, Configuration conf) {
        Configuration returnConf = new Configuration(conf);
        String scheme = FSUtils.getFs(file.toString(), conf).getScheme();
        returnConf.set("fs." + HoodieWrapperFileSystem.getHoodieScheme(scheme) + ".impl", HoodieWrapperFileSystem.class.getName());
        return returnConf;
    }

    @Override
    public void writeAvroWithMetadata(R avroRecord, HoodieRecord record) throws IOException {
        String seqId = HoodieRecord.generateSequenceId(this.commitTime, TaskContext.getPartitionId(), recordIndex.getAndIncrement());
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, record.getRecordKey(), record.getPartitionPath(), this.file.getName());
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, this.commitTime, seqId);
        super.write(avroRecord);
        this.writeSupport.add(record.getRecordKey());
    }

    @Override
    public boolean canWrite() {
        return this.fs.getBytesWritten(this.file) < this.maxFileSize;
    }

    @Override
    public void writeAvro(String key, IndexedRecord object) throws IOException {
        super.write((Object)object);
        this.writeSupport.add(key);
    }
}

